/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.AttributeError;
import software.amazon.awssdk.services.datazone.model.AttributesErrorsCopier;
import software.amazon.awssdk.services.datazone.model.BatchGetAttributeItemsCopier;
import software.amazon.awssdk.services.datazone.model.BatchGetAttributeOutput;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetAttributesMetadataResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, BatchGetAttributesMetadataResponse> {
    private static final SdkField<List<BatchGetAttributeOutput>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attributes").getter(BatchGetAttributesMetadataResponse.getter(BatchGetAttributesMetadataResponse::attributes)).setter(BatchGetAttributesMetadataResponse.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetAttributeOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AttributeError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchGetAttributesMetadataResponse.getter(BatchGetAttributesMetadataResponse::errors)).setter(BatchGetAttributesMetadataResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetAttributesMetadataResponse.memberNameToFieldInitializer();
    private final List<BatchGetAttributeOutput> attributes;
    private final List<AttributeError> errors;

    private BatchGetAttributesMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
        this.errors = builder.errors;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<BatchGetAttributeOutput> attributes() {
        return this.attributes;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<AttributeError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAttributesMetadataResponse)) {
            return false;
        }
        BatchGetAttributesMetadataResponse other = (BatchGetAttributesMetadataResponse)((Object)obj);
        return this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetAttributesMetadataResponse").add("Attributes", this.hasAttributes() ? this.attributes() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAttributesMetadataResponse, T> g) {
        return obj -> g.apply((BatchGetAttributesMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private List<BatchGetAttributeOutput> attributes = DefaultSdkAutoConstructList.getInstance();
        private List<AttributeError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAttributesMetadataResponse model) {
            super(model);
            this.attributes(model.attributes);
            this.errors(model.errors);
        }

        public final List<BatchGetAttributeOutput.Builder> getAttributes() {
            List<BatchGetAttributeOutput.Builder> result = BatchGetAttributeItemsCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<BatchGetAttributeOutput.BuilderImpl> attributes) {
            this.attributes = BatchGetAttributeItemsCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<BatchGetAttributeOutput> attributes) {
            this.attributes = BatchGetAttributeItemsCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(BatchGetAttributeOutput ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<BatchGetAttributeOutput.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (BatchGetAttributeOutput)((BatchGetAttributeOutput.Builder)BatchGetAttributeOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AttributeError.Builder> getErrors() {
            List<AttributeError.Builder> result = AttributesErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<AttributeError.BuilderImpl> errors) {
            this.errors = AttributesErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<AttributeError> errors) {
            this.errors = AttributesErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(AttributeError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<AttributeError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (AttributeError)((AttributeError.Builder)AttributeError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetAttributesMetadataResponse build() {
            return new BatchGetAttributesMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetAttributesMetadataResponse> {
        public Builder attributes(Collection<BatchGetAttributeOutput> var1);

        public Builder attributes(BatchGetAttributeOutput ... var1);

        public Builder attributes(Consumer<BatchGetAttributeOutput.Builder> ... var1);

        public Builder errors(Collection<AttributeError> var1);

        public Builder errors(AttributeError ... var1);

        public Builder errors(Consumer<AttributeError.Builder> ... var1);
    }
}

