/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProjectRequest extends DataZoneRequest implements
        ToCopyableBuilder<UpdateProjectRequest.Builder, UpdateProjectRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateProjectRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(UpdateProjectRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> DOMAIN_UNIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainUnitId").getter(getter(UpdateProjectRequest::domainUnitId)).setter(setter(Builder::domainUnitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainUnitId").build()).build();

    private static final SdkField<EnvironmentDeploymentDetails> ENVIRONMENT_DEPLOYMENT_DETAILS_FIELD = SdkField
            .<EnvironmentDeploymentDetails> builder(MarshallingType.SDK_POJO)
            .memberName("environmentDeploymentDetails")
            .getter(getter(UpdateProjectRequest::environmentDeploymentDetails))
            .setter(setter(Builder::environmentDeploymentDetails))
            .constructor(EnvironmentDeploymentDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentDeploymentDetails")
                    .build()).build();

    private static final SdkField<List<String>> GLOSSARY_TERMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("glossaryTerms")
            .getter(getter(UpdateProjectRequest::glossaryTerms))
            .setter(setter(Builder::glossaryTerms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(UpdateProjectRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateProjectRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROJECT_PROFILE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectProfileVersion").getter(getter(UpdateProjectRequest::projectProfileVersion))
            .setter(setter(Builder::projectProfileVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectProfileVersion").build())
            .build();

    private static final SdkField<Map<String, String>> RESOURCE_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("resourceTags")
            .getter(getter(UpdateProjectRequest::resourceTags))
            .setter(setter(Builder::resourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<EnvironmentConfigurationUserParameter>> USER_PARAMETERS_FIELD = SdkField
            .<List<EnvironmentConfigurationUserParameter>> builder(MarshallingType.LIST)
            .memberName("userParameters")
            .getter(getter(UpdateProjectRequest::userParameters))
            .setter(setter(Builder::userParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentConfigurationUserParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentConfigurationUserParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            DOMAIN_IDENTIFIER_FIELD, DOMAIN_UNIT_ID_FIELD, ENVIRONMENT_DEPLOYMENT_DETAILS_FIELD, GLOSSARY_TERMS_FIELD,
            IDENTIFIER_FIELD, NAME_FIELD, PROJECT_PROFILE_VERSION_FIELD, RESOURCE_TAGS_FIELD, USER_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String description;

    private final String domainIdentifier;

    private final String domainUnitId;

    private final EnvironmentDeploymentDetails environmentDeploymentDetails;

    private final List<String> glossaryTerms;

    private final String identifier;

    private final String name;

    private final String projectProfileVersion;

    private final Map<String, String> resourceTags;

    private final List<EnvironmentConfigurationUserParameter> userParameters;

    private UpdateProjectRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.domainUnitId = builder.domainUnitId;
        this.environmentDeploymentDetails = builder.environmentDeploymentDetails;
        this.glossaryTerms = builder.glossaryTerms;
        this.identifier = builder.identifier;
        this.name = builder.name;
        this.projectProfileVersion = builder.projectProfileVersion;
        this.resourceTags = builder.resourceTags;
        this.userParameters = builder.userParameters;
    }

    /**
     * <p>
     * The description to be updated as part of the <code>UpdateProject</code> action.
     * </p>
     * 
     * @return The description to be updated as part of the <code>UpdateProject</code> action.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain where a project is being updated.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain where a project is being updated.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The ID of the domain unit.
     * </p>
     * 
     * @return The ID of the domain unit.
     */
    public final String domainUnitId() {
        return domainUnitId;
    }

    /**
     * <p>
     * The environment deployment details of the project.
     * </p>
     * 
     * @return The environment deployment details of the project.
     */
    public final EnvironmentDeploymentDetails environmentDeploymentDetails() {
        return environmentDeploymentDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlossaryTerms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGlossaryTerms() {
        return glossaryTerms != null && !(glossaryTerms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The glossary terms to be updated as part of the <code>UpdateProject</code> action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlossaryTerms} method.
     * </p>
     * 
     * @return The glossary terms to be updated as part of the <code>UpdateProject</code> action.
     */
    public final List<String> glossaryTerms() {
        return glossaryTerms;
    }

    /**
     * <p>
     * The identifier of the project that is to be updated.
     * </p>
     * 
     * @return The identifier of the project that is to be updated.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The name to be updated as part of the <code>UpdateProject</code> action.
     * </p>
     * 
     * @return The name to be updated as part of the <code>UpdateProject</code> action.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The project profile version to which the project should be updated. You can only specify the following string for
     * this parameter: <code>latest</code>.
     * </p>
     * 
     * @return The project profile version to which the project should be updated. You can only specify the following
     *         string for this parameter: <code>latest</code>.
     */
    public final String projectProfileVersion() {
        return projectProfileVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTags() {
        return resourceTags != null && !(resourceTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The resource tags of the project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTags} method.
     * </p>
     * 
     * @return The resource tags of the project.
     */
    public final Map<String, String> resourceTags() {
        return resourceTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserParameters() {
        return userParameters != null && !(userParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user parameters of the project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserParameters} method.
     * </p>
     * 
     * @return The user parameters of the project.
     */
    public final List<EnvironmentConfigurationUserParameter> userParameters() {
        return userParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(domainUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentDeploymentDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlossaryTerms() ? glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(projectProfileVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTags() ? resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserParameters() ? userParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProjectRequest)) {
            return false;
        }
        UpdateProjectRequest other = (UpdateProjectRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(domainUnitId(), other.domainUnitId())
                && Objects.equals(environmentDeploymentDetails(), other.environmentDeploymentDetails())
                && hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(glossaryTerms(), other.glossaryTerms())
                && Objects.equals(identifier(), other.identifier()) && Objects.equals(name(), other.name())
                && Objects.equals(projectProfileVersion(), other.projectProfileVersion())
                && hasResourceTags() == other.hasResourceTags() && Objects.equals(resourceTags(), other.resourceTags())
                && hasUserParameters() == other.hasUserParameters() && Objects.equals(userParameters(), other.userParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProjectRequest")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DomainIdentifier", domainIdentifier()).add("DomainUnitId", domainUnitId())
                .add("EnvironmentDeploymentDetails", environmentDeploymentDetails())
                .add("GlossaryTerms", hasGlossaryTerms() ? glossaryTerms() : null).add("Identifier", identifier())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ProjectProfileVersion", projectProfileVersion())
                .add("ResourceTags", hasResourceTags() ? resourceTags() : null)
                .add("UserParameters", hasUserParameters() ? userParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "domainUnitId":
            return Optional.ofNullable(clazz.cast(domainUnitId()));
        case "environmentDeploymentDetails":
            return Optional.ofNullable(clazz.cast(environmentDeploymentDetails()));
        case "glossaryTerms":
            return Optional.ofNullable(clazz.cast(glossaryTerms()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "projectProfileVersion":
            return Optional.ofNullable(clazz.cast(projectProfileVersion()));
        case "resourceTags":
            return Optional.ofNullable(clazz.cast(resourceTags()));
        case "userParameters":
            return Optional.ofNullable(clazz.cast(userParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("domainUnitId", DOMAIN_UNIT_ID_FIELD);
        map.put("environmentDeploymentDetails", ENVIRONMENT_DEPLOYMENT_DETAILS_FIELD);
        map.put("glossaryTerms", GLOSSARY_TERMS_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("projectProfileVersion", PROJECT_PROFILE_VERSION_FIELD);
        map.put("resourceTags", RESOURCE_TAGS_FIELD);
        map.put("userParameters", USER_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProjectRequest, T> g) {
        return obj -> g.apply((UpdateProjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateProjectRequest> {
        /**
         * <p>
         * The description to be updated as part of the <code>UpdateProject</code> action.
         * </p>
         * 
         * @param description
         *        The description to be updated as part of the <code>UpdateProject</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the Amazon DataZone domain where a project is being updated.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the Amazon DataZone domain where a project is being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The ID of the domain unit.
         * </p>
         * 
         * @param domainUnitId
         *        The ID of the domain unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainUnitId(String domainUnitId);

        /**
         * <p>
         * The environment deployment details of the project.
         * </p>
         * 
         * @param environmentDeploymentDetails
         *        The environment deployment details of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentDeploymentDetails(EnvironmentDeploymentDetails environmentDeploymentDetails);

        /**
         * <p>
         * The environment deployment details of the project.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnvironmentDeploymentDetails.Builder}
         * avoiding the need to create one manually via {@link EnvironmentDeploymentDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnvironmentDeploymentDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #environmentDeploymentDetails(EnvironmentDeploymentDetails)}.
         * 
         * @param environmentDeploymentDetails
         *        a consumer that will call methods on {@link EnvironmentDeploymentDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentDeploymentDetails(EnvironmentDeploymentDetails)
         */
        default Builder environmentDeploymentDetails(Consumer<EnvironmentDeploymentDetails.Builder> environmentDeploymentDetails) {
            return environmentDeploymentDetails(EnvironmentDeploymentDetails.builder()
                    .applyMutation(environmentDeploymentDetails).build());
        }

        /**
         * <p>
         * The glossary terms to be updated as part of the <code>UpdateProject</code> action.
         * </p>
         * 
         * @param glossaryTerms
         *        The glossary terms to be updated as part of the <code>UpdateProject</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(Collection<String> glossaryTerms);

        /**
         * <p>
         * The glossary terms to be updated as part of the <code>UpdateProject</code> action.
         * </p>
         * 
         * @param glossaryTerms
         *        The glossary terms to be updated as part of the <code>UpdateProject</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(String... glossaryTerms);

        /**
         * <p>
         * The identifier of the project that is to be updated.
         * </p>
         * 
         * @param identifier
         *        The identifier of the project that is to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The name to be updated as part of the <code>UpdateProject</code> action.
         * </p>
         * 
         * @param name
         *        The name to be updated as part of the <code>UpdateProject</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The project profile version to which the project should be updated. You can only specify the following string
         * for this parameter: <code>latest</code>.
         * </p>
         * 
         * @param projectProfileVersion
         *        The project profile version to which the project should be updated. You can only specify the following
         *        string for this parameter: <code>latest</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectProfileVersion(String projectProfileVersion);

        /**
         * <p>
         * The resource tags of the project.
         * </p>
         * 
         * @param resourceTags
         *        The resource tags of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(Map<String, String> resourceTags);

        /**
         * <p>
         * The user parameters of the project.
         * </p>
         * 
         * @param userParameters
         *        The user parameters of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userParameters(Collection<EnvironmentConfigurationUserParameter> userParameters);

        /**
         * <p>
         * The user parameters of the project.
         * </p>
         * 
         * @param userParameters
         *        The user parameters of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userParameters(EnvironmentConfigurationUserParameter... userParameters);

        /**
         * <p>
         * The user parameters of the project.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.EnvironmentConfigurationUserParameter.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.datazone.model.EnvironmentConfigurationUserParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.EnvironmentConfigurationUserParameter.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #userParameters(List<EnvironmentConfigurationUserParameter>)}.
         * 
         * @param userParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.EnvironmentConfigurationUserParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userParameters(java.util.Collection<EnvironmentConfigurationUserParameter>)
         */
        Builder userParameters(Consumer<EnvironmentConfigurationUserParameter.Builder>... userParameters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String description;

        private String domainIdentifier;

        private String domainUnitId;

        private EnvironmentDeploymentDetails environmentDeploymentDetails;

        private List<String> glossaryTerms = DefaultSdkAutoConstructList.getInstance();

        private String identifier;

        private String name;

        private String projectProfileVersion;

        private Map<String, String> resourceTags = DefaultSdkAutoConstructMap.getInstance();

        private List<EnvironmentConfigurationUserParameter> userParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProjectRequest model) {
            super(model);
            description(model.description);
            domainIdentifier(model.domainIdentifier);
            domainUnitId(model.domainUnitId);
            environmentDeploymentDetails(model.environmentDeploymentDetails);
            glossaryTerms(model.glossaryTerms);
            identifier(model.identifier);
            name(model.name);
            projectProfileVersion(model.projectProfileVersion);
            resourceTags(model.resourceTags);
            userParameters(model.userParameters);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getDomainUnitId() {
            return domainUnitId;
        }

        public final void setDomainUnitId(String domainUnitId) {
            this.domainUnitId = domainUnitId;
        }

        @Override
        public final Builder domainUnitId(String domainUnitId) {
            this.domainUnitId = domainUnitId;
            return this;
        }

        public final EnvironmentDeploymentDetails.Builder getEnvironmentDeploymentDetails() {
            return environmentDeploymentDetails != null ? environmentDeploymentDetails.toBuilder() : null;
        }

        public final void setEnvironmentDeploymentDetails(EnvironmentDeploymentDetails.BuilderImpl environmentDeploymentDetails) {
            this.environmentDeploymentDetails = environmentDeploymentDetails != null ? environmentDeploymentDetails.build()
                    : null;
        }

        @Override
        public final Builder environmentDeploymentDetails(EnvironmentDeploymentDetails environmentDeploymentDetails) {
            this.environmentDeploymentDetails = environmentDeploymentDetails;
            return this;
        }

        public final Collection<String> getGlossaryTerms() {
            if (glossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return glossaryTerms;
        }

        public final void setGlossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(String... glossaryTerms) {
            glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProjectProfileVersion() {
            return projectProfileVersion;
        }

        public final void setProjectProfileVersion(String projectProfileVersion) {
            this.projectProfileVersion = projectProfileVersion;
        }

        @Override
        public final Builder projectProfileVersion(String projectProfileVersion) {
            this.projectProfileVersion = projectProfileVersion;
            return this;
        }

        public final Map<String, String> getResourceTags() {
            if (resourceTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return resourceTags;
        }

        public final void setResourceTags(Map<String, String> resourceTags) {
            this.resourceTags = UpdateProjectInputResourceTagsMapCopier.copy(resourceTags);
        }

        @Override
        public final Builder resourceTags(Map<String, String> resourceTags) {
            this.resourceTags = UpdateProjectInputResourceTagsMapCopier.copy(resourceTags);
            return this;
        }

        public final List<EnvironmentConfigurationUserParameter.Builder> getUserParameters() {
            List<EnvironmentConfigurationUserParameter.Builder> result = EnvironmentConfigurationUserParametersListCopier
                    .copyToBuilder(this.userParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserParameters(Collection<EnvironmentConfigurationUserParameter.BuilderImpl> userParameters) {
            this.userParameters = EnvironmentConfigurationUserParametersListCopier.copyFromBuilder(userParameters);
        }

        @Override
        public final Builder userParameters(Collection<EnvironmentConfigurationUserParameter> userParameters) {
            this.userParameters = EnvironmentConfigurationUserParametersListCopier.copy(userParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(EnvironmentConfigurationUserParameter... userParameters) {
            userParameters(Arrays.asList(userParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(Consumer<EnvironmentConfigurationUserParameter.Builder>... userParameters) {
            userParameters(Stream.of(userParameters)
                    .map(c -> EnvironmentConfigurationUserParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProjectRequest build() {
            return new UpdateProjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
