/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEnvironmentProfileResponse extends DataZoneResponse implements
        ToCopyableBuilder<UpdateEnvironmentProfileResponse.Builder, UpdateEnvironmentProfileResponse> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountId").getter(getter(UpdateEnvironmentProfileResponse::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountRegion").getter(getter(UpdateEnvironmentProfileResponse::awsAccountRegion))
            .setter(setter(Builder::awsAccountRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountRegion").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(UpdateEnvironmentProfileResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(UpdateEnvironmentProfileResponse::createdBy))
            .setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateEnvironmentProfileResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(UpdateEnvironmentProfileResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> ENVIRONMENT_BLUEPRINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentBlueprintId").getter(getter(UpdateEnvironmentProfileResponse::environmentBlueprintId))
            .setter(setter(Builder::environmentBlueprintId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentBlueprintId").build())
            .build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateEnvironmentProfileResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateEnvironmentProfileResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectId").getter(getter(UpdateEnvironmentProfileResponse::projectId))
            .setter(setter(Builder::projectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(UpdateEnvironmentProfileResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<CustomParameter>> USER_PARAMETERS_FIELD = SdkField
            .<List<CustomParameter>> builder(MarshallingType.LIST)
            .memberName("userParameters")
            .getter(getter(UpdateEnvironmentProfileResponse::userParameters))
            .setter(setter(Builder::userParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            AWS_ACCOUNT_REGION_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD,
            ENVIRONMENT_BLUEPRINT_ID_FIELD, ID_FIELD, NAME_FIELD, PROJECT_ID_FIELD, UPDATED_AT_FIELD, USER_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String awsAccountRegion;

    private final Instant createdAt;

    private final String createdBy;

    private final String description;

    private final String domainId;

    private final String environmentBlueprintId;

    private final String id;

    private final String name;

    private final String projectId;

    private final Instant updatedAt;

    private final List<CustomParameter> userParameters;

    private UpdateEnvironmentProfileResponse(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.awsAccountRegion = builder.awsAccountRegion;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.environmentBlueprintId = builder.environmentBlueprintId;
        this.id = builder.id;
        this.name = builder.name;
        this.projectId = builder.projectId;
        this.updatedAt = builder.updatedAt;
        this.userParameters = builder.userParameters;
    }

    /**
     * <p>
     * The Amazon Web Services account in which a specified environment profile is to be udpated.
     * </p>
     * 
     * @return The Amazon Web Services account in which a specified environment profile is to be udpated.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The Amazon Web Services Region in which a specified environment profile is to be updated.
     * </p>
     * 
     * @return The Amazon Web Services Region in which a specified environment profile is to be updated.
     */
    public final String awsAccountRegion() {
        return awsAccountRegion;
    }

    /**
     * <p>
     * The timestamp of when the environment profile was created.
     * </p>
     * 
     * @return The timestamp of when the environment profile was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Amazon DataZone user who created the environment profile.
     * </p>
     * 
     * @return The Amazon DataZone user who created the environment profile.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The description to be updated as part of the <code>UpdateEnvironmentProfile</code> action.
     * </p>
     * 
     * @return The description to be updated as part of the <code>UpdateEnvironmentProfile</code> action.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain in which the environment profile is to be updated.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain in which the environment profile is to be updated.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The identifier of the blueprint of the environment profile that is to be updated.
     * </p>
     * 
     * @return The identifier of the blueprint of the environment profile that is to be updated.
     */
    public final String environmentBlueprintId() {
        return environmentBlueprintId;
    }

    /**
     * <p>
     * The identifier of the environment profile that is to be udpated.
     * </p>
     * 
     * @return The identifier of the environment profile that is to be udpated.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name to be updated as part of the <code>UpdateEnvironmentProfile</code> action.
     * </p>
     * 
     * @return The name to be updated as part of the <code>UpdateEnvironmentProfile</code> action.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier of the project of the environment profile that is to be updated.
     * </p>
     * 
     * @return The identifier of the project of the environment profile that is to be updated.
     */
    public final String projectId() {
        return projectId;
    }

    /**
     * <p>
     * The timestamp of when the environment profile was updated.
     * </p>
     * 
     * @return The timestamp of when the environment profile was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserParameters() {
        return userParameters != null && !(userParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user parameters to be updated as part of the <code>UpdateEnvironmentProfile</code> action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserParameters} method.
     * </p>
     * 
     * @return The user parameters to be updated as part of the <code>UpdateEnvironmentProfile</code> action.
     */
    public final List<CustomParameter> userParameters() {
        return userParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountRegion());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentBlueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(projectId());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserParameters() ? userParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnvironmentProfileResponse)) {
            return false;
        }
        UpdateEnvironmentProfileResponse other = (UpdateEnvironmentProfileResponse) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(awsAccountRegion(), other.awsAccountRegion()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(description(), other.description())
                && Objects.equals(domainId(), other.domainId())
                && Objects.equals(environmentBlueprintId(), other.environmentBlueprintId()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(projectId(), other.projectId())
                && Objects.equals(updatedAt(), other.updatedAt()) && hasUserParameters() == other.hasUserParameters()
                && Objects.equals(userParameters(), other.userParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEnvironmentProfileResponse").add("AwsAccountId", awsAccountId())
                .add("AwsAccountRegion", awsAccountRegion()).add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", domainId())
                .add("EnvironmentBlueprintId", environmentBlueprintId()).add("Id", id())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("ProjectId", projectId())
                .add("UpdatedAt", updatedAt()).add("UserParameters", hasUserParameters() ? userParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "awsAccountRegion":
            return Optional.ofNullable(clazz.cast(awsAccountRegion()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "environmentBlueprintId":
            return Optional.ofNullable(clazz.cast(environmentBlueprintId()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "projectId":
            return Optional.ofNullable(clazz.cast(projectId()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "userParameters":
            return Optional.ofNullable(clazz.cast(userParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("awsAccountRegion", AWS_ACCOUNT_REGION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("environmentBlueprintId", ENVIRONMENT_BLUEPRINT_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("projectId", PROJECT_ID_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("userParameters", USER_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEnvironmentProfileResponse, T> g) {
        return obj -> g.apply((UpdateEnvironmentProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateEnvironmentProfileResponse> {
        /**
         * <p>
         * The Amazon Web Services account in which a specified environment profile is to be udpated.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services account in which a specified environment profile is to be udpated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The Amazon Web Services Region in which a specified environment profile is to be updated.
         * </p>
         * 
         * @param awsAccountRegion
         *        The Amazon Web Services Region in which a specified environment profile is to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountRegion(String awsAccountRegion);

        /**
         * <p>
         * The timestamp of when the environment profile was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the environment profile was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Amazon DataZone user who created the environment profile.
         * </p>
         * 
         * @param createdBy
         *        The Amazon DataZone user who created the environment profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The description to be updated as part of the <code>UpdateEnvironmentProfile</code> action.
         * </p>
         * 
         * @param description
         *        The description to be updated as part of the <code>UpdateEnvironmentProfile</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the Amazon DataZone domain in which the environment profile is to be updated.
         * </p>
         * 
         * @param domainId
         *        The identifier of the Amazon DataZone domain in which the environment profile is to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The identifier of the blueprint of the environment profile that is to be updated.
         * </p>
         * 
         * @param environmentBlueprintId
         *        The identifier of the blueprint of the environment profile that is to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentBlueprintId(String environmentBlueprintId);

        /**
         * <p>
         * The identifier of the environment profile that is to be udpated.
         * </p>
         * 
         * @param id
         *        The identifier of the environment profile that is to be udpated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name to be updated as part of the <code>UpdateEnvironmentProfile</code> action.
         * </p>
         * 
         * @param name
         *        The name to be updated as part of the <code>UpdateEnvironmentProfile</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier of the project of the environment profile that is to be updated.
         * </p>
         * 
         * @param projectId
         *        The identifier of the project of the environment profile that is to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectId(String projectId);

        /**
         * <p>
         * The timestamp of when the environment profile was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when the environment profile was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user parameters to be updated as part of the <code>UpdateEnvironmentProfile</code> action.
         * </p>
         * 
         * @param userParameters
         *        The user parameters to be updated as part of the <code>UpdateEnvironmentProfile</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userParameters(Collection<CustomParameter> userParameters);

        /**
         * <p>
         * The user parameters to be updated as part of the <code>UpdateEnvironmentProfile</code> action.
         * </p>
         * 
         * @param userParameters
         *        The user parameters to be updated as part of the <code>UpdateEnvironmentProfile</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userParameters(CustomParameter... userParameters);

        /**
         * <p>
         * The user parameters to be updated as part of the <code>UpdateEnvironmentProfile</code> action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.CustomParameter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.datazone.model.CustomParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.CustomParameter.Builder#build()} is called immediately
         * and its result is passed to {@link #userParameters(List<CustomParameter>)}.
         * 
         * @param userParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.CustomParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userParameters(java.util.Collection<CustomParameter>)
         */
        Builder userParameters(Consumer<CustomParameter.Builder>... userParameters);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private String awsAccountId;

        private String awsAccountRegion;

        private Instant createdAt;

        private String createdBy;

        private String description;

        private String domainId;

        private String environmentBlueprintId;

        private String id;

        private String name;

        private String projectId;

        private Instant updatedAt;

        private List<CustomParameter> userParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnvironmentProfileResponse model) {
            super(model);
            awsAccountId(model.awsAccountId);
            awsAccountRegion(model.awsAccountRegion);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            description(model.description);
            domainId(model.domainId);
            environmentBlueprintId(model.environmentBlueprintId);
            id(model.id);
            name(model.name);
            projectId(model.projectId);
            updatedAt(model.updatedAt);
            userParameters(model.userParameters);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAwsAccountRegion() {
            return awsAccountRegion;
        }

        public final void setAwsAccountRegion(String awsAccountRegion) {
            this.awsAccountRegion = awsAccountRegion;
        }

        @Override
        public final Builder awsAccountRegion(String awsAccountRegion) {
            this.awsAccountRegion = awsAccountRegion;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getEnvironmentBlueprintId() {
            return environmentBlueprintId;
        }

        public final void setEnvironmentBlueprintId(String environmentBlueprintId) {
            this.environmentBlueprintId = environmentBlueprintId;
        }

        @Override
        public final Builder environmentBlueprintId(String environmentBlueprintId) {
            this.environmentBlueprintId = environmentBlueprintId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProjectId() {
            return projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<CustomParameter.Builder> getUserParameters() {
            List<CustomParameter.Builder> result = CustomParameterListCopier.copyToBuilder(this.userParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserParameters(Collection<CustomParameter.BuilderImpl> userParameters) {
            this.userParameters = CustomParameterListCopier.copyFromBuilder(userParameters);
        }

        @Override
        public final Builder userParameters(Collection<CustomParameter> userParameters) {
            this.userParameters = CustomParameterListCopier.copy(userParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(CustomParameter... userParameters) {
            userParameters(Arrays.asList(userParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(Consumer<CustomParameter.Builder>... userParameters) {
            userParameters(Stream.of(userParameters).map(c -> CustomParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public UpdateEnvironmentProfileResponse build() {
            return new UpdateEnvironmentProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
