/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDomainUnitResponse extends DataZoneResponse implements
        ToCopyableBuilder<UpdateDomainUnitResponse.Builder, UpdateDomainUnitResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(UpdateDomainUnitResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(UpdateDomainUnitResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateDomainUnitResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(UpdateDomainUnitResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateDomainUnitResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(UpdateDomainUnitResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdatedBy").getter(getter(UpdateDomainUnitResponse::lastUpdatedBy))
            .setter(setter(Builder::lastUpdatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedBy").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateDomainUnitResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<DomainUnitOwnerProperties>> OWNERS_FIELD = SdkField
            .<List<DomainUnitOwnerProperties>> builder(MarshallingType.LIST)
            .memberName("owners")
            .getter(getter(UpdateDomainUnitResponse::owners))
            .setter(setter(Builder::owners))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owners").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainUnitOwnerProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainUnitOwnerProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PARENT_DOMAIN_UNIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentDomainUnitId").getter(getter(UpdateDomainUnitResponse::parentDomainUnitId))
            .setter(setter(Builder::parentDomainUnitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentDomainUnitId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            CREATED_BY_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, ID_FIELD, LAST_UPDATED_AT_FIELD, LAST_UPDATED_BY_FIELD,
            NAME_FIELD, OWNERS_FIELD, PARENT_DOMAIN_UNIT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant createdAt;

    private final String createdBy;

    private final String description;

    private final String domainId;

    private final String id;

    private final Instant lastUpdatedAt;

    private final String lastUpdatedBy;

    private final String name;

    private final List<DomainUnitOwnerProperties> owners;

    private final String parentDomainUnitId;

    private UpdateDomainUnitResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.id = builder.id;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.name = builder.name;
        this.owners = builder.owners;
        this.parentDomainUnitId = builder.parentDomainUnitId;
    }

    /**
     * <p>
     * The time stamp at which the domain unit that you want to update was created.
     * </p>
     * 
     * @return The time stamp at which the domain unit that you want to update was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user who created the domain unit that you want to update.
     * </p>
     * 
     * @return The user who created the domain unit that you want to update.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The description of the domain unit that you want to update.
     * </p>
     * 
     * @return The description of the domain unit that you want to update.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the domain where you want to update the domain unit.
     * </p>
     * 
     * @return The ID of the domain where you want to update the domain unit.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The ID of the domain unit that you want to update.
     * </p>
     * 
     * @return The ID of the domain unit that you want to update.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The timestamp at which the domain unit was last updated.
     * </p>
     * 
     * @return The timestamp at which the domain unit was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The user who last updated the domain unit.
     * </p>
     * 
     * @return The user who last updated the domain unit.
     */
    public final String lastUpdatedBy() {
        return lastUpdatedBy;
    }

    /**
     * <p>
     * The name of the domain unit that you want to update.
     * </p>
     * 
     * @return The name of the domain unit that you want to update.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Owners property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOwners() {
        return owners != null && !(owners instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The owners of the domain unit that you want to update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOwners} method.
     * </p>
     * 
     * @return The owners of the domain unit that you want to update.
     */
    public final List<DomainUnitOwnerProperties> owners() {
        return owners;
    }

    /**
     * <p>
     * The ID of the parent domain unit.
     * </p>
     * 
     * @return The ID of the parent domain unit.
     */
    public final String parentDomainUnitId() {
        return parentDomainUnitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasOwners() ? owners() : null);
        hashCode = 31 * hashCode + Objects.hashCode(parentDomainUnitId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainUnitResponse)) {
            return false;
        }
        UpdateDomainUnitResponse other = (UpdateDomainUnitResponse) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(description(), other.description()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(id(), other.id()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(lastUpdatedBy(), other.lastUpdatedBy()) && Objects.equals(name(), other.name())
                && hasOwners() == other.hasOwners() && Objects.equals(owners(), other.owners())
                && Objects.equals(parentDomainUnitId(), other.parentDomainUnitId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDomainUnitResponse").add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", domainId())
                .add("Id", id()).add("LastUpdatedAt", lastUpdatedAt()).add("LastUpdatedBy", lastUpdatedBy())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Owners", hasOwners() ? owners() : null).add("ParentDomainUnitId", parentDomainUnitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "lastUpdatedBy":
            return Optional.ofNullable(clazz.cast(lastUpdatedBy()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "owners":
            return Optional.ofNullable(clazz.cast(owners()));
        case "parentDomainUnitId":
            return Optional.ofNullable(clazz.cast(parentDomainUnitId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("lastUpdatedBy", LAST_UPDATED_BY_FIELD);
        map.put("name", NAME_FIELD);
        map.put("owners", OWNERS_FIELD);
        map.put("parentDomainUnitId", PARENT_DOMAIN_UNIT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainUnitResponse, T> g) {
        return obj -> g.apply((UpdateDomainUnitResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDomainUnitResponse> {
        /**
         * <p>
         * The time stamp at which the domain unit that you want to update was created.
         * </p>
         * 
         * @param createdAt
         *        The time stamp at which the domain unit that you want to update was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user who created the domain unit that you want to update.
         * </p>
         * 
         * @param createdBy
         *        The user who created the domain unit that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The description of the domain unit that you want to update.
         * </p>
         * 
         * @param description
         *        The description of the domain unit that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the domain where you want to update the domain unit.
         * </p>
         * 
         * @param domainId
         *        The ID of the domain where you want to update the domain unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The ID of the domain unit that you want to update.
         * </p>
         * 
         * @param id
         *        The ID of the domain unit that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The timestamp at which the domain unit was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp at which the domain unit was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The user who last updated the domain unit.
         * </p>
         * 
         * @param lastUpdatedBy
         *        The user who last updated the domain unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedBy(String lastUpdatedBy);

        /**
         * <p>
         * The name of the domain unit that you want to update.
         * </p>
         * 
         * @param name
         *        The name of the domain unit that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The owners of the domain unit that you want to update.
         * </p>
         * 
         * @param owners
         *        The owners of the domain unit that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owners(Collection<DomainUnitOwnerProperties> owners);

        /**
         * <p>
         * The owners of the domain unit that you want to update.
         * </p>
         * 
         * @param owners
         *        The owners of the domain unit that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owners(DomainUnitOwnerProperties... owners);

        /**
         * <p>
         * The owners of the domain unit that you want to update.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.DomainUnitOwnerProperties.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.datazone.model.DomainUnitOwnerProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.DomainUnitOwnerProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #owners(List<DomainUnitOwnerProperties>)}.
         * 
         * @param owners
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.DomainUnitOwnerProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #owners(java.util.Collection<DomainUnitOwnerProperties>)
         */
        Builder owners(Consumer<DomainUnitOwnerProperties.Builder>... owners);

        /**
         * <p>
         * The ID of the parent domain unit.
         * </p>
         * 
         * @param parentDomainUnitId
         *        The ID of the parent domain unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentDomainUnitId(String parentDomainUnitId);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private Instant createdAt;

        private String createdBy;

        private String description;

        private String domainId;

        private String id;

        private Instant lastUpdatedAt;

        private String lastUpdatedBy;

        private String name;

        private List<DomainUnitOwnerProperties> owners = DefaultSdkAutoConstructList.getInstance();

        private String parentDomainUnitId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainUnitResponse model) {
            super(model);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            description(model.description);
            domainId(model.domainId);
            id(model.id);
            lastUpdatedAt(model.lastUpdatedAt);
            lastUpdatedBy(model.lastUpdatedBy);
            name(model.name);
            owners(model.owners);
            parentDomainUnitId(model.parentDomainUnitId);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getLastUpdatedBy() {
            return lastUpdatedBy;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<DomainUnitOwnerProperties.Builder> getOwners() {
            List<DomainUnitOwnerProperties.Builder> result = DomainUnitOwnersCopier.copyToBuilder(this.owners);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOwners(Collection<DomainUnitOwnerProperties.BuilderImpl> owners) {
            this.owners = DomainUnitOwnersCopier.copyFromBuilder(owners);
        }

        @Override
        public final Builder owners(Collection<DomainUnitOwnerProperties> owners) {
            this.owners = DomainUnitOwnersCopier.copy(owners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder owners(DomainUnitOwnerProperties... owners) {
            owners(Arrays.asList(owners));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder owners(Consumer<DomainUnitOwnerProperties.Builder>... owners) {
            owners(Stream.of(owners).map(c -> DomainUnitOwnerProperties.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getParentDomainUnitId() {
            return parentDomainUnitId;
        }

        public final void setParentDomainUnitId(String parentDomainUnitId) {
            this.parentDomainUnitId = parentDomainUnitId;
        }

        @Override
        public final Builder parentDomainUnitId(String parentDomainUnitId) {
            this.parentDomainUnitId = parentDomainUnitId;
            return this;
        }

        @Override
        public UpdateDomainUnitResponse build() {
            return new UpdateDomainUnitResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
