/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure indicating matched terms for an attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TextMatchItem implements SdkPojo, Serializable, ToCopyableBuilder<TextMatchItem.Builder, TextMatchItem> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attribute").getter(getter(TextMatchItem::attribute)).setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attribute").build()).build();

    private static final SdkField<List<MatchOffset>> MATCH_OFFSETS_FIELD = SdkField
            .<List<MatchOffset>> builder(MarshallingType.LIST)
            .memberName("matchOffsets")
            .getter(getter(TextMatchItem::matchOffsets))
            .setter(setter(Builder::matchOffsets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchOffsets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MatchOffset> builder(MarshallingType.SDK_POJO)
                                            .constructor(MatchOffset::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(TextMatchItem::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD,
            MATCH_OFFSETS_FIELD, TEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attribute;

    private final List<MatchOffset> matchOffsets;

    private final String text;

    private TextMatchItem(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.matchOffsets = builder.matchOffsets;
        this.text = builder.text;
    }

    /**
     * <p>
     * The name of the attribute.
     * </p>
     * 
     * @return The name of the attribute.
     */
    public final String attribute() {
        return attribute;
    }

    /**
     * For responses, this returns true if the service returned a value for the MatchOffsets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMatchOffsets() {
        return matchOffsets != null && !(matchOffsets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of offsets indicating matching terms in the TextMatchItem text.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchOffsets} method.
     * </p>
     * 
     * @return List of offsets indicating matching terms in the TextMatchItem text.
     */
    public final List<MatchOffset> matchOffsets() {
        return matchOffsets;
    }

    /**
     * <p>
     * Snippet of attribute text containing highlighted content.
     * </p>
     * 
     * @return Snippet of attribute text containing highlighted content.
     */
    public final String text() {
        return text;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attribute());
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchOffsets() ? matchOffsets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(text());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextMatchItem)) {
            return false;
        }
        TextMatchItem other = (TextMatchItem) obj;
        return Objects.equals(attribute(), other.attribute()) && hasMatchOffsets() == other.hasMatchOffsets()
                && Objects.equals(matchOffsets(), other.matchOffsets()) && Objects.equals(text(), other.text());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextMatchItem").add("Attribute", attribute())
                .add("MatchOffsets", hasMatchOffsets() ? matchOffsets() : null).add("Text", text()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attribute":
            return Optional.ofNullable(clazz.cast(attribute()));
        case "matchOffsets":
            return Optional.ofNullable(clazz.cast(matchOffsets()));
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attribute", ATTRIBUTE_FIELD);
        map.put("matchOffsets", MATCH_OFFSETS_FIELD);
        map.put("text", TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TextMatchItem, T> g) {
        return obj -> g.apply((TextMatchItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextMatchItem> {
        /**
         * <p>
         * The name of the attribute.
         * </p>
         * 
         * @param attribute
         *        The name of the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * List of offsets indicating matching terms in the TextMatchItem text.
         * </p>
         * 
         * @param matchOffsets
         *        List of offsets indicating matching terms in the TextMatchItem text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchOffsets(Collection<MatchOffset> matchOffsets);

        /**
         * <p>
         * List of offsets indicating matching terms in the TextMatchItem text.
         * </p>
         * 
         * @param matchOffsets
         *        List of offsets indicating matching terms in the TextMatchItem text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchOffsets(MatchOffset... matchOffsets);

        /**
         * <p>
         * List of offsets indicating matching terms in the TextMatchItem text.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.MatchOffset.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.MatchOffset#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.MatchOffset.Builder#build()} is called immediately and
         * its result is passed to {@link #matchOffsets(List<MatchOffset>)}.
         * 
         * @param matchOffsets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.MatchOffset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matchOffsets(java.util.Collection<MatchOffset>)
         */
        Builder matchOffsets(Consumer<MatchOffset.Builder>... matchOffsets);

        /**
         * <p>
         * Snippet of attribute text containing highlighted content.
         * </p>
         * 
         * @param text
         *        Snippet of attribute text containing highlighted content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);
    }

    static final class BuilderImpl implements Builder {
        private String attribute;

        private List<MatchOffset> matchOffsets = DefaultSdkAutoConstructList.getInstance();

        private String text;

        private BuilderImpl() {
        }

        private BuilderImpl(TextMatchItem model) {
            attribute(model.attribute);
            matchOffsets(model.matchOffsets);
            text(model.text);
        }

        public final String getAttribute() {
            return attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        public final List<MatchOffset.Builder> getMatchOffsets() {
            List<MatchOffset.Builder> result = MatchOffsetsCopier.copyToBuilder(this.matchOffsets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMatchOffsets(Collection<MatchOffset.BuilderImpl> matchOffsets) {
            this.matchOffsets = MatchOffsetsCopier.copyFromBuilder(matchOffsets);
        }

        @Override
        public final Builder matchOffsets(Collection<MatchOffset> matchOffsets) {
            this.matchOffsets = MatchOffsetsCopier.copy(matchOffsets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchOffsets(MatchOffset... matchOffsets) {
            matchOffsets(Arrays.asList(matchOffsets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchOffsets(Consumer<MatchOffset.Builder>... matchOffsets) {
            matchOffsets(Stream.of(matchOffsets).map(c -> MatchOffset.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        @Override
        public TextMatchItem build() {
            return new TextMatchItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
