/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Spark EMR properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SparkEmrPropertiesOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<SparkEmrPropertiesOutput.Builder, SparkEmrPropertiesOutput> {
    private static final SdkField<String> CERTIFICATE_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateData").getter(getter(SparkEmrPropertiesOutput::certificateData))
            .setter(setter(Builder::certificateData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateData").build()).build();

    private static final SdkField<String> COMPUTE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computeArn").getter(getter(SparkEmrPropertiesOutput::computeArn)).setter(setter(Builder::computeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeArn").build()).build();

    private static final SdkField<UsernamePassword> CREDENTIALS_FIELD = SdkField
            .<UsernamePassword> builder(MarshallingType.SDK_POJO).memberName("credentials")
            .getter(getter(SparkEmrPropertiesOutput::credentials)).setter(setter(Builder::credentials))
            .constructor(UsernamePassword::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentials").build()).build();

    private static final SdkField<Instant> CREDENTIALS_EXPIRATION_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("credentialsExpiration")
            .getter(getter(SparkEmrPropertiesOutput::credentialsExpiration))
            .setter(setter(Builder::credentialsExpiration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsExpiration").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> GOVERNANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("governanceType").getter(getter(SparkEmrPropertiesOutput::governanceTypeAsString))
            .setter(setter(Builder::governanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("governanceType").build()).build();

    private static final SdkField<String> INSTANCE_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceProfileArn").getter(getter(SparkEmrPropertiesOutput::instanceProfileArn))
            .setter(setter(Builder::instanceProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceProfileArn").build())
            .build();

    private static final SdkField<String> JAVA_VIRTUAL_ENV_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("javaVirtualEnv").getter(getter(SparkEmrPropertiesOutput::javaVirtualEnv))
            .setter(setter(Builder::javaVirtualEnv))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("javaVirtualEnv").build()).build();

    private static final SdkField<String> LIVY_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("livyEndpoint").getter(getter(SparkEmrPropertiesOutput::livyEndpoint))
            .setter(setter(Builder::livyEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("livyEndpoint").build()).build();

    private static final SdkField<String> LOG_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("logUri")
            .getter(getter(SparkEmrPropertiesOutput::logUri)).setter(setter(Builder::logUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logUri").build()).build();

    private static final SdkField<String> MANAGED_ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("managedEndpointArn").getter(getter(SparkEmrPropertiesOutput::managedEndpointArn))
            .setter(setter(Builder::managedEndpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedEndpointArn").build())
            .build();

    private static final SdkField<ManagedEndpointCredentials> MANAGED_ENDPOINT_CREDENTIALS_FIELD = SdkField
            .<ManagedEndpointCredentials> builder(MarshallingType.SDK_POJO)
            .memberName("managedEndpointCredentials")
            .getter(getter(SparkEmrPropertiesOutput::managedEndpointCredentials))
            .setter(setter(Builder::managedEndpointCredentials))
            .constructor(ManagedEndpointCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedEndpointCredentials").build())
            .build();

    private static final SdkField<String> PYTHON_VIRTUAL_ENV_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pythonVirtualEnv").getter(getter(SparkEmrPropertiesOutput::pythonVirtualEnv))
            .setter(setter(Builder::pythonVirtualEnv))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pythonVirtualEnv").build()).build();

    private static final SdkField<String> RUNTIME_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("runtimeRole").getter(getter(SparkEmrPropertiesOutput::runtimeRole)).setter(setter(Builder::runtimeRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeRole").build()).build();

    private static final SdkField<String> TRUSTED_CERTIFICATES_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trustedCertificatesS3Uri").getter(getter(SparkEmrPropertiesOutput::trustedCertificatesS3Uri))
            .setter(setter(Builder::trustedCertificatesS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustedCertificatesS3Uri").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_DATA_FIELD,
            COMPUTE_ARN_FIELD, CREDENTIALS_FIELD, CREDENTIALS_EXPIRATION_FIELD, GOVERNANCE_TYPE_FIELD,
            INSTANCE_PROFILE_ARN_FIELD, JAVA_VIRTUAL_ENV_FIELD, LIVY_ENDPOINT_FIELD, LOG_URI_FIELD, MANAGED_ENDPOINT_ARN_FIELD,
            MANAGED_ENDPOINT_CREDENTIALS_FIELD, PYTHON_VIRTUAL_ENV_FIELD, RUNTIME_ROLE_FIELD, TRUSTED_CERTIFICATES_S3_URI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String certificateData;

    private final String computeArn;

    private final UsernamePassword credentials;

    private final Instant credentialsExpiration;

    private final String governanceType;

    private final String instanceProfileArn;

    private final String javaVirtualEnv;

    private final String livyEndpoint;

    private final String logUri;

    private final String managedEndpointArn;

    private final ManagedEndpointCredentials managedEndpointCredentials;

    private final String pythonVirtualEnv;

    private final String runtimeRole;

    private final String trustedCertificatesS3Uri;

    private SparkEmrPropertiesOutput(BuilderImpl builder) {
        this.certificateData = builder.certificateData;
        this.computeArn = builder.computeArn;
        this.credentials = builder.credentials;
        this.credentialsExpiration = builder.credentialsExpiration;
        this.governanceType = builder.governanceType;
        this.instanceProfileArn = builder.instanceProfileArn;
        this.javaVirtualEnv = builder.javaVirtualEnv;
        this.livyEndpoint = builder.livyEndpoint;
        this.logUri = builder.logUri;
        this.managedEndpointArn = builder.managedEndpointArn;
        this.managedEndpointCredentials = builder.managedEndpointCredentials;
        this.pythonVirtualEnv = builder.pythonVirtualEnv;
        this.runtimeRole = builder.runtimeRole;
        this.trustedCertificatesS3Uri = builder.trustedCertificatesS3Uri;
    }

    /**
     * <p>
     * The certificate data of the EMR on EKS cluster.
     * </p>
     * 
     * @return The certificate data of the EMR on EKS cluster.
     */
    public final String certificateData() {
        return certificateData;
    }

    /**
     * <p>
     * The compute ARN of the Spark EMR.
     * </p>
     * 
     * @return The compute ARN of the Spark EMR.
     */
    public final String computeArn() {
        return computeArn;
    }

    /**
     * <p>
     * The credentials of the Spark EMR.
     * </p>
     * 
     * @return The credentials of the Spark EMR.
     */
    public final UsernamePassword credentials() {
        return credentials;
    }

    /**
     * <p>
     * The credential expiration of the Spark EMR.
     * </p>
     * 
     * @return The credential expiration of the Spark EMR.
     */
    public final Instant credentialsExpiration() {
        return credentialsExpiration;
    }

    /**
     * <p>
     * The governance type of the Spark EMR.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #governanceType}
     * will return {@link GovernanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #governanceTypeAsString}.
     * </p>
     * 
     * @return The governance type of the Spark EMR.
     * @see GovernanceType
     */
    public final GovernanceType governanceType() {
        return GovernanceType.fromValue(governanceType);
    }

    /**
     * <p>
     * The governance type of the Spark EMR.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #governanceType}
     * will return {@link GovernanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #governanceTypeAsString}.
     * </p>
     * 
     * @return The governance type of the Spark EMR.
     * @see GovernanceType
     */
    public final String governanceTypeAsString() {
        return governanceType;
    }

    /**
     * <p>
     * The instance profile ARN of the Spark EMR.
     * </p>
     * 
     * @return The instance profile ARN of the Spark EMR.
     */
    public final String instanceProfileArn() {
        return instanceProfileArn;
    }

    /**
     * <p>
     * The Java virtual env of the Spark EMR.
     * </p>
     * 
     * @return The Java virtual env of the Spark EMR.
     */
    public final String javaVirtualEnv() {
        return javaVirtualEnv;
    }

    /**
     * <p>
     * The livy endpoint of the Spark EMR.
     * </p>
     * 
     * @return The livy endpoint of the Spark EMR.
     */
    public final String livyEndpoint() {
        return livyEndpoint;
    }

    /**
     * <p>
     * The log URI of the Spark EMR.
     * </p>
     * 
     * @return The log URI of the Spark EMR.
     */
    public final String logUri() {
        return logUri;
    }

    /**
     * <p>
     * The managed endpoint ARN of the EMR on EKS cluster.
     * </p>
     * 
     * @return The managed endpoint ARN of the EMR on EKS cluster.
     */
    public final String managedEndpointArn() {
        return managedEndpointArn;
    }

    /**
     * <p>
     * The managed endpoint credentials of the EMR on EKS cluster.
     * </p>
     * 
     * @return The managed endpoint credentials of the EMR on EKS cluster.
     */
    public final ManagedEndpointCredentials managedEndpointCredentials() {
        return managedEndpointCredentials;
    }

    /**
     * <p>
     * The Python virtual env of the Spark EMR.
     * </p>
     * 
     * @return The Python virtual env of the Spark EMR.
     */
    public final String pythonVirtualEnv() {
        return pythonVirtualEnv;
    }

    /**
     * <p>
     * The runtime role of the Spark EMR.
     * </p>
     * 
     * @return The runtime role of the Spark EMR.
     */
    public final String runtimeRole() {
        return runtimeRole;
    }

    /**
     * <p>
     * The trusted certificate S3 URL of the Spark EMR.
     * </p>
     * 
     * @return The trusted certificate S3 URL of the Spark EMR.
     */
    public final String trustedCertificatesS3Uri() {
        return trustedCertificatesS3Uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateData());
        hashCode = 31 * hashCode + Objects.hashCode(computeArn());
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        hashCode = 31 * hashCode + Objects.hashCode(credentialsExpiration());
        hashCode = 31 * hashCode + Objects.hashCode(governanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(javaVirtualEnv());
        hashCode = 31 * hashCode + Objects.hashCode(livyEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(logUri());
        hashCode = 31 * hashCode + Objects.hashCode(managedEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(managedEndpointCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(pythonVirtualEnv());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeRole());
        hashCode = 31 * hashCode + Objects.hashCode(trustedCertificatesS3Uri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SparkEmrPropertiesOutput)) {
            return false;
        }
        SparkEmrPropertiesOutput other = (SparkEmrPropertiesOutput) obj;
        return Objects.equals(certificateData(), other.certificateData()) && Objects.equals(computeArn(), other.computeArn())
                && Objects.equals(credentials(), other.credentials())
                && Objects.equals(credentialsExpiration(), other.credentialsExpiration())
                && Objects.equals(governanceTypeAsString(), other.governanceTypeAsString())
                && Objects.equals(instanceProfileArn(), other.instanceProfileArn())
                && Objects.equals(javaVirtualEnv(), other.javaVirtualEnv())
                && Objects.equals(livyEndpoint(), other.livyEndpoint()) && Objects.equals(logUri(), other.logUri())
                && Objects.equals(managedEndpointArn(), other.managedEndpointArn())
                && Objects.equals(managedEndpointCredentials(), other.managedEndpointCredentials())
                && Objects.equals(pythonVirtualEnv(), other.pythonVirtualEnv())
                && Objects.equals(runtimeRole(), other.runtimeRole())
                && Objects.equals(trustedCertificatesS3Uri(), other.trustedCertificatesS3Uri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("SparkEmrPropertiesOutput")
                .add("CertificateData", certificateData())
                .add("ComputeArn", computeArn())
                .add("Credentials", credentials() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CredentialsExpiration", credentialsExpiration())
                .add("GovernanceType", governanceTypeAsString())
                .add("InstanceProfileArn", instanceProfileArn())
                .add("JavaVirtualEnv", javaVirtualEnv())
                .add("LivyEndpoint", livyEndpoint())
                .add("LogUri", logUri())
                .add("ManagedEndpointArn", managedEndpointArn())
                .add("ManagedEndpointCredentials",
                        managedEndpointCredentials() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PythonVirtualEnv", pythonVirtualEnv()).add("RuntimeRole", runtimeRole())
                .add("TrustedCertificatesS3Uri", trustedCertificatesS3Uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateData":
            return Optional.ofNullable(clazz.cast(certificateData()));
        case "computeArn":
            return Optional.ofNullable(clazz.cast(computeArn()));
        case "credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        case "credentialsExpiration":
            return Optional.ofNullable(clazz.cast(credentialsExpiration()));
        case "governanceType":
            return Optional.ofNullable(clazz.cast(governanceTypeAsString()));
        case "instanceProfileArn":
            return Optional.ofNullable(clazz.cast(instanceProfileArn()));
        case "javaVirtualEnv":
            return Optional.ofNullable(clazz.cast(javaVirtualEnv()));
        case "livyEndpoint":
            return Optional.ofNullable(clazz.cast(livyEndpoint()));
        case "logUri":
            return Optional.ofNullable(clazz.cast(logUri()));
        case "managedEndpointArn":
            return Optional.ofNullable(clazz.cast(managedEndpointArn()));
        case "managedEndpointCredentials":
            return Optional.ofNullable(clazz.cast(managedEndpointCredentials()));
        case "pythonVirtualEnv":
            return Optional.ofNullable(clazz.cast(pythonVirtualEnv()));
        case "runtimeRole":
            return Optional.ofNullable(clazz.cast(runtimeRole()));
        case "trustedCertificatesS3Uri":
            return Optional.ofNullable(clazz.cast(trustedCertificatesS3Uri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("certificateData", CERTIFICATE_DATA_FIELD);
        map.put("computeArn", COMPUTE_ARN_FIELD);
        map.put("credentials", CREDENTIALS_FIELD);
        map.put("credentialsExpiration", CREDENTIALS_EXPIRATION_FIELD);
        map.put("governanceType", GOVERNANCE_TYPE_FIELD);
        map.put("instanceProfileArn", INSTANCE_PROFILE_ARN_FIELD);
        map.put("javaVirtualEnv", JAVA_VIRTUAL_ENV_FIELD);
        map.put("livyEndpoint", LIVY_ENDPOINT_FIELD);
        map.put("logUri", LOG_URI_FIELD);
        map.put("managedEndpointArn", MANAGED_ENDPOINT_ARN_FIELD);
        map.put("managedEndpointCredentials", MANAGED_ENDPOINT_CREDENTIALS_FIELD);
        map.put("pythonVirtualEnv", PYTHON_VIRTUAL_ENV_FIELD);
        map.put("runtimeRole", RUNTIME_ROLE_FIELD);
        map.put("trustedCertificatesS3Uri", TRUSTED_CERTIFICATES_S3_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SparkEmrPropertiesOutput, T> g) {
        return obj -> g.apply((SparkEmrPropertiesOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SparkEmrPropertiesOutput> {
        /**
         * <p>
         * The certificate data of the EMR on EKS cluster.
         * </p>
         * 
         * @param certificateData
         *        The certificate data of the EMR on EKS cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateData(String certificateData);

        /**
         * <p>
         * The compute ARN of the Spark EMR.
         * </p>
         * 
         * @param computeArn
         *        The compute ARN of the Spark EMR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeArn(String computeArn);

        /**
         * <p>
         * The credentials of the Spark EMR.
         * </p>
         * 
         * @param credentials
         *        The credentials of the Spark EMR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(UsernamePassword credentials);

        /**
         * <p>
         * The credentials of the Spark EMR.
         * </p>
         * This is a convenience method that creates an instance of the {@link UsernamePassword.Builder} avoiding the
         * need to create one manually via {@link UsernamePassword#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UsernamePassword.Builder#build()} is called immediately and its
         * result is passed to {@link #credentials(UsernamePassword)}.
         * 
         * @param credentials
         *        a consumer that will call methods on {@link UsernamePassword.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(UsernamePassword)
         */
        default Builder credentials(Consumer<UsernamePassword.Builder> credentials) {
            return credentials(UsernamePassword.builder().applyMutation(credentials).build());
        }

        /**
         * <p>
         * The credential expiration of the Spark EMR.
         * </p>
         * 
         * @param credentialsExpiration
         *        The credential expiration of the Spark EMR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsExpiration(Instant credentialsExpiration);

        /**
         * <p>
         * The governance type of the Spark EMR.
         * </p>
         * 
         * @param governanceType
         *        The governance type of the Spark EMR.
         * @see GovernanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GovernanceType
         */
        Builder governanceType(String governanceType);

        /**
         * <p>
         * The governance type of the Spark EMR.
         * </p>
         * 
         * @param governanceType
         *        The governance type of the Spark EMR.
         * @see GovernanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GovernanceType
         */
        Builder governanceType(GovernanceType governanceType);

        /**
         * <p>
         * The instance profile ARN of the Spark EMR.
         * </p>
         * 
         * @param instanceProfileArn
         *        The instance profile ARN of the Spark EMR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfileArn(String instanceProfileArn);

        /**
         * <p>
         * The Java virtual env of the Spark EMR.
         * </p>
         * 
         * @param javaVirtualEnv
         *        The Java virtual env of the Spark EMR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder javaVirtualEnv(String javaVirtualEnv);

        /**
         * <p>
         * The livy endpoint of the Spark EMR.
         * </p>
         * 
         * @param livyEndpoint
         *        The livy endpoint of the Spark EMR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder livyEndpoint(String livyEndpoint);

        /**
         * <p>
         * The log URI of the Spark EMR.
         * </p>
         * 
         * @param logUri
         *        The log URI of the Spark EMR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logUri(String logUri);

        /**
         * <p>
         * The managed endpoint ARN of the EMR on EKS cluster.
         * </p>
         * 
         * @param managedEndpointArn
         *        The managed endpoint ARN of the EMR on EKS cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedEndpointArn(String managedEndpointArn);

        /**
         * <p>
         * The managed endpoint credentials of the EMR on EKS cluster.
         * </p>
         * 
         * @param managedEndpointCredentials
         *        The managed endpoint credentials of the EMR on EKS cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedEndpointCredentials(ManagedEndpointCredentials managedEndpointCredentials);

        /**
         * <p>
         * The managed endpoint credentials of the EMR on EKS cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManagedEndpointCredentials.Builder}
         * avoiding the need to create one manually via {@link ManagedEndpointCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedEndpointCredentials.Builder#build()} is called immediately
         * and its result is passed to {@link #managedEndpointCredentials(ManagedEndpointCredentials)}.
         * 
         * @param managedEndpointCredentials
         *        a consumer that will call methods on {@link ManagedEndpointCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedEndpointCredentials(ManagedEndpointCredentials)
         */
        default Builder managedEndpointCredentials(Consumer<ManagedEndpointCredentials.Builder> managedEndpointCredentials) {
            return managedEndpointCredentials(ManagedEndpointCredentials.builder().applyMutation(managedEndpointCredentials)
                    .build());
        }

        /**
         * <p>
         * The Python virtual env of the Spark EMR.
         * </p>
         * 
         * @param pythonVirtualEnv
         *        The Python virtual env of the Spark EMR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pythonVirtualEnv(String pythonVirtualEnv);

        /**
         * <p>
         * The runtime role of the Spark EMR.
         * </p>
         * 
         * @param runtimeRole
         *        The runtime role of the Spark EMR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeRole(String runtimeRole);

        /**
         * <p>
         * The trusted certificate S3 URL of the Spark EMR.
         * </p>
         * 
         * @param trustedCertificatesS3Uri
         *        The trusted certificate S3 URL of the Spark EMR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedCertificatesS3Uri(String trustedCertificatesS3Uri);
    }

    static final class BuilderImpl implements Builder {
        private String certificateData;

        private String computeArn;

        private UsernamePassword credentials;

        private Instant credentialsExpiration;

        private String governanceType;

        private String instanceProfileArn;

        private String javaVirtualEnv;

        private String livyEndpoint;

        private String logUri;

        private String managedEndpointArn;

        private ManagedEndpointCredentials managedEndpointCredentials;

        private String pythonVirtualEnv;

        private String runtimeRole;

        private String trustedCertificatesS3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(SparkEmrPropertiesOutput model) {
            certificateData(model.certificateData);
            computeArn(model.computeArn);
            credentials(model.credentials);
            credentialsExpiration(model.credentialsExpiration);
            governanceType(model.governanceType);
            instanceProfileArn(model.instanceProfileArn);
            javaVirtualEnv(model.javaVirtualEnv);
            livyEndpoint(model.livyEndpoint);
            logUri(model.logUri);
            managedEndpointArn(model.managedEndpointArn);
            managedEndpointCredentials(model.managedEndpointCredentials);
            pythonVirtualEnv(model.pythonVirtualEnv);
            runtimeRole(model.runtimeRole);
            trustedCertificatesS3Uri(model.trustedCertificatesS3Uri);
        }

        public final String getCertificateData() {
            return certificateData;
        }

        public final void setCertificateData(String certificateData) {
            this.certificateData = certificateData;
        }

        @Override
        public final Builder certificateData(String certificateData) {
            this.certificateData = certificateData;
            return this;
        }

        public final String getComputeArn() {
            return computeArn;
        }

        public final void setComputeArn(String computeArn) {
            this.computeArn = computeArn;
        }

        @Override
        public final Builder computeArn(String computeArn) {
            this.computeArn = computeArn;
            return this;
        }

        public final UsernamePassword.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        public final void setCredentials(UsernamePassword.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(UsernamePassword credentials) {
            this.credentials = credentials;
            return this;
        }

        public final Instant getCredentialsExpiration() {
            return credentialsExpiration;
        }

        public final void setCredentialsExpiration(Instant credentialsExpiration) {
            this.credentialsExpiration = credentialsExpiration;
        }

        @Override
        public final Builder credentialsExpiration(Instant credentialsExpiration) {
            this.credentialsExpiration = credentialsExpiration;
            return this;
        }

        public final String getGovernanceType() {
            return governanceType;
        }

        public final void setGovernanceType(String governanceType) {
            this.governanceType = governanceType;
        }

        @Override
        public final Builder governanceType(String governanceType) {
            this.governanceType = governanceType;
            return this;
        }

        @Override
        public final Builder governanceType(GovernanceType governanceType) {
            this.governanceType(governanceType == null ? null : governanceType.toString());
            return this;
        }

        public final String getInstanceProfileArn() {
            return instanceProfileArn;
        }

        public final void setInstanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
        }

        @Override
        public final Builder instanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
            return this;
        }

        public final String getJavaVirtualEnv() {
            return javaVirtualEnv;
        }

        public final void setJavaVirtualEnv(String javaVirtualEnv) {
            this.javaVirtualEnv = javaVirtualEnv;
        }

        @Override
        public final Builder javaVirtualEnv(String javaVirtualEnv) {
            this.javaVirtualEnv = javaVirtualEnv;
            return this;
        }

        public final String getLivyEndpoint() {
            return livyEndpoint;
        }

        public final void setLivyEndpoint(String livyEndpoint) {
            this.livyEndpoint = livyEndpoint;
        }

        @Override
        public final Builder livyEndpoint(String livyEndpoint) {
            this.livyEndpoint = livyEndpoint;
            return this;
        }

        public final String getLogUri() {
            return logUri;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final String getManagedEndpointArn() {
            return managedEndpointArn;
        }

        public final void setManagedEndpointArn(String managedEndpointArn) {
            this.managedEndpointArn = managedEndpointArn;
        }

        @Override
        public final Builder managedEndpointArn(String managedEndpointArn) {
            this.managedEndpointArn = managedEndpointArn;
            return this;
        }

        public final ManagedEndpointCredentials.Builder getManagedEndpointCredentials() {
            return managedEndpointCredentials != null ? managedEndpointCredentials.toBuilder() : null;
        }

        public final void setManagedEndpointCredentials(ManagedEndpointCredentials.BuilderImpl managedEndpointCredentials) {
            this.managedEndpointCredentials = managedEndpointCredentials != null ? managedEndpointCredentials.build() : null;
        }

        @Override
        public final Builder managedEndpointCredentials(ManagedEndpointCredentials managedEndpointCredentials) {
            this.managedEndpointCredentials = managedEndpointCredentials;
            return this;
        }

        public final String getPythonVirtualEnv() {
            return pythonVirtualEnv;
        }

        public final void setPythonVirtualEnv(String pythonVirtualEnv) {
            this.pythonVirtualEnv = pythonVirtualEnv;
        }

        @Override
        public final Builder pythonVirtualEnv(String pythonVirtualEnv) {
            this.pythonVirtualEnv = pythonVirtualEnv;
            return this;
        }

        public final String getRuntimeRole() {
            return runtimeRole;
        }

        public final void setRuntimeRole(String runtimeRole) {
            this.runtimeRole = runtimeRole;
        }

        @Override
        public final Builder runtimeRole(String runtimeRole) {
            this.runtimeRole = runtimeRole;
            return this;
        }

        public final String getTrustedCertificatesS3Uri() {
            return trustedCertificatesS3Uri;
        }

        public final void setTrustedCertificatesS3Uri(String trustedCertificatesS3Uri) {
            this.trustedCertificatesS3Uri = trustedCertificatesS3Uri;
        }

        @Override
        public final Builder trustedCertificatesS3Uri(String trustedCertificatesS3Uri) {
            this.trustedCertificatesS3Uri = trustedCertificatesS3Uri;
            return this;
        }

        @Override
        public SparkEmrPropertiesOutput build() {
            return new SparkEmrPropertiesOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
