/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the schedule of the data source runs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduleConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduleConfiguration.Builder, ScheduleConfiguration> {
    private static final SdkField<String> SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schedule").getter(getter(ScheduleConfiguration::schedule)).setter(setter(Builder::schedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timezone").getter(getter(ScheduleConfiguration::timezoneAsString)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timezone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SCHEDULE_FIELD, TIMEZONE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String schedule;

    private final String timezone;

    private ScheduleConfiguration(BuilderImpl builder) {
        this.schedule = builder.schedule;
        this.timezone = builder.timezone;
    }

    /**
     * <p>
     * The schedule of the data source runs.
     * </p>
     * 
     * @return The schedule of the data source runs.
     */
    public final String schedule() {
        return schedule;
    }

    /**
     * <p>
     * The timezone of the data source run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timezone} will
     * return {@link Timezone#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #timezoneAsString}.
     * </p>
     * 
     * @return The timezone of the data source run.
     * @see Timezone
     */
    public final Timezone timezone() {
        return Timezone.fromValue(timezone);
    }

    /**
     * <p>
     * The timezone of the data source run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timezone} will
     * return {@link Timezone#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #timezoneAsString}.
     * </p>
     * 
     * @return The timezone of the data source run.
     * @see Timezone
     */
    public final String timezoneAsString() {
        return timezone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(timezoneAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleConfiguration)) {
            return false;
        }
        ScheduleConfiguration other = (ScheduleConfiguration) obj;
        return Objects.equals(schedule(), other.schedule()) && Objects.equals(timezoneAsString(), other.timezoneAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduleConfiguration").add("Schedule", schedule()).add("Timezone", timezoneAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "timezone":
            return Optional.ofNullable(clazz.cast(timezoneAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("schedule", SCHEDULE_FIELD);
        map.put("timezone", TIMEZONE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduleConfiguration, T> g) {
        return obj -> g.apply((ScheduleConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduleConfiguration> {
        /**
         * <p>
         * The schedule of the data source runs.
         * </p>
         * 
         * @param schedule
         *        The schedule of the data source runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(String schedule);

        /**
         * <p>
         * The timezone of the data source run.
         * </p>
         * 
         * @param timezone
         *        The timezone of the data source run.
         * @see Timezone
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Timezone
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * The timezone of the data source run.
         * </p>
         * 
         * @param timezone
         *        The timezone of the data source run.
         * @see Timezone
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Timezone
         */
        Builder timezone(Timezone timezone);
    }

    static final class BuilderImpl implements Builder {
        private String schedule;

        private String timezone;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleConfiguration model) {
            schedule(model.schedule);
            timezone(model.timezone);
        }

        public final String getSchedule() {
            return schedule;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        @Override
        public final Builder timezone(Timezone timezone) {
            this.timezone(timezone == null ? null : timezone.toString());
            return this;
        }

        @Override
        public ScheduleConfiguration build() {
            return new ScheduleConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
