/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The row filter expression.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RowFilterExpression implements SdkPojo, Serializable,
        ToCopyableBuilder<RowFilterExpression.Builder, RowFilterExpression> {
    private static final SdkField<EqualToExpression> EQUAL_TO_FIELD = SdkField
            .<EqualToExpression> builder(MarshallingType.SDK_POJO).memberName("equalTo")
            .getter(getter(RowFilterExpression::equalTo)).setter(setter(Builder::equalTo))
            .constructor(EqualToExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("equalTo").build()).build();

    private static final SdkField<GreaterThanExpression> GREATER_THAN_FIELD = SdkField
            .<GreaterThanExpression> builder(MarshallingType.SDK_POJO).memberName("greaterThan")
            .getter(getter(RowFilterExpression::greaterThan)).setter(setter(Builder::greaterThan))
            .constructor(GreaterThanExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greaterThan").build()).build();

    private static final SdkField<GreaterThanOrEqualToExpression> GREATER_THAN_OR_EQUAL_TO_FIELD = SdkField
            .<GreaterThanOrEqualToExpression> builder(MarshallingType.SDK_POJO).memberName("greaterThanOrEqualTo")
            .getter(getter(RowFilterExpression::greaterThanOrEqualTo)).setter(setter(Builder::greaterThanOrEqualTo))
            .constructor(GreaterThanOrEqualToExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greaterThanOrEqualTo").build())
            .build();

    private static final SdkField<InExpression> IN_FIELD = SdkField.<InExpression> builder(MarshallingType.SDK_POJO)
            .memberName("in").getter(getter(RowFilterExpression::in)).setter(setter(Builder::in))
            .constructor(InExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("in").build()).build();

    private static final SdkField<IsNotNullExpression> IS_NOT_NULL_FIELD = SdkField
            .<IsNotNullExpression> builder(MarshallingType.SDK_POJO).memberName("isNotNull")
            .getter(getter(RowFilterExpression::isNotNull)).setter(setter(Builder::isNotNull))
            .constructor(IsNotNullExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isNotNull").build()).build();

    private static final SdkField<IsNullExpression> IS_NULL_FIELD = SdkField.<IsNullExpression> builder(MarshallingType.SDK_POJO)
            .memberName("isNull").getter(getter(RowFilterExpression::isNull)).setter(setter(Builder::isNull))
            .constructor(IsNullExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isNull").build()).build();

    private static final SdkField<LessThanExpression> LESS_THAN_FIELD = SdkField
            .<LessThanExpression> builder(MarshallingType.SDK_POJO).memberName("lessThan")
            .getter(getter(RowFilterExpression::lessThan)).setter(setter(Builder::lessThan))
            .constructor(LessThanExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lessThan").build()).build();

    private static final SdkField<LessThanOrEqualToExpression> LESS_THAN_OR_EQUAL_TO_FIELD = SdkField
            .<LessThanOrEqualToExpression> builder(MarshallingType.SDK_POJO).memberName("lessThanOrEqualTo")
            .getter(getter(RowFilterExpression::lessThanOrEqualTo)).setter(setter(Builder::lessThanOrEqualTo))
            .constructor(LessThanOrEqualToExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lessThanOrEqualTo").build()).build();

    private static final SdkField<LikeExpression> LIKE_FIELD = SdkField.<LikeExpression> builder(MarshallingType.SDK_POJO)
            .memberName("like").getter(getter(RowFilterExpression::like)).setter(setter(Builder::like))
            .constructor(LikeExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("like").build()).build();

    private static final SdkField<NotEqualToExpression> NOT_EQUAL_TO_FIELD = SdkField
            .<NotEqualToExpression> builder(MarshallingType.SDK_POJO).memberName("notEqualTo")
            .getter(getter(RowFilterExpression::notEqualTo)).setter(setter(Builder::notEqualTo))
            .constructor(NotEqualToExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notEqualTo").build()).build();

    private static final SdkField<NotInExpression> NOT_IN_FIELD = SdkField.<NotInExpression> builder(MarshallingType.SDK_POJO)
            .memberName("notIn").getter(getter(RowFilterExpression::notIn)).setter(setter(Builder::notIn))
            .constructor(NotInExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notIn").build()).build();

    private static final SdkField<NotLikeExpression> NOT_LIKE_FIELD = SdkField
            .<NotLikeExpression> builder(MarshallingType.SDK_POJO).memberName("notLike")
            .getter(getter(RowFilterExpression::notLike)).setter(setter(Builder::notLike))
            .constructor(NotLikeExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notLike").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EQUAL_TO_FIELD,
            GREATER_THAN_FIELD, GREATER_THAN_OR_EQUAL_TO_FIELD, IN_FIELD, IS_NOT_NULL_FIELD, IS_NULL_FIELD, LESS_THAN_FIELD,
            LESS_THAN_OR_EQUAL_TO_FIELD, LIKE_FIELD, NOT_EQUAL_TO_FIELD, NOT_IN_FIELD, NOT_LIKE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EqualToExpression equalTo;

    private final GreaterThanExpression greaterThan;

    private final GreaterThanOrEqualToExpression greaterThanOrEqualTo;

    private final InExpression in;

    private final IsNotNullExpression isNotNull;

    private final IsNullExpression isNull;

    private final LessThanExpression lessThan;

    private final LessThanOrEqualToExpression lessThanOrEqualTo;

    private final LikeExpression like;

    private final NotEqualToExpression notEqualTo;

    private final NotInExpression notIn;

    private final NotLikeExpression notLike;

    private final Type type;

    private RowFilterExpression(BuilderImpl builder) {
        this.equalTo = builder.equalTo;
        this.greaterThan = builder.greaterThan;
        this.greaterThanOrEqualTo = builder.greaterThanOrEqualTo;
        this.in = builder.in;
        this.isNotNull = builder.isNotNull;
        this.isNull = builder.isNull;
        this.lessThan = builder.lessThan;
        this.lessThanOrEqualTo = builder.lessThanOrEqualTo;
        this.like = builder.like;
        this.notEqualTo = builder.notEqualTo;
        this.notIn = builder.notIn;
        this.notLike = builder.notLike;
        this.type = builder.type;
    }

    /**
     * <p>
     * The 'equal to' clause of the row filter expression.
     * </p>
     * 
     * @return The 'equal to' clause of the row filter expression.
     */
    public final EqualToExpression equalTo() {
        return equalTo;
    }

    /**
     * <p>
     * The 'greater than' clause of the row filter expression.
     * </p>
     * 
     * @return The 'greater than' clause of the row filter expression.
     */
    public final GreaterThanExpression greaterThan() {
        return greaterThan;
    }

    /**
     * <p>
     * The 'greater than or equal to' clause of the filter expression.
     * </p>
     * 
     * @return The 'greater than or equal to' clause of the filter expression.
     */
    public final GreaterThanOrEqualToExpression greaterThanOrEqualTo() {
        return greaterThanOrEqualTo;
    }

    /**
     * <p>
     * The 'in' clause of the row filter expression.
     * </p>
     * 
     * @return The 'in' clause of the row filter expression.
     */
    public final InExpression in() {
        return in;
    }

    /**
     * <p>
     * The 'is not null' clause of the row filter expression.
     * </p>
     * 
     * @return The 'is not null' clause of the row filter expression.
     */
    public final IsNotNullExpression isNotNull() {
        return isNotNull;
    }

    /**
     * <p>
     * The 'is null' clause of the row filter expression.
     * </p>
     * 
     * @return The 'is null' clause of the row filter expression.
     */
    public final IsNullExpression isNull() {
        return isNull;
    }

    /**
     * <p>
     * The 'less than' clause of the row filter expression.
     * </p>
     * 
     * @return The 'less than' clause of the row filter expression.
     */
    public final LessThanExpression lessThan() {
        return lessThan;
    }

    /**
     * <p>
     * The 'less than or equal to' clause of the row filter expression.
     * </p>
     * 
     * @return The 'less than or equal to' clause of the row filter expression.
     */
    public final LessThanOrEqualToExpression lessThanOrEqualTo() {
        return lessThanOrEqualTo;
    }

    /**
     * <p>
     * The 'like' clause of the row filter expression.
     * </p>
     * 
     * @return The 'like' clause of the row filter expression.
     */
    public final LikeExpression like() {
        return like;
    }

    /**
     * <p>
     * The 'no equal to' clause of the row filter expression.
     * </p>
     * 
     * @return The 'no equal to' clause of the row filter expression.
     */
    public final NotEqualToExpression notEqualTo() {
        return notEqualTo;
    }

    /**
     * <p>
     * The 'not in' clause of the row filter expression.
     * </p>
     * 
     * @return The 'not in' clause of the row filter expression.
     */
    public final NotInExpression notIn() {
        return notIn;
    }

    /**
     * <p>
     * The 'not like' clause of the row filter expression.
     * </p>
     * 
     * @return The 'not like' clause of the row filter expression.
     */
    public final NotLikeExpression notLike() {
        return notLike;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(equalTo());
        hashCode = 31 * hashCode + Objects.hashCode(greaterThan());
        hashCode = 31 * hashCode + Objects.hashCode(greaterThanOrEqualTo());
        hashCode = 31 * hashCode + Objects.hashCode(in());
        hashCode = 31 * hashCode + Objects.hashCode(isNotNull());
        hashCode = 31 * hashCode + Objects.hashCode(isNull());
        hashCode = 31 * hashCode + Objects.hashCode(lessThan());
        hashCode = 31 * hashCode + Objects.hashCode(lessThanOrEqualTo());
        hashCode = 31 * hashCode + Objects.hashCode(like());
        hashCode = 31 * hashCode + Objects.hashCode(notEqualTo());
        hashCode = 31 * hashCode + Objects.hashCode(notIn());
        hashCode = 31 * hashCode + Objects.hashCode(notLike());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RowFilterExpression)) {
            return false;
        }
        RowFilterExpression other = (RowFilterExpression) obj;
        return Objects.equals(equalTo(), other.equalTo()) && Objects.equals(greaterThan(), other.greaterThan())
                && Objects.equals(greaterThanOrEqualTo(), other.greaterThanOrEqualTo()) && Objects.equals(in(), other.in())
                && Objects.equals(isNotNull(), other.isNotNull()) && Objects.equals(isNull(), other.isNull())
                && Objects.equals(lessThan(), other.lessThan()) && Objects.equals(lessThanOrEqualTo(), other.lessThanOrEqualTo())
                && Objects.equals(like(), other.like()) && Objects.equals(notEqualTo(), other.notEqualTo())
                && Objects.equals(notIn(), other.notIn()) && Objects.equals(notLike(), other.notLike());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RowFilterExpression").add("EqualTo", equalTo()).add("GreaterThan", greaterThan())
                .add("GreaterThanOrEqualTo", greaterThanOrEqualTo()).add("In", in()).add("IsNotNull", isNotNull())
                .add("IsNull", isNull()).add("LessThan", lessThan()).add("LessThanOrEqualTo", lessThanOrEqualTo())
                .add("Like", like()).add("NotEqualTo", notEqualTo()).add("NotIn", notIn()).add("NotLike", notLike()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "equalTo":
            return Optional.ofNullable(clazz.cast(equalTo()));
        case "greaterThan":
            return Optional.ofNullable(clazz.cast(greaterThan()));
        case "greaterThanOrEqualTo":
            return Optional.ofNullable(clazz.cast(greaterThanOrEqualTo()));
        case "in":
            return Optional.ofNullable(clazz.cast(in()));
        case "isNotNull":
            return Optional.ofNullable(clazz.cast(isNotNull()));
        case "isNull":
            return Optional.ofNullable(clazz.cast(isNull()));
        case "lessThan":
            return Optional.ofNullable(clazz.cast(lessThan()));
        case "lessThanOrEqualTo":
            return Optional.ofNullable(clazz.cast(lessThanOrEqualTo()));
        case "like":
            return Optional.ofNullable(clazz.cast(like()));
        case "notEqualTo":
            return Optional.ofNullable(clazz.cast(notEqualTo()));
        case "notIn":
            return Optional.ofNullable(clazz.cast(notIn()));
        case "notLike":
            return Optional.ofNullable(clazz.cast(notLike()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #equalTo()} initialized to the given value.
     *
     * <p>
     * The 'equal to' clause of the row filter expression.
     * </p>
     * 
     * @param equalTo
     *        The 'equal to' clause of the row filter expression.
     */
    public static RowFilterExpression fromEqualTo(EqualToExpression equalTo) {
        return builder().equalTo(equalTo).build();
    }

    /**
     * Create an instance of this class with {@link #equalTo()} initialized to the given value.
     *
     * <p>
     * The 'equal to' clause of the row filter expression.
     * </p>
     * 
     * @param equalTo
     *        The 'equal to' clause of the row filter expression.
     */
    public static RowFilterExpression fromEqualTo(Consumer<EqualToExpression.Builder> equalTo) {
        EqualToExpression.Builder builder = EqualToExpression.builder();
        equalTo.accept(builder);
        return fromEqualTo(builder.build());
    }

    /**
     * Create an instance of this class with {@link #greaterThan()} initialized to the given value.
     *
     * <p>
     * The 'greater than' clause of the row filter expression.
     * </p>
     * 
     * @param greaterThan
     *        The 'greater than' clause of the row filter expression.
     */
    public static RowFilterExpression fromGreaterThan(GreaterThanExpression greaterThan) {
        return builder().greaterThan(greaterThan).build();
    }

    /**
     * Create an instance of this class with {@link #greaterThan()} initialized to the given value.
     *
     * <p>
     * The 'greater than' clause of the row filter expression.
     * </p>
     * 
     * @param greaterThan
     *        The 'greater than' clause of the row filter expression.
     */
    public static RowFilterExpression fromGreaterThan(Consumer<GreaterThanExpression.Builder> greaterThan) {
        GreaterThanExpression.Builder builder = GreaterThanExpression.builder();
        greaterThan.accept(builder);
        return fromGreaterThan(builder.build());
    }

    /**
     * Create an instance of this class with {@link #greaterThanOrEqualTo()} initialized to the given value.
     *
     * <p>
     * The 'greater than or equal to' clause of the filter expression.
     * </p>
     * 
     * @param greaterThanOrEqualTo
     *        The 'greater than or equal to' clause of the filter expression.
     */
    public static RowFilterExpression fromGreaterThanOrEqualTo(GreaterThanOrEqualToExpression greaterThanOrEqualTo) {
        return builder().greaterThanOrEqualTo(greaterThanOrEqualTo).build();
    }

    /**
     * Create an instance of this class with {@link #greaterThanOrEqualTo()} initialized to the given value.
     *
     * <p>
     * The 'greater than or equal to' clause of the filter expression.
     * </p>
     * 
     * @param greaterThanOrEqualTo
     *        The 'greater than or equal to' clause of the filter expression.
     */
    public static RowFilterExpression fromGreaterThanOrEqualTo(
            Consumer<GreaterThanOrEqualToExpression.Builder> greaterThanOrEqualTo) {
        GreaterThanOrEqualToExpression.Builder builder = GreaterThanOrEqualToExpression.builder();
        greaterThanOrEqualTo.accept(builder);
        return fromGreaterThanOrEqualTo(builder.build());
    }

    /**
     * Create an instance of this class with {@link #in()} initialized to the given value.
     *
     * <p>
     * The 'in' clause of the row filter expression.
     * </p>
     * 
     * @param in
     *        The 'in' clause of the row filter expression.
     */
    public static RowFilterExpression fromIn(InExpression in) {
        return builder().in(in).build();
    }

    /**
     * Create an instance of this class with {@link #in()} initialized to the given value.
     *
     * <p>
     * The 'in' clause of the row filter expression.
     * </p>
     * 
     * @param in
     *        The 'in' clause of the row filter expression.
     */
    public static RowFilterExpression fromIn(Consumer<InExpression.Builder> in) {
        InExpression.Builder builder = InExpression.builder();
        in.accept(builder);
        return fromIn(builder.build());
    }

    /**
     * Create an instance of this class with {@link #isNotNull()} initialized to the given value.
     *
     * <p>
     * The 'is not null' clause of the row filter expression.
     * </p>
     * 
     * @param isNotNull
     *        The 'is not null' clause of the row filter expression.
     */
    public static RowFilterExpression fromIsNotNull(IsNotNullExpression isNotNull) {
        return builder().isNotNull(isNotNull).build();
    }

    /**
     * Create an instance of this class with {@link #isNotNull()} initialized to the given value.
     *
     * <p>
     * The 'is not null' clause of the row filter expression.
     * </p>
     * 
     * @param isNotNull
     *        The 'is not null' clause of the row filter expression.
     */
    public static RowFilterExpression fromIsNotNull(Consumer<IsNotNullExpression.Builder> isNotNull) {
        IsNotNullExpression.Builder builder = IsNotNullExpression.builder();
        isNotNull.accept(builder);
        return fromIsNotNull(builder.build());
    }

    /**
     * Create an instance of this class with {@link #isNull()} initialized to the given value.
     *
     * <p>
     * The 'is null' clause of the row filter expression.
     * </p>
     * 
     * @param isNull
     *        The 'is null' clause of the row filter expression.
     */
    public static RowFilterExpression fromIsNull(IsNullExpression isNull) {
        return builder().isNull(isNull).build();
    }

    /**
     * Create an instance of this class with {@link #isNull()} initialized to the given value.
     *
     * <p>
     * The 'is null' clause of the row filter expression.
     * </p>
     * 
     * @param isNull
     *        The 'is null' clause of the row filter expression.
     */
    public static RowFilterExpression fromIsNull(Consumer<IsNullExpression.Builder> isNull) {
        IsNullExpression.Builder builder = IsNullExpression.builder();
        isNull.accept(builder);
        return fromIsNull(builder.build());
    }

    /**
     * Create an instance of this class with {@link #lessThan()} initialized to the given value.
     *
     * <p>
     * The 'less than' clause of the row filter expression.
     * </p>
     * 
     * @param lessThan
     *        The 'less than' clause of the row filter expression.
     */
    public static RowFilterExpression fromLessThan(LessThanExpression lessThan) {
        return builder().lessThan(lessThan).build();
    }

    /**
     * Create an instance of this class with {@link #lessThan()} initialized to the given value.
     *
     * <p>
     * The 'less than' clause of the row filter expression.
     * </p>
     * 
     * @param lessThan
     *        The 'less than' clause of the row filter expression.
     */
    public static RowFilterExpression fromLessThan(Consumer<LessThanExpression.Builder> lessThan) {
        LessThanExpression.Builder builder = LessThanExpression.builder();
        lessThan.accept(builder);
        return fromLessThan(builder.build());
    }

    /**
     * Create an instance of this class with {@link #lessThanOrEqualTo()} initialized to the given value.
     *
     * <p>
     * The 'less than or equal to' clause of the row filter expression.
     * </p>
     * 
     * @param lessThanOrEqualTo
     *        The 'less than or equal to' clause of the row filter expression.
     */
    public static RowFilterExpression fromLessThanOrEqualTo(LessThanOrEqualToExpression lessThanOrEqualTo) {
        return builder().lessThanOrEqualTo(lessThanOrEqualTo).build();
    }

    /**
     * Create an instance of this class with {@link #lessThanOrEqualTo()} initialized to the given value.
     *
     * <p>
     * The 'less than or equal to' clause of the row filter expression.
     * </p>
     * 
     * @param lessThanOrEqualTo
     *        The 'less than or equal to' clause of the row filter expression.
     */
    public static RowFilterExpression fromLessThanOrEqualTo(Consumer<LessThanOrEqualToExpression.Builder> lessThanOrEqualTo) {
        LessThanOrEqualToExpression.Builder builder = LessThanOrEqualToExpression.builder();
        lessThanOrEqualTo.accept(builder);
        return fromLessThanOrEqualTo(builder.build());
    }

    /**
     * Create an instance of this class with {@link #like()} initialized to the given value.
     *
     * <p>
     * The 'like' clause of the row filter expression.
     * </p>
     * 
     * @param like
     *        The 'like' clause of the row filter expression.
     */
    public static RowFilterExpression fromLike(LikeExpression like) {
        return builder().like(like).build();
    }

    /**
     * Create an instance of this class with {@link #like()} initialized to the given value.
     *
     * <p>
     * The 'like' clause of the row filter expression.
     * </p>
     * 
     * @param like
     *        The 'like' clause of the row filter expression.
     */
    public static RowFilterExpression fromLike(Consumer<LikeExpression.Builder> like) {
        LikeExpression.Builder builder = LikeExpression.builder();
        like.accept(builder);
        return fromLike(builder.build());
    }

    /**
     * Create an instance of this class with {@link #notEqualTo()} initialized to the given value.
     *
     * <p>
     * The 'no equal to' clause of the row filter expression.
     * </p>
     * 
     * @param notEqualTo
     *        The 'no equal to' clause of the row filter expression.
     */
    public static RowFilterExpression fromNotEqualTo(NotEqualToExpression notEqualTo) {
        return builder().notEqualTo(notEqualTo).build();
    }

    /**
     * Create an instance of this class with {@link #notEqualTo()} initialized to the given value.
     *
     * <p>
     * The 'no equal to' clause of the row filter expression.
     * </p>
     * 
     * @param notEqualTo
     *        The 'no equal to' clause of the row filter expression.
     */
    public static RowFilterExpression fromNotEqualTo(Consumer<NotEqualToExpression.Builder> notEqualTo) {
        NotEqualToExpression.Builder builder = NotEqualToExpression.builder();
        notEqualTo.accept(builder);
        return fromNotEqualTo(builder.build());
    }

    /**
     * Create an instance of this class with {@link #notIn()} initialized to the given value.
     *
     * <p>
     * The 'not in' clause of the row filter expression.
     * </p>
     * 
     * @param notIn
     *        The 'not in' clause of the row filter expression.
     */
    public static RowFilterExpression fromNotIn(NotInExpression notIn) {
        return builder().notIn(notIn).build();
    }

    /**
     * Create an instance of this class with {@link #notIn()} initialized to the given value.
     *
     * <p>
     * The 'not in' clause of the row filter expression.
     * </p>
     * 
     * @param notIn
     *        The 'not in' clause of the row filter expression.
     */
    public static RowFilterExpression fromNotIn(Consumer<NotInExpression.Builder> notIn) {
        NotInExpression.Builder builder = NotInExpression.builder();
        notIn.accept(builder);
        return fromNotIn(builder.build());
    }

    /**
     * Create an instance of this class with {@link #notLike()} initialized to the given value.
     *
     * <p>
     * The 'not like' clause of the row filter expression.
     * </p>
     * 
     * @param notLike
     *        The 'not like' clause of the row filter expression.
     */
    public static RowFilterExpression fromNotLike(NotLikeExpression notLike) {
        return builder().notLike(notLike).build();
    }

    /**
     * Create an instance of this class with {@link #notLike()} initialized to the given value.
     *
     * <p>
     * The 'not like' clause of the row filter expression.
     * </p>
     * 
     * @param notLike
     *        The 'not like' clause of the row filter expression.
     */
    public static RowFilterExpression fromNotLike(Consumer<NotLikeExpression.Builder> notLike) {
        NotLikeExpression.Builder builder = NotLikeExpression.builder();
        notLike.accept(builder);
        return fromNotLike(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("equalTo", EQUAL_TO_FIELD);
        map.put("greaterThan", GREATER_THAN_FIELD);
        map.put("greaterThanOrEqualTo", GREATER_THAN_OR_EQUAL_TO_FIELD);
        map.put("in", IN_FIELD);
        map.put("isNotNull", IS_NOT_NULL_FIELD);
        map.put("isNull", IS_NULL_FIELD);
        map.put("lessThan", LESS_THAN_FIELD);
        map.put("lessThanOrEqualTo", LESS_THAN_OR_EQUAL_TO_FIELD);
        map.put("like", LIKE_FIELD);
        map.put("notEqualTo", NOT_EQUAL_TO_FIELD);
        map.put("notIn", NOT_IN_FIELD);
        map.put("notLike", NOT_LIKE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RowFilterExpression, T> g) {
        return obj -> g.apply((RowFilterExpression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RowFilterExpression> {
        /**
         * <p>
         * The 'equal to' clause of the row filter expression.
         * </p>
         * 
         * @param equalTo
         *        The 'equal to' clause of the row filter expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder equalTo(EqualToExpression equalTo);

        /**
         * <p>
         * The 'equal to' clause of the row filter expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link EqualToExpression.Builder} avoiding the
         * need to create one manually via {@link EqualToExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EqualToExpression.Builder#build()} is called immediately and its
         * result is passed to {@link #equalTo(EqualToExpression)}.
         * 
         * @param equalTo
         *        a consumer that will call methods on {@link EqualToExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #equalTo(EqualToExpression)
         */
        default Builder equalTo(Consumer<EqualToExpression.Builder> equalTo) {
            return equalTo(EqualToExpression.builder().applyMutation(equalTo).build());
        }

        /**
         * <p>
         * The 'greater than' clause of the row filter expression.
         * </p>
         * 
         * @param greaterThan
         *        The 'greater than' clause of the row filter expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greaterThan(GreaterThanExpression greaterThan);

        /**
         * <p>
         * The 'greater than' clause of the row filter expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link GreaterThanExpression.Builder} avoiding
         * the need to create one manually via {@link GreaterThanExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GreaterThanExpression.Builder#build()} is called immediately and
         * its result is passed to {@link #greaterThan(GreaterThanExpression)}.
         * 
         * @param greaterThan
         *        a consumer that will call methods on {@link GreaterThanExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #greaterThan(GreaterThanExpression)
         */
        default Builder greaterThan(Consumer<GreaterThanExpression.Builder> greaterThan) {
            return greaterThan(GreaterThanExpression.builder().applyMutation(greaterThan).build());
        }

        /**
         * <p>
         * The 'greater than or equal to' clause of the filter expression.
         * </p>
         * 
         * @param greaterThanOrEqualTo
         *        The 'greater than or equal to' clause of the filter expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greaterThanOrEqualTo(GreaterThanOrEqualToExpression greaterThanOrEqualTo);

        /**
         * <p>
         * The 'greater than or equal to' clause of the filter expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link GreaterThanOrEqualToExpression.Builder}
         * avoiding the need to create one manually via {@link GreaterThanOrEqualToExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GreaterThanOrEqualToExpression.Builder#build()} is called
         * immediately and its result is passed to {@link #greaterThanOrEqualTo(GreaterThanOrEqualToExpression)}.
         * 
         * @param greaterThanOrEqualTo
         *        a consumer that will call methods on {@link GreaterThanOrEqualToExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #greaterThanOrEqualTo(GreaterThanOrEqualToExpression)
         */
        default Builder greaterThanOrEqualTo(Consumer<GreaterThanOrEqualToExpression.Builder> greaterThanOrEqualTo) {
            return greaterThanOrEqualTo(GreaterThanOrEqualToExpression.builder().applyMutation(greaterThanOrEqualTo).build());
        }

        /**
         * <p>
         * The 'in' clause of the row filter expression.
         * </p>
         * 
         * @param in
         *        The 'in' clause of the row filter expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder in(InExpression in);

        /**
         * <p>
         * The 'in' clause of the row filter expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link InExpression.Builder} avoiding the need
         * to create one manually via {@link InExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InExpression.Builder#build()} is called immediately and its
         * result is passed to {@link #in(InExpression)}.
         * 
         * @param in
         *        a consumer that will call methods on {@link InExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #in(InExpression)
         */
        default Builder in(Consumer<InExpression.Builder> in) {
            return in(InExpression.builder().applyMutation(in).build());
        }

        /**
         * <p>
         * The 'is not null' clause of the row filter expression.
         * </p>
         * 
         * @param isNotNull
         *        The 'is not null' clause of the row filter expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isNotNull(IsNotNullExpression isNotNull);

        /**
         * <p>
         * The 'is not null' clause of the row filter expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link IsNotNullExpression.Builder} avoiding the
         * need to create one manually via {@link IsNotNullExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IsNotNullExpression.Builder#build()} is called immediately and
         * its result is passed to {@link #isNotNull(IsNotNullExpression)}.
         * 
         * @param isNotNull
         *        a consumer that will call methods on {@link IsNotNullExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #isNotNull(IsNotNullExpression)
         */
        default Builder isNotNull(Consumer<IsNotNullExpression.Builder> isNotNull) {
            return isNotNull(IsNotNullExpression.builder().applyMutation(isNotNull).build());
        }

        /**
         * <p>
         * The 'is null' clause of the row filter expression.
         * </p>
         * 
         * @param isNull
         *        The 'is null' clause of the row filter expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isNull(IsNullExpression isNull);

        /**
         * <p>
         * The 'is null' clause of the row filter expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link IsNullExpression.Builder} avoiding the
         * need to create one manually via {@link IsNullExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IsNullExpression.Builder#build()} is called immediately and its
         * result is passed to {@link #isNull(IsNullExpression)}.
         * 
         * @param isNull
         *        a consumer that will call methods on {@link IsNullExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #isNull(IsNullExpression)
         */
        default Builder isNull(Consumer<IsNullExpression.Builder> isNull) {
            return isNull(IsNullExpression.builder().applyMutation(isNull).build());
        }

        /**
         * <p>
         * The 'less than' clause of the row filter expression.
         * </p>
         * 
         * @param lessThan
         *        The 'less than' clause of the row filter expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lessThan(LessThanExpression lessThan);

        /**
         * <p>
         * The 'less than' clause of the row filter expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link LessThanExpression.Builder} avoiding the
         * need to create one manually via {@link LessThanExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LessThanExpression.Builder#build()} is called immediately and its
         * result is passed to {@link #lessThan(LessThanExpression)}.
         * 
         * @param lessThan
         *        a consumer that will call methods on {@link LessThanExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lessThan(LessThanExpression)
         */
        default Builder lessThan(Consumer<LessThanExpression.Builder> lessThan) {
            return lessThan(LessThanExpression.builder().applyMutation(lessThan).build());
        }

        /**
         * <p>
         * The 'less than or equal to' clause of the row filter expression.
         * </p>
         * 
         * @param lessThanOrEqualTo
         *        The 'less than or equal to' clause of the row filter expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lessThanOrEqualTo(LessThanOrEqualToExpression lessThanOrEqualTo);

        /**
         * <p>
         * The 'less than or equal to' clause of the row filter expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link LessThanOrEqualToExpression.Builder}
         * avoiding the need to create one manually via {@link LessThanOrEqualToExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LessThanOrEqualToExpression.Builder#build()} is called
         * immediately and its result is passed to {@link #lessThanOrEqualTo(LessThanOrEqualToExpression)}.
         * 
         * @param lessThanOrEqualTo
         *        a consumer that will call methods on {@link LessThanOrEqualToExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lessThanOrEqualTo(LessThanOrEqualToExpression)
         */
        default Builder lessThanOrEqualTo(Consumer<LessThanOrEqualToExpression.Builder> lessThanOrEqualTo) {
            return lessThanOrEqualTo(LessThanOrEqualToExpression.builder().applyMutation(lessThanOrEqualTo).build());
        }

        /**
         * <p>
         * The 'like' clause of the row filter expression.
         * </p>
         * 
         * @param like
         *        The 'like' clause of the row filter expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder like(LikeExpression like);

        /**
         * <p>
         * The 'like' clause of the row filter expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link LikeExpression.Builder} avoiding the need
         * to create one manually via {@link LikeExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LikeExpression.Builder#build()} is called immediately and its
         * result is passed to {@link #like(LikeExpression)}.
         * 
         * @param like
         *        a consumer that will call methods on {@link LikeExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #like(LikeExpression)
         */
        default Builder like(Consumer<LikeExpression.Builder> like) {
            return like(LikeExpression.builder().applyMutation(like).build());
        }

        /**
         * <p>
         * The 'no equal to' clause of the row filter expression.
         * </p>
         * 
         * @param notEqualTo
         *        The 'no equal to' clause of the row filter expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notEqualTo(NotEqualToExpression notEqualTo);

        /**
         * <p>
         * The 'no equal to' clause of the row filter expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotEqualToExpression.Builder} avoiding
         * the need to create one manually via {@link NotEqualToExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotEqualToExpression.Builder#build()} is called immediately and
         * its result is passed to {@link #notEqualTo(NotEqualToExpression)}.
         * 
         * @param notEqualTo
         *        a consumer that will call methods on {@link NotEqualToExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notEqualTo(NotEqualToExpression)
         */
        default Builder notEqualTo(Consumer<NotEqualToExpression.Builder> notEqualTo) {
            return notEqualTo(NotEqualToExpression.builder().applyMutation(notEqualTo).build());
        }

        /**
         * <p>
         * The 'not in' clause of the row filter expression.
         * </p>
         * 
         * @param notIn
         *        The 'not in' clause of the row filter expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notIn(NotInExpression notIn);

        /**
         * <p>
         * The 'not in' clause of the row filter expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotInExpression.Builder} avoiding the
         * need to create one manually via {@link NotInExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotInExpression.Builder#build()} is called immediately and its
         * result is passed to {@link #notIn(NotInExpression)}.
         * 
         * @param notIn
         *        a consumer that will call methods on {@link NotInExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notIn(NotInExpression)
         */
        default Builder notIn(Consumer<NotInExpression.Builder> notIn) {
            return notIn(NotInExpression.builder().applyMutation(notIn).build());
        }

        /**
         * <p>
         * The 'not like' clause of the row filter expression.
         * </p>
         * 
         * @param notLike
         *        The 'not like' clause of the row filter expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notLike(NotLikeExpression notLike);

        /**
         * <p>
         * The 'not like' clause of the row filter expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotLikeExpression.Builder} avoiding the
         * need to create one manually via {@link NotLikeExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotLikeExpression.Builder#build()} is called immediately and its
         * result is passed to {@link #notLike(NotLikeExpression)}.
         * 
         * @param notLike
         *        a consumer that will call methods on {@link NotLikeExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notLike(NotLikeExpression)
         */
        default Builder notLike(Consumer<NotLikeExpression.Builder> notLike) {
            return notLike(NotLikeExpression.builder().applyMutation(notLike).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EqualToExpression equalTo;

        private GreaterThanExpression greaterThan;

        private GreaterThanOrEqualToExpression greaterThanOrEqualTo;

        private InExpression in;

        private IsNotNullExpression isNotNull;

        private IsNullExpression isNull;

        private LessThanExpression lessThan;

        private LessThanOrEqualToExpression lessThanOrEqualTo;

        private LikeExpression like;

        private NotEqualToExpression notEqualTo;

        private NotInExpression notIn;

        private NotLikeExpression notLike;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RowFilterExpression model) {
            equalTo(model.equalTo);
            greaterThan(model.greaterThan);
            greaterThanOrEqualTo(model.greaterThanOrEqualTo);
            in(model.in);
            isNotNull(model.isNotNull);
            isNull(model.isNull);
            lessThan(model.lessThan);
            lessThanOrEqualTo(model.lessThanOrEqualTo);
            like(model.like);
            notEqualTo(model.notEqualTo);
            notIn(model.notIn);
            notLike(model.notLike);
        }

        public final EqualToExpression.Builder getEqualTo() {
            return equalTo != null ? equalTo.toBuilder() : null;
        }

        public final void setEqualTo(EqualToExpression.BuilderImpl equalTo) {
            Object oldValue = this.equalTo;
            this.equalTo = equalTo != null ? equalTo.build() : null;
            handleUnionValueChange(Type.EQUAL_TO, oldValue, this.equalTo);
        }

        @Override
        public final Builder equalTo(EqualToExpression equalTo) {
            Object oldValue = this.equalTo;
            this.equalTo = equalTo;
            handleUnionValueChange(Type.EQUAL_TO, oldValue, this.equalTo);
            return this;
        }

        public final GreaterThanExpression.Builder getGreaterThan() {
            return greaterThan != null ? greaterThan.toBuilder() : null;
        }

        public final void setGreaterThan(GreaterThanExpression.BuilderImpl greaterThan) {
            Object oldValue = this.greaterThan;
            this.greaterThan = greaterThan != null ? greaterThan.build() : null;
            handleUnionValueChange(Type.GREATER_THAN, oldValue, this.greaterThan);
        }

        @Override
        public final Builder greaterThan(GreaterThanExpression greaterThan) {
            Object oldValue = this.greaterThan;
            this.greaterThan = greaterThan;
            handleUnionValueChange(Type.GREATER_THAN, oldValue, this.greaterThan);
            return this;
        }

        public final GreaterThanOrEqualToExpression.Builder getGreaterThanOrEqualTo() {
            return greaterThanOrEqualTo != null ? greaterThanOrEqualTo.toBuilder() : null;
        }

        public final void setGreaterThanOrEqualTo(GreaterThanOrEqualToExpression.BuilderImpl greaterThanOrEqualTo) {
            Object oldValue = this.greaterThanOrEqualTo;
            this.greaterThanOrEqualTo = greaterThanOrEqualTo != null ? greaterThanOrEqualTo.build() : null;
            handleUnionValueChange(Type.GREATER_THAN_OR_EQUAL_TO, oldValue, this.greaterThanOrEqualTo);
        }

        @Override
        public final Builder greaterThanOrEqualTo(GreaterThanOrEqualToExpression greaterThanOrEqualTo) {
            Object oldValue = this.greaterThanOrEqualTo;
            this.greaterThanOrEqualTo = greaterThanOrEqualTo;
            handleUnionValueChange(Type.GREATER_THAN_OR_EQUAL_TO, oldValue, this.greaterThanOrEqualTo);
            return this;
        }

        public final InExpression.Builder getIn() {
            return in != null ? in.toBuilder() : null;
        }

        public final void setIn(InExpression.BuilderImpl in) {
            Object oldValue = this.in;
            this.in = in != null ? in.build() : null;
            handleUnionValueChange(Type.IN, oldValue, this.in);
        }

        @Override
        public final Builder in(InExpression in) {
            Object oldValue = this.in;
            this.in = in;
            handleUnionValueChange(Type.IN, oldValue, this.in);
            return this;
        }

        public final IsNotNullExpression.Builder getIsNotNull() {
            return isNotNull != null ? isNotNull.toBuilder() : null;
        }

        public final void setIsNotNull(IsNotNullExpression.BuilderImpl isNotNull) {
            Object oldValue = this.isNotNull;
            this.isNotNull = isNotNull != null ? isNotNull.build() : null;
            handleUnionValueChange(Type.IS_NOT_NULL, oldValue, this.isNotNull);
        }

        @Override
        public final Builder isNotNull(IsNotNullExpression isNotNull) {
            Object oldValue = this.isNotNull;
            this.isNotNull = isNotNull;
            handleUnionValueChange(Type.IS_NOT_NULL, oldValue, this.isNotNull);
            return this;
        }

        public final IsNullExpression.Builder getIsNull() {
            return isNull != null ? isNull.toBuilder() : null;
        }

        public final void setIsNull(IsNullExpression.BuilderImpl isNull) {
            Object oldValue = this.isNull;
            this.isNull = isNull != null ? isNull.build() : null;
            handleUnionValueChange(Type.IS_NULL, oldValue, this.isNull);
        }

        @Override
        public final Builder isNull(IsNullExpression isNull) {
            Object oldValue = this.isNull;
            this.isNull = isNull;
            handleUnionValueChange(Type.IS_NULL, oldValue, this.isNull);
            return this;
        }

        public final LessThanExpression.Builder getLessThan() {
            return lessThan != null ? lessThan.toBuilder() : null;
        }

        public final void setLessThan(LessThanExpression.BuilderImpl lessThan) {
            Object oldValue = this.lessThan;
            this.lessThan = lessThan != null ? lessThan.build() : null;
            handleUnionValueChange(Type.LESS_THAN, oldValue, this.lessThan);
        }

        @Override
        public final Builder lessThan(LessThanExpression lessThan) {
            Object oldValue = this.lessThan;
            this.lessThan = lessThan;
            handleUnionValueChange(Type.LESS_THAN, oldValue, this.lessThan);
            return this;
        }

        public final LessThanOrEqualToExpression.Builder getLessThanOrEqualTo() {
            return lessThanOrEqualTo != null ? lessThanOrEqualTo.toBuilder() : null;
        }

        public final void setLessThanOrEqualTo(LessThanOrEqualToExpression.BuilderImpl lessThanOrEqualTo) {
            Object oldValue = this.lessThanOrEqualTo;
            this.lessThanOrEqualTo = lessThanOrEqualTo != null ? lessThanOrEqualTo.build() : null;
            handleUnionValueChange(Type.LESS_THAN_OR_EQUAL_TO, oldValue, this.lessThanOrEqualTo);
        }

        @Override
        public final Builder lessThanOrEqualTo(LessThanOrEqualToExpression lessThanOrEqualTo) {
            Object oldValue = this.lessThanOrEqualTo;
            this.lessThanOrEqualTo = lessThanOrEqualTo;
            handleUnionValueChange(Type.LESS_THAN_OR_EQUAL_TO, oldValue, this.lessThanOrEqualTo);
            return this;
        }

        public final LikeExpression.Builder getLike() {
            return like != null ? like.toBuilder() : null;
        }

        public final void setLike(LikeExpression.BuilderImpl like) {
            Object oldValue = this.like;
            this.like = like != null ? like.build() : null;
            handleUnionValueChange(Type.LIKE, oldValue, this.like);
        }

        @Override
        public final Builder like(LikeExpression like) {
            Object oldValue = this.like;
            this.like = like;
            handleUnionValueChange(Type.LIKE, oldValue, this.like);
            return this;
        }

        public final NotEqualToExpression.Builder getNotEqualTo() {
            return notEqualTo != null ? notEqualTo.toBuilder() : null;
        }

        public final void setNotEqualTo(NotEqualToExpression.BuilderImpl notEqualTo) {
            Object oldValue = this.notEqualTo;
            this.notEqualTo = notEqualTo != null ? notEqualTo.build() : null;
            handleUnionValueChange(Type.NOT_EQUAL_TO, oldValue, this.notEqualTo);
        }

        @Override
        public final Builder notEqualTo(NotEqualToExpression notEqualTo) {
            Object oldValue = this.notEqualTo;
            this.notEqualTo = notEqualTo;
            handleUnionValueChange(Type.NOT_EQUAL_TO, oldValue, this.notEqualTo);
            return this;
        }

        public final NotInExpression.Builder getNotIn() {
            return notIn != null ? notIn.toBuilder() : null;
        }

        public final void setNotIn(NotInExpression.BuilderImpl notIn) {
            Object oldValue = this.notIn;
            this.notIn = notIn != null ? notIn.build() : null;
            handleUnionValueChange(Type.NOT_IN, oldValue, this.notIn);
        }

        @Override
        public final Builder notIn(NotInExpression notIn) {
            Object oldValue = this.notIn;
            this.notIn = notIn;
            handleUnionValueChange(Type.NOT_IN, oldValue, this.notIn);
            return this;
        }

        public final NotLikeExpression.Builder getNotLike() {
            return notLike != null ? notLike.toBuilder() : null;
        }

        public final void setNotLike(NotLikeExpression.BuilderImpl notLike) {
            Object oldValue = this.notLike;
            this.notLike = notLike != null ? notLike.build() : null;
            handleUnionValueChange(Type.NOT_LIKE, oldValue, this.notLike);
        }

        @Override
        public final Builder notLike(NotLikeExpression notLike) {
            Object oldValue = this.notLike;
            this.notLike = notLike;
            handleUnionValueChange(Type.NOT_LIKE, oldValue, this.notLike);
            return this;
        }

        @Override
        public RowFilterExpression build() {
            return new RowFilterExpression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RowFilterExpression#type()
     */
    public enum Type {
        EQUAL_TO,

        GREATER_THAN,

        GREATER_THAN_OR_EQUAL_TO,

        IN,

        IS_NOT_NULL,

        IS_NULL,

        LESS_THAN,

        LESS_THAN_OR_EQUAL_TO,

        LIKE,

        NOT_EQUAL_TO,

        NOT_IN,

        NOT_LIKE,

        UNKNOWN_TO_SDK_VERSION
    }
}
