/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The provisioning configuration of the blueprint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisioningConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisioningConfiguration.Builder, ProvisioningConfiguration> {
    private static final SdkField<LakeFormationConfiguration> LAKE_FORMATION_CONFIGURATION_FIELD = SdkField
            .<LakeFormationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("lakeFormationConfiguration")
            .getter(getter(ProvisioningConfiguration::lakeFormationConfiguration))
            .setter(setter(Builder::lakeFormationConfiguration))
            .constructor(LakeFormationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lakeFormationConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LAKE_FORMATION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LakeFormationConfiguration lakeFormationConfiguration;

    private final Type type;

    private ProvisioningConfiguration(BuilderImpl builder) {
        this.lakeFormationConfiguration = builder.lakeFormationConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Lake Formation configuration of the Data Lake blueprint.
     * </p>
     * 
     * @return The Lake Formation configuration of the Data Lake blueprint.
     */
    public final LakeFormationConfiguration lakeFormationConfiguration() {
        return lakeFormationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lakeFormationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisioningConfiguration)) {
            return false;
        }
        ProvisioningConfiguration other = (ProvisioningConfiguration) obj;
        return Objects.equals(lakeFormationConfiguration(), other.lakeFormationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisioningConfiguration").add("LakeFormationConfiguration", lakeFormationConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lakeFormationConfiguration":
            return Optional.ofNullable(clazz.cast(lakeFormationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #lakeFormationConfiguration()} initialized to the given value.
     *
     * <p>
     * The Lake Formation configuration of the Data Lake blueprint.
     * </p>
     * 
     * @param lakeFormationConfiguration
     *        The Lake Formation configuration of the Data Lake blueprint.
     */
    public static ProvisioningConfiguration fromLakeFormationConfiguration(LakeFormationConfiguration lakeFormationConfiguration) {
        return builder().lakeFormationConfiguration(lakeFormationConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #lakeFormationConfiguration()} initialized to the given value.
     *
     * <p>
     * The Lake Formation configuration of the Data Lake blueprint.
     * </p>
     * 
     * @param lakeFormationConfiguration
     *        The Lake Formation configuration of the Data Lake blueprint.
     */
    public static ProvisioningConfiguration fromLakeFormationConfiguration(
            Consumer<LakeFormationConfiguration.Builder> lakeFormationConfiguration) {
        LakeFormationConfiguration.Builder builder = LakeFormationConfiguration.builder();
        lakeFormationConfiguration.accept(builder);
        return fromLakeFormationConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lakeFormationConfiguration", LAKE_FORMATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisioningConfiguration, T> g) {
        return obj -> g.apply((ProvisioningConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisioningConfiguration> {
        /**
         * <p>
         * The Lake Formation configuration of the Data Lake blueprint.
         * </p>
         * 
         * @param lakeFormationConfiguration
         *        The Lake Formation configuration of the Data Lake blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lakeFormationConfiguration(LakeFormationConfiguration lakeFormationConfiguration);

        /**
         * <p>
         * The Lake Formation configuration of the Data Lake blueprint.
         * </p>
         * This is a convenience method that creates an instance of the {@link LakeFormationConfiguration.Builder}
         * avoiding the need to create one manually via {@link LakeFormationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LakeFormationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #lakeFormationConfiguration(LakeFormationConfiguration)}.
         * 
         * @param lakeFormationConfiguration
         *        a consumer that will call methods on {@link LakeFormationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lakeFormationConfiguration(LakeFormationConfiguration)
         */
        default Builder lakeFormationConfiguration(Consumer<LakeFormationConfiguration.Builder> lakeFormationConfiguration) {
            return lakeFormationConfiguration(LakeFormationConfiguration.builder().applyMutation(lakeFormationConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LakeFormationConfiguration lakeFormationConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisioningConfiguration model) {
            lakeFormationConfiguration(model.lakeFormationConfiguration);
        }

        public final LakeFormationConfiguration.Builder getLakeFormationConfiguration() {
            return lakeFormationConfiguration != null ? lakeFormationConfiguration.toBuilder() : null;
        }

        public final void setLakeFormationConfiguration(LakeFormationConfiguration.BuilderImpl lakeFormationConfiguration) {
            Object oldValue = this.lakeFormationConfiguration;
            this.lakeFormationConfiguration = lakeFormationConfiguration != null ? lakeFormationConfiguration.build() : null;
            handleUnionValueChange(Type.LAKE_FORMATION_CONFIGURATION, oldValue, this.lakeFormationConfiguration);
        }

        @Override
        public final Builder lakeFormationConfiguration(LakeFormationConfiguration lakeFormationConfiguration) {
            Object oldValue = this.lakeFormationConfiguration;
            this.lakeFormationConfiguration = lakeFormationConfiguration;
            handleUnionValueChange(Type.LAKE_FORMATION_CONFIGURATION, oldValue, this.lakeFormationConfiguration);
            return this;
        }

        @Override
        public ProvisioningConfiguration build() {
            return new ProvisioningConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ProvisioningConfiguration#type()
     */
    public enum Type {
        LAKE_FORMATION_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
