/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Physical connection requirements of a connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PhysicalConnectionRequirements implements SdkPojo, Serializable,
        ToCopyableBuilder<PhysicalConnectionRequirements.Builder, PhysicalConnectionRequirements> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZone").getter(getter(PhysicalConnectionRequirements::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_ID_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("securityGroupIdList")
            .getter(getter(PhysicalConnectionRequirements::securityGroupIdList))
            .setter(setter(Builder::securityGroupIdList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIdList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subnetId").getter(getter(PhysicalConnectionRequirements::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetId").build()).build();

    private static final SdkField<List<String>> SUBNET_ID_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnetIdList")
            .getter(getter(PhysicalConnectionRequirements::subnetIdList))
            .setter(setter(Builder::subnetIdList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIdList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            SECURITY_GROUP_ID_LIST_FIELD, SUBNET_ID_FIELD, SUBNET_ID_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String availabilityZone;

    private final List<String> securityGroupIdList;

    private final String subnetId;

    private final List<String> subnetIdList;

    private PhysicalConnectionRequirements(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.securityGroupIdList = builder.securityGroupIdList;
        this.subnetId = builder.subnetId;
        this.subnetIdList = builder.subnetIdList;
    }

    /**
     * <p>
     * The availability zone of the physical connection requirements of a connection.
     * </p>
     * 
     * @return The availability zone of the physical connection requirements of a connection.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIdList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIdList() {
        return securityGroupIdList != null && !(securityGroupIdList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The group ID list of the physical connection requirements of a connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIdList} method.
     * </p>
     * 
     * @return The group ID list of the physical connection requirements of a connection.
     */
    public final List<String> securityGroupIdList() {
        return securityGroupIdList;
    }

    /**
     * <p>
     * The subnet ID of the physical connection requirements of a connection.
     * </p>
     * 
     * @return The subnet ID of the physical connection requirements of a connection.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIdList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubnetIdList() {
        return subnetIdList != null && !(subnetIdList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The subnet ID list of the physical connection requirements of a connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIdList} method.
     * </p>
     * 
     * @return The subnet ID list of the physical connection requirements of a connection.
     */
    public final List<String> subnetIdList() {
        return subnetIdList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIdList() ? securityGroupIdList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIdList() ? subnetIdList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhysicalConnectionRequirements)) {
            return false;
        }
        PhysicalConnectionRequirements other = (PhysicalConnectionRequirements) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone())
                && hasSecurityGroupIdList() == other.hasSecurityGroupIdList()
                && Objects.equals(securityGroupIdList(), other.securityGroupIdList())
                && Objects.equals(subnetId(), other.subnetId()) && hasSubnetIdList() == other.hasSubnetIdList()
                && Objects.equals(subnetIdList(), other.subnetIdList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PhysicalConnectionRequirements").add("AvailabilityZone", availabilityZone())
                .add("SecurityGroupIdList", hasSecurityGroupIdList() ? securityGroupIdList() : null).add("SubnetId", subnetId())
                .add("SubnetIdList", hasSubnetIdList() ? subnetIdList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "securityGroupIdList":
            return Optional.ofNullable(clazz.cast(securityGroupIdList()));
        case "subnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "subnetIdList":
            return Optional.ofNullable(clazz.cast(subnetIdList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("securityGroupIdList", SECURITY_GROUP_ID_LIST_FIELD);
        map.put("subnetId", SUBNET_ID_FIELD);
        map.put("subnetIdList", SUBNET_ID_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PhysicalConnectionRequirements, T> g) {
        return obj -> g.apply((PhysicalConnectionRequirements) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PhysicalConnectionRequirements> {
        /**
         * <p>
         * The availability zone of the physical connection requirements of a connection.
         * </p>
         * 
         * @param availabilityZone
         *        The availability zone of the physical connection requirements of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The group ID list of the physical connection requirements of a connection.
         * </p>
         * 
         * @param securityGroupIdList
         *        The group ID list of the physical connection requirements of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIdList(Collection<String> securityGroupIdList);

        /**
         * <p>
         * The group ID list of the physical connection requirements of a connection.
         * </p>
         * 
         * @param securityGroupIdList
         *        The group ID list of the physical connection requirements of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIdList(String... securityGroupIdList);

        /**
         * <p>
         * The subnet ID of the physical connection requirements of a connection.
         * </p>
         * 
         * @param subnetId
         *        The subnet ID of the physical connection requirements of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The subnet ID list of the physical connection requirements of a connection.
         * </p>
         * 
         * @param subnetIdList
         *        The subnet ID list of the physical connection requirements of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIdList(Collection<String> subnetIdList);

        /**
         * <p>
         * The subnet ID list of the physical connection requirements of a connection.
         * </p>
         * 
         * @param subnetIdList
         *        The subnet ID list of the physical connection requirements of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIdList(String... subnetIdList);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private List<String> securityGroupIdList = DefaultSdkAutoConstructList.getInstance();

        private String subnetId;

        private List<String> subnetIdList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PhysicalConnectionRequirements model) {
            availabilityZone(model.availabilityZone);
            securityGroupIdList(model.securityGroupIdList);
            subnetId(model.subnetId);
            subnetIdList(model.subnetIdList);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Collection<String> getSecurityGroupIdList() {
            if (securityGroupIdList instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIdList;
        }

        public final void setSecurityGroupIdList(Collection<String> securityGroupIdList) {
            this.securityGroupIdList = SecurityGroupIdListCopier.copy(securityGroupIdList);
        }

        @Override
        public final Builder securityGroupIdList(Collection<String> securityGroupIdList) {
            this.securityGroupIdList = SecurityGroupIdListCopier.copy(securityGroupIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIdList(String... securityGroupIdList) {
            securityGroupIdList(Arrays.asList(securityGroupIdList));
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final Collection<String> getSubnetIdList() {
            if (subnetIdList instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIdList;
        }

        public final void setSubnetIdList(Collection<String> subnetIdList) {
            this.subnetIdList = SubnetIdListCopier.copy(subnetIdList);
        }

        @Override
        public final Builder subnetIdList(Collection<String> subnetIdList) {
            this.subnetIdList = SubnetIdListCopier.copy(subnetIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIdList(String... subnetIdList) {
            subnetIdList(Arrays.asList(subnetIdList));
            return this;
        }

        @Override
        public PhysicalConnectionRequirements build() {
            return new PhysicalConnectionRequirements(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
