/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The open lineage run event summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpenLineageRunEventSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<OpenLineageRunEventSummary.Builder, OpenLineageRunEventSummary> {
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventType").getter(getter(OpenLineageRunEventSummary::eventTypeAsString))
            .setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()).build();

    private static final SdkField<List<NameIdentifier>> INPUTS_FIELD = SdkField
            .<List<NameIdentifier>> builder(MarshallingType.LIST)
            .memberName("inputs")
            .getter(getter(OpenLineageRunEventSummary::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NameIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(NameIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<NameIdentifier> JOB_FIELD = SdkField.<NameIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("job").getter(getter(OpenLineageRunEventSummary::job)).setter(setter(Builder::job))
            .constructor(NameIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("job").build()).build();

    private static final SdkField<List<NameIdentifier>> OUTPUTS_FIELD = SdkField
            .<List<NameIdentifier>> builder(MarshallingType.LIST)
            .memberName("outputs")
            .getter(getter(OpenLineageRunEventSummary::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NameIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(NameIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("runId")
            .getter(getter(OpenLineageRunEventSummary::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_FIELD,
            INPUTS_FIELD, JOB_FIELD, OUTPUTS_FIELD, RUN_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String eventType;

    private final List<NameIdentifier> inputs;

    private final NameIdentifier job;

    private final List<NameIdentifier> outputs;

    private final String runId;

    private OpenLineageRunEventSummary(BuilderImpl builder) {
        this.eventType = builder.eventType;
        this.inputs = builder.inputs;
        this.job = builder.job;
        this.outputs = builder.outputs;
        this.runId = builder.runId;
    }

    /**
     * <p>
     * The event type of the open lineage run event summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link OpenLineageRunState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The event type of the open lineage run event summary.
     * @see OpenLineageRunState
     */
    public final OpenLineageRunState eventType() {
        return OpenLineageRunState.fromValue(eventType);
    }

    /**
     * <p>
     * The event type of the open lineage run event summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link OpenLineageRunState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The event type of the open lineage run event summary.
     * @see OpenLineageRunState
     */
    public final String eventTypeAsString() {
        return eventType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The inputs of the open lineage run event summary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return The inputs of the open lineage run event summary.
     */
    public final List<NameIdentifier> inputs() {
        return inputs;
    }

    /**
     * <p>
     * The job of the open lineage run event summary.
     * </p>
     * 
     * @return The job of the open lineage run event summary.
     */
    public final NameIdentifier job() {
        return job;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The outputs of the open lineage run event summary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return The outputs of the open lineage run event summary.
     */
    public final List<NameIdentifier> outputs() {
        return outputs;
    }

    /**
     * <p>
     * The runID of the open lineage run event summary.
     * </p>
     * 
     * @return The runID of the open lineage run event summary.
     */
    public final String runId() {
        return runId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(job());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenLineageRunEventSummary)) {
            return false;
        }
        OpenLineageRunEventSummary other = (OpenLineageRunEventSummary) obj;
        return Objects.equals(eventTypeAsString(), other.eventTypeAsString()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs()) && Objects.equals(job(), other.job())
                && hasOutputs() == other.hasOutputs() && Objects.equals(outputs(), other.outputs())
                && Objects.equals(runId(), other.runId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpenLineageRunEventSummary").add("EventType", eventTypeAsString())
                .add("Inputs", hasInputs() ? inputs() : null).add("Job", job()).add("Outputs", hasOutputs() ? outputs() : null)
                .add("RunId", runId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventType":
            return Optional.ofNullable(clazz.cast(eventTypeAsString()));
        case "inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "job":
            return Optional.ofNullable(clazz.cast(job()));
        case "outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "runId":
            return Optional.ofNullable(clazz.cast(runId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eventType", EVENT_TYPE_FIELD);
        map.put("inputs", INPUTS_FIELD);
        map.put("job", JOB_FIELD);
        map.put("outputs", OUTPUTS_FIELD);
        map.put("runId", RUN_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpenLineageRunEventSummary, T> g) {
        return obj -> g.apply((OpenLineageRunEventSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpenLineageRunEventSummary> {
        /**
         * <p>
         * The event type of the open lineage run event summary.
         * </p>
         * 
         * @param eventType
         *        The event type of the open lineage run event summary.
         * @see OpenLineageRunState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenLineageRunState
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The event type of the open lineage run event summary.
         * </p>
         * 
         * @param eventType
         *        The event type of the open lineage run event summary.
         * @see OpenLineageRunState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenLineageRunState
         */
        Builder eventType(OpenLineageRunState eventType);

        /**
         * <p>
         * The inputs of the open lineage run event summary.
         * </p>
         * 
         * @param inputs
         *        The inputs of the open lineage run event summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<NameIdentifier> inputs);

        /**
         * <p>
         * The inputs of the open lineage run event summary.
         * </p>
         * 
         * @param inputs
         *        The inputs of the open lineage run event summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(NameIdentifier... inputs);

        /**
         * <p>
         * The inputs of the open lineage run event summary.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.NameIdentifier.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.NameIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.NameIdentifier.Builder#build()} is called immediately
         * and its result is passed to {@link #inputs(List<NameIdentifier>)}.
         * 
         * @param inputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.NameIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputs(java.util.Collection<NameIdentifier>)
         */
        Builder inputs(Consumer<NameIdentifier.Builder>... inputs);

        /**
         * <p>
         * The job of the open lineage run event summary.
         * </p>
         * 
         * @param job
         *        The job of the open lineage run event summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder job(NameIdentifier job);

        /**
         * <p>
         * The job of the open lineage run event summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link NameIdentifier.Builder} avoiding the need
         * to create one manually via {@link NameIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NameIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #job(NameIdentifier)}.
         * 
         * @param job
         *        a consumer that will call methods on {@link NameIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #job(NameIdentifier)
         */
        default Builder job(Consumer<NameIdentifier.Builder> job) {
            return job(NameIdentifier.builder().applyMutation(job).build());
        }

        /**
         * <p>
         * The outputs of the open lineage run event summary.
         * </p>
         * 
         * @param outputs
         *        The outputs of the open lineage run event summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<NameIdentifier> outputs);

        /**
         * <p>
         * The outputs of the open lineage run event summary.
         * </p>
         * 
         * @param outputs
         *        The outputs of the open lineage run event summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(NameIdentifier... outputs);

        /**
         * <p>
         * The outputs of the open lineage run event summary.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.NameIdentifier.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.NameIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.NameIdentifier.Builder#build()} is called immediately
         * and its result is passed to {@link #outputs(List<NameIdentifier>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.NameIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(java.util.Collection<NameIdentifier>)
         */
        Builder outputs(Consumer<NameIdentifier.Builder>... outputs);

        /**
         * <p>
         * The runID of the open lineage run event summary.
         * </p>
         * 
         * @param runId
         *        The runID of the open lineage run event summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);
    }

    static final class BuilderImpl implements Builder {
        private String eventType;

        private List<NameIdentifier> inputs = DefaultSdkAutoConstructList.getInstance();

        private NameIdentifier job;

        private List<NameIdentifier> outputs = DefaultSdkAutoConstructList.getInstance();

        private String runId;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenLineageRunEventSummary model) {
            eventType(model.eventType);
            inputs(model.inputs);
            job(model.job);
            outputs(model.outputs);
            runId(model.runId);
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(OpenLineageRunState eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final List<NameIdentifier.Builder> getInputs() {
            List<NameIdentifier.Builder> result = NameIdentifiersCopier.copyToBuilder(this.inputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputs(Collection<NameIdentifier.BuilderImpl> inputs) {
            this.inputs = NameIdentifiersCopier.copyFromBuilder(inputs);
        }

        @Override
        public final Builder inputs(Collection<NameIdentifier> inputs) {
            this.inputs = NameIdentifiersCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(NameIdentifier... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<NameIdentifier.Builder>... inputs) {
            inputs(Stream.of(inputs).map(c -> NameIdentifier.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final NameIdentifier.Builder getJob() {
            return job != null ? job.toBuilder() : null;
        }

        public final void setJob(NameIdentifier.BuilderImpl job) {
            this.job = job != null ? job.build() : null;
        }

        @Override
        public final Builder job(NameIdentifier job) {
            this.job = job;
            return this;
        }

        public final List<NameIdentifier.Builder> getOutputs() {
            List<NameIdentifier.Builder> result = NameIdentifiersCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<NameIdentifier.BuilderImpl> outputs) {
            this.outputs = NameIdentifiersCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<NameIdentifier> outputs) {
            this.outputs = NameIdentifiersCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(NameIdentifier... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<NameIdentifier.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> NameIdentifier.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRunId() {
            return runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        @Override
        public OpenLineageRunEventSummary build() {
            return new OpenLineageRunEventSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
