/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The MLflow properties of a connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MlflowPropertiesInput implements SdkPojo, Serializable,
        ToCopyableBuilder<MlflowPropertiesInput.Builder, MlflowPropertiesInput> {
    private static final SdkField<String> TRACKING_SERVER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trackingServerArn").getter(getter(MlflowPropertiesInput::trackingServerArn))
            .setter(setter(Builder::trackingServerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingServerArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKING_SERVER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String trackingServerArn;

    private MlflowPropertiesInput(BuilderImpl builder) {
        this.trackingServerArn = builder.trackingServerArn;
    }

    /**
     * <p>
     * The tracking server ARN as part of the MLflow properties of a connection.
     * </p>
     * 
     * @return The tracking server ARN as part of the MLflow properties of a connection.
     */
    public final String trackingServerArn() {
        return trackingServerArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trackingServerArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MlflowPropertiesInput)) {
            return false;
        }
        MlflowPropertiesInput other = (MlflowPropertiesInput) obj;
        return Objects.equals(trackingServerArn(), other.trackingServerArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MlflowPropertiesInput").add("TrackingServerArn", trackingServerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trackingServerArn":
            return Optional.ofNullable(clazz.cast(trackingServerArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("trackingServerArn", TRACKING_SERVER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MlflowPropertiesInput, T> g) {
        return obj -> g.apply((MlflowPropertiesInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MlflowPropertiesInput> {
        /**
         * <p>
         * The tracking server ARN as part of the MLflow properties of a connection.
         * </p>
         * 
         * @param trackingServerArn
         *        The tracking server ARN as part of the MLflow properties of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingServerArn(String trackingServerArn);
    }

    static final class BuilderImpl implements Builder {
        private String trackingServerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MlflowPropertiesInput model) {
            trackingServerArn(model.trackingServerArn);
        }

        public final String getTrackingServerArn() {
            return trackingServerArn;
        }

        public final void setTrackingServerArn(String trackingServerArn) {
            this.trackingServerArn = trackingServerArn;
        }

        @Override
        public final Builder trackingServerArn(String trackingServerArn) {
            this.trackingServerArn = trackingServerArn;
            return this;
        }

        @Override
        public MlflowPropertiesInput build() {
            return new MlflowPropertiesInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
