/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ManagedPolicyType {
    CREATE_DOMAIN_UNIT("CREATE_DOMAIN_UNIT"),

    OVERRIDE_DOMAIN_UNIT_OWNERS("OVERRIDE_DOMAIN_UNIT_OWNERS"),

    ADD_TO_PROJECT_MEMBER_POOL("ADD_TO_PROJECT_MEMBER_POOL"),

    OVERRIDE_PROJECT_OWNERS("OVERRIDE_PROJECT_OWNERS"),

    CREATE_GLOSSARY("CREATE_GLOSSARY"),

    CREATE_FORM_TYPE("CREATE_FORM_TYPE"),

    CREATE_ASSET_TYPE("CREATE_ASSET_TYPE"),

    CREATE_PROJECT("CREATE_PROJECT"),

    CREATE_ENVIRONMENT_PROFILE("CREATE_ENVIRONMENT_PROFILE"),

    DELEGATE_CREATE_ENVIRONMENT_PROFILE("DELEGATE_CREATE_ENVIRONMENT_PROFILE"),

    CREATE_ENVIRONMENT("CREATE_ENVIRONMENT"),

    CREATE_ENVIRONMENT_FROM_BLUEPRINT("CREATE_ENVIRONMENT_FROM_BLUEPRINT"),

    CREATE_PROJECT_FROM_PROJECT_PROFILE("CREATE_PROJECT_FROM_PROJECT_PROFILE"),

    USE_ASSET_TYPE("USE_ASSET_TYPE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ManagedPolicyType> VALUE_MAP = EnumUtils.uniqueIndex(ManagedPolicyType.class,
            ManagedPolicyType::toString);

    private final String value;

    private ManagedPolicyType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ManagedPolicyType corresponding to the value
     */
    public static ManagedPolicyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ManagedPolicyType}s
     */
    public static Set<ManagedPolicyType> knownValues() {
        Set<ManagedPolicyType> knownValues = EnumSet.allOf(ManagedPolicyType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
