/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNotificationsResponse extends DataZoneResponse implements
        ToCopyableBuilder<ListNotificationsResponse.Builder, ListNotificationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListNotificationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<NotificationOutput>> NOTIFICATIONS_FIELD = SdkField
            .<List<NotificationOutput>> builder(MarshallingType.LIST)
            .memberName("notifications")
            .getter(getter(ListNotificationsResponse::notifications))
            .setter(setter(Builder::notifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notifications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NotificationOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(NotificationOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            NOTIFICATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<NotificationOutput> notifications;

    private ListNotificationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.notifications = builder.notifications;
    }

    /**
     * <p>
     * When the number of notifications is greater than the default value for the <code>MaxResults</code> parameter, or
     * if you explicitly specify a value for <code>MaxResults</code> that is less than the number of notifications, the
     * response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code>
     * value in a subsequent call to <code>ListNotifications</code> to list the next set of notifications.
     * </p>
     * 
     * @return When the number of notifications is greater than the default value for the <code>MaxResults</code>
     *         parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number
     *         of notifications, the response includes a pagination token named <code>NextToken</code>. You can specify
     *         this <code>NextToken</code> value in a subsequent call to <code>ListNotifications</code> to list the next
     *         set of notifications.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Notifications property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNotifications() {
        return notifications != null && !(notifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The results of the <code>ListNotifications</code> action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotifications} method.
     * </p>
     * 
     * @return The results of the <code>ListNotifications</code> action.
     */
    public final List<NotificationOutput> notifications() {
        return notifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasNotifications() ? notifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotificationsResponse)) {
            return false;
        }
        ListNotificationsResponse other = (ListNotificationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasNotifications() == other.hasNotifications()
                && Objects.equals(notifications(), other.notifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListNotificationsResponse").add("NextToken", nextToken())
                .add("Notifications", hasNotifications() ? notifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "notifications":
            return Optional.ofNullable(clazz.cast(notifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("notifications", NOTIFICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListNotificationsResponse, T> g) {
        return obj -> g.apply((ListNotificationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListNotificationsResponse> {
        /**
         * <p>
         * When the number of notifications is greater than the default value for the <code>MaxResults</code> parameter,
         * or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of
         * notifications, the response includes a pagination token named <code>NextToken</code>. You can specify this
         * <code>NextToken</code> value in a subsequent call to <code>ListNotifications</code> to list the next set of
         * notifications.
         * </p>
         * 
         * @param nextToken
         *        When the number of notifications is greater than the default value for the <code>MaxResults</code>
         *        parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the
         *        number of notifications, the response includes a pagination token named <code>NextToken</code>. You
         *        can specify this <code>NextToken</code> value in a subsequent call to <code>ListNotifications</code>
         *        to list the next set of notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The results of the <code>ListNotifications</code> action.
         * </p>
         * 
         * @param notifications
         *        The results of the <code>ListNotifications</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notifications(Collection<NotificationOutput> notifications);

        /**
         * <p>
         * The results of the <code>ListNotifications</code> action.
         * </p>
         * 
         * @param notifications
         *        The results of the <code>ListNotifications</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notifications(NotificationOutput... notifications);

        /**
         * <p>
         * The results of the <code>ListNotifications</code> action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.NotificationOutput.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.datazone.model.NotificationOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.NotificationOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #notifications(List<NotificationOutput>)}.
         * 
         * @param notifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.NotificationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notifications(java.util.Collection<NotificationOutput>)
         */
        Builder notifications(Consumer<NotificationOutput.Builder>... notifications);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<NotificationOutput> notifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotificationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            notifications(model.notifications);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<NotificationOutput.Builder> getNotifications() {
            List<NotificationOutput.Builder> result = NotificationsListCopier.copyToBuilder(this.notifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotifications(Collection<NotificationOutput.BuilderImpl> notifications) {
            this.notifications = NotificationsListCopier.copyFromBuilder(notifications);
        }

        @Override
        public final Builder notifications(Collection<NotificationOutput> notifications) {
            this.notifications = NotificationsListCopier.copy(notifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notifications(NotificationOutput... notifications) {
            notifications(Arrays.asList(notifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notifications(Consumer<NotificationOutput.Builder>... notifications) {
            notifications(Stream.of(notifications).map(c -> NotificationOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListNotificationsResponse build() {
            return new ListNotificationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
