/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEnvironmentsRequest extends DataZoneRequest implements
        ToCopyableBuilder<ListEnvironmentsRequest.Builder, ListEnvironmentsRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountId").getter(getter(ListEnvironmentsRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("awsAccountId").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountRegion").getter(getter(ListEnvironmentsRequest::awsAccountRegion))
            .setter(setter(Builder::awsAccountRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("awsAccountRegion").build())
            .build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(ListEnvironmentsRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> ENVIRONMENT_BLUEPRINT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("environmentBlueprintIdentifier")
            .getter(getter(ListEnvironmentsRequest::environmentBlueprintIdentifier))
            .setter(setter(Builder::environmentBlueprintIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("environmentBlueprintIdentifier")
                    .build()).build();

    private static final SdkField<String> ENVIRONMENT_PROFILE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("environmentProfileIdentifier")
            .getter(getter(ListEnvironmentsRequest::environmentProfileIdentifier))
            .setter(setter(Builder::environmentProfileIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("environmentProfileIdentifier")
                    .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListEnvironmentsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ListEnvironmentsRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEnvironmentsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> PROJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectIdentifier").getter(getter(ListEnvironmentsRequest::projectIdentifier))
            .setter(setter(Builder::projectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("projectIdentifier").build())
            .build();

    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provider").getter(getter(ListEnvironmentsRequest::provider)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("provider").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ListEnvironmentsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            AWS_ACCOUNT_REGION_FIELD, DOMAIN_IDENTIFIER_FIELD, ENVIRONMENT_BLUEPRINT_IDENTIFIER_FIELD,
            ENVIRONMENT_PROFILE_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NAME_FIELD, NEXT_TOKEN_FIELD, PROJECT_IDENTIFIER_FIELD,
            PROVIDER_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String awsAccountRegion;

    private final String domainIdentifier;

    private final String environmentBlueprintIdentifier;

    private final String environmentProfileIdentifier;

    private final Integer maxResults;

    private final String name;

    private final String nextToken;

    private final String projectIdentifier;

    private final String provider;

    private final String status;

    private ListEnvironmentsRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.awsAccountRegion = builder.awsAccountRegion;
        this.domainIdentifier = builder.domainIdentifier;
        this.environmentBlueprintIdentifier = builder.environmentBlueprintIdentifier;
        this.environmentProfileIdentifier = builder.environmentProfileIdentifier;
        this.maxResults = builder.maxResults;
        this.name = builder.name;
        this.nextToken = builder.nextToken;
        this.projectIdentifier = builder.projectIdentifier;
        this.provider = builder.provider;
        this.status = builder.status;
    }

    /**
     * <p>
     * The identifier of the Amazon Web Services account where you want to list environments.
     * </p>
     * 
     * @return The identifier of the Amazon Web Services account where you want to list environments.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The Amazon Web Services region where you want to list environments.
     * </p>
     * 
     * @return The Amazon Web Services region where you want to list environments.
     */
    public final String awsAccountRegion() {
        return awsAccountRegion;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone blueprint.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone blueprint.
     */
    public final String environmentBlueprintIdentifier() {
        return environmentBlueprintIdentifier;
    }

    /**
     * <p>
     * The identifier of the environment profile.
     * </p>
     * 
     * @return The identifier of the environment profile.
     */
    public final String environmentProfileIdentifier() {
        return environmentProfileIdentifier;
    }

    /**
     * <p>
     * The maximum number of environments to return in a single call to <code>ListEnvironments</code>. When the number
     * of environments to be listed is greater than the value of <code>MaxResults</code>, the response contains a
     * <code>NextToken</code> value that you can use in a subsequent call to <code>ListEnvironments</code> to list the
     * next set of environments.
     * </p>
     * 
     * @return The maximum number of environments to return in a single call to <code>ListEnvironments</code>. When the
     *         number of environments to be listed is greater than the value of <code>MaxResults</code>, the response
     *         contains a <code>NextToken</code> value that you can use in a subsequent call to
     *         <code>ListEnvironments</code> to list the next set of environments.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The name of the environment.
     * </p>
     * 
     * @return The name of the environment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * When the number of environments is greater than the default value for the <code>MaxResults</code> parameter, or
     * if you explicitly specify a value for <code>MaxResults</code> that is less than the number of environments, the
     * response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code>
     * value in a subsequent call to <code>ListEnvironments</code> to list the next set of environments.
     * </p>
     * 
     * @return When the number of environments is greater than the default value for the <code>MaxResults</code>
     *         parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number
     *         of environments, the response includes a pagination token named <code>NextToken</code>. You can specify
     *         this <code>NextToken</code> value in a subsequent call to <code>ListEnvironments</code> to list the next
     *         set of environments.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone project.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone project.
     */
    public final String projectIdentifier() {
        return projectIdentifier;
    }

    /**
     * <p>
     * The provider of the environment.
     * </p>
     * 
     * @return The provider of the environment.
     */
    public final String provider() {
        return provider;
    }

    /**
     * <p>
     * The status of the environments that you want to list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the environments that you want to list.
     * @see EnvironmentStatus
     */
    public final EnvironmentStatus status() {
        return EnvironmentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the environments that you want to list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the environments that you want to list.
     * @see EnvironmentStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountRegion());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(environmentBlueprintIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(environmentProfileIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(projectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(provider());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentsRequest)) {
            return false;
        }
        ListEnvironmentsRequest other = (ListEnvironmentsRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(awsAccountRegion(), other.awsAccountRegion())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(environmentBlueprintIdentifier(), other.environmentBlueprintIdentifier())
                && Objects.equals(environmentProfileIdentifier(), other.environmentProfileIdentifier())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(name(), other.name())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(projectIdentifier(), other.projectIdentifier()) && Objects.equals(provider(), other.provider())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEnvironmentsRequest").add("AwsAccountId", awsAccountId())
                .add("AwsAccountRegion", awsAccountRegion()).add("DomainIdentifier", domainIdentifier())
                .add("EnvironmentBlueprintIdentifier", environmentBlueprintIdentifier())
                .add("EnvironmentProfileIdentifier", environmentProfileIdentifier()).add("MaxResults", maxResults())
                .add("Name", name()).add("NextToken", nextToken()).add("ProjectIdentifier", projectIdentifier())
                .add("Provider", provider()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "awsAccountRegion":
            return Optional.ofNullable(clazz.cast(awsAccountRegion()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "environmentBlueprintIdentifier":
            return Optional.ofNullable(clazz.cast(environmentBlueprintIdentifier()));
        case "environmentProfileIdentifier":
            return Optional.ofNullable(clazz.cast(environmentProfileIdentifier()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "projectIdentifier":
            return Optional.ofNullable(clazz.cast(projectIdentifier()));
        case "provider":
            return Optional.ofNullable(clazz.cast(provider()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("awsAccountRegion", AWS_ACCOUNT_REGION_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("environmentBlueprintIdentifier", ENVIRONMENT_BLUEPRINT_IDENTIFIER_FIELD);
        map.put("environmentProfileIdentifier", ENVIRONMENT_PROFILE_IDENTIFIER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("projectIdentifier", PROJECT_IDENTIFIER_FIELD);
        map.put("provider", PROVIDER_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentsRequest, T> g) {
        return obj -> g.apply((ListEnvironmentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListEnvironmentsRequest> {
        /**
         * <p>
         * The identifier of the Amazon Web Services account where you want to list environments.
         * </p>
         * 
         * @param awsAccountId
         *        The identifier of the Amazon Web Services account where you want to list environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The Amazon Web Services region where you want to list environments.
         * </p>
         * 
         * @param awsAccountRegion
         *        The Amazon Web Services region where you want to list environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountRegion(String awsAccountRegion);

        /**
         * <p>
         * The identifier of the Amazon DataZone domain.
         * </p>
         * 
         * @param domainIdentifier
         *        The identifier of the Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The identifier of the Amazon DataZone blueprint.
         * </p>
         * 
         * @param environmentBlueprintIdentifier
         *        The identifier of the Amazon DataZone blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentBlueprintIdentifier(String environmentBlueprintIdentifier);

        /**
         * <p>
         * The identifier of the environment profile.
         * </p>
         * 
         * @param environmentProfileIdentifier
         *        The identifier of the environment profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentProfileIdentifier(String environmentProfileIdentifier);

        /**
         * <p>
         * The maximum number of environments to return in a single call to <code>ListEnvironments</code>. When the
         * number of environments to be listed is greater than the value of <code>MaxResults</code>, the response
         * contains a <code>NextToken</code> value that you can use in a subsequent call to
         * <code>ListEnvironments</code> to list the next set of environments.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of environments to return in a single call to <code>ListEnvironments</code>. When
         *        the number of environments to be listed is greater than the value of <code>MaxResults</code>, the
         *        response contains a <code>NextToken</code> value that you can use in a subsequent call to
         *        <code>ListEnvironments</code> to list the next set of environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The name of the environment.
         * </p>
         * 
         * @param name
         *        The name of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * When the number of environments is greater than the default value for the <code>MaxResults</code> parameter,
         * or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of
         * environments, the response includes a pagination token named <code>NextToken</code>. You can specify this
         * <code>NextToken</code> value in a subsequent call to <code>ListEnvironments</code> to list the next set of
         * environments.
         * </p>
         * 
         * @param nextToken
         *        When the number of environments is greater than the default value for the <code>MaxResults</code>
         *        parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the
         *        number of environments, the response includes a pagination token named <code>NextToken</code>. You can
         *        specify this <code>NextToken</code> value in a subsequent call to <code>ListEnvironments</code> to
         *        list the next set of environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The identifier of the Amazon DataZone project.
         * </p>
         * 
         * @param projectIdentifier
         *        The identifier of the Amazon DataZone project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectIdentifier(String projectIdentifier);

        /**
         * <p>
         * The provider of the environment.
         * </p>
         * 
         * @param provider
         *        The provider of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provider(String provider);

        /**
         * <p>
         * The status of the environments that you want to list.
         * </p>
         * 
         * @param status
         *        The status of the environments that you want to list.
         * @see EnvironmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the environments that you want to list.
         * </p>
         * 
         * @param status
         *        The status of the environments that you want to list.
         * @see EnvironmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentStatus
         */
        Builder status(EnvironmentStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String awsAccountRegion;

        private String domainIdentifier;

        private String environmentBlueprintIdentifier;

        private String environmentProfileIdentifier;

        private Integer maxResults;

        private String name;

        private String nextToken;

        private String projectIdentifier;

        private String provider;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentsRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            awsAccountRegion(model.awsAccountRegion);
            domainIdentifier(model.domainIdentifier);
            environmentBlueprintIdentifier(model.environmentBlueprintIdentifier);
            environmentProfileIdentifier(model.environmentProfileIdentifier);
            maxResults(model.maxResults);
            name(model.name);
            nextToken(model.nextToken);
            projectIdentifier(model.projectIdentifier);
            provider(model.provider);
            status(model.status);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAwsAccountRegion() {
            return awsAccountRegion;
        }

        public final void setAwsAccountRegion(String awsAccountRegion) {
            this.awsAccountRegion = awsAccountRegion;
        }

        @Override
        public final Builder awsAccountRegion(String awsAccountRegion) {
            this.awsAccountRegion = awsAccountRegion;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnvironmentBlueprintIdentifier() {
            return environmentBlueprintIdentifier;
        }

        public final void setEnvironmentBlueprintIdentifier(String environmentBlueprintIdentifier) {
            this.environmentBlueprintIdentifier = environmentBlueprintIdentifier;
        }

        @Override
        public final Builder environmentBlueprintIdentifier(String environmentBlueprintIdentifier) {
            this.environmentBlueprintIdentifier = environmentBlueprintIdentifier;
            return this;
        }

        public final String getEnvironmentProfileIdentifier() {
            return environmentProfileIdentifier;
        }

        public final void setEnvironmentProfileIdentifier(String environmentProfileIdentifier) {
            this.environmentProfileIdentifier = environmentProfileIdentifier;
        }

        @Override
        public final Builder environmentProfileIdentifier(String environmentProfileIdentifier) {
            this.environmentProfileIdentifier = environmentProfileIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getProjectIdentifier() {
            return projectIdentifier;
        }

        public final void setProjectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
        }

        @Override
        public final Builder projectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
            return this;
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEnvironmentsRequest build() {
            return new ListEnvironmentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
