/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The hyper pod properties of a Amazon Web Services Glue properties patch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HyperPodPropertiesOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<HyperPodPropertiesOutput.Builder, HyperPodPropertiesOutput> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterArn").getter(getter(HyperPodPropertiesOutput::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()).build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(HyperPodPropertiesOutput::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<String> ORCHESTRATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("orchestrator").getter(getter(HyperPodPropertiesOutput::orchestratorAsString))
            .setter(setter(Builder::orchestrator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orchestrator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            CLUSTER_NAME_FIELD, ORCHESTRATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clusterArn;

    private final String clusterName;

    private final String orchestrator;

    private HyperPodPropertiesOutput(BuilderImpl builder) {
        this.clusterArn = builder.clusterArn;
        this.clusterName = builder.clusterName;
        this.orchestrator = builder.orchestrator;
    }

    /**
     * <p>
     * The cluster ARN of the hyper pod properties.
     * </p>
     * 
     * @return The cluster ARN of the hyper pod properties.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * The cluster name the hyper pod properties.
     * </p>
     * 
     * @return The cluster name the hyper pod properties.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The orchestrator of the hyper pod properties.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orchestrator} will
     * return {@link HyperPodOrchestrator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #orchestratorAsString}.
     * </p>
     * 
     * @return The orchestrator of the hyper pod properties.
     * @see HyperPodOrchestrator
     */
    public final HyperPodOrchestrator orchestrator() {
        return HyperPodOrchestrator.fromValue(orchestrator);
    }

    /**
     * <p>
     * The orchestrator of the hyper pod properties.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orchestrator} will
     * return {@link HyperPodOrchestrator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #orchestratorAsString}.
     * </p>
     * 
     * @return The orchestrator of the hyper pod properties.
     * @see HyperPodOrchestrator
     */
    public final String orchestratorAsString() {
        return orchestrator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(orchestratorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperPodPropertiesOutput)) {
            return false;
        }
        HyperPodPropertiesOutput other = (HyperPodPropertiesOutput) obj;
        return Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(orchestratorAsString(), other.orchestratorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HyperPodPropertiesOutput").add("ClusterArn", clusterArn()).add("ClusterName", clusterName())
                .add("Orchestrator", orchestratorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "orchestrator":
            return Optional.ofNullable(clazz.cast(orchestratorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusterArn", CLUSTER_ARN_FIELD);
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("orchestrator", ORCHESTRATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HyperPodPropertiesOutput, T> g) {
        return obj -> g.apply((HyperPodPropertiesOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HyperPodPropertiesOutput> {
        /**
         * <p>
         * The cluster ARN of the hyper pod properties.
         * </p>
         * 
         * @param clusterArn
         *        The cluster ARN of the hyper pod properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * The cluster name the hyper pod properties.
         * </p>
         * 
         * @param clusterName
         *        The cluster name the hyper pod properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The orchestrator of the hyper pod properties.
         * </p>
         * 
         * @param orchestrator
         *        The orchestrator of the hyper pod properties.
         * @see HyperPodOrchestrator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HyperPodOrchestrator
         */
        Builder orchestrator(String orchestrator);

        /**
         * <p>
         * The orchestrator of the hyper pod properties.
         * </p>
         * 
         * @param orchestrator
         *        The orchestrator of the hyper pod properties.
         * @see HyperPodOrchestrator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HyperPodOrchestrator
         */
        Builder orchestrator(HyperPodOrchestrator orchestrator);
    }

    static final class BuilderImpl implements Builder {
        private String clusterArn;

        private String clusterName;

        private String orchestrator;

        private BuilderImpl() {
        }

        private BuilderImpl(HyperPodPropertiesOutput model) {
            clusterArn(model.clusterArn);
            clusterName(model.clusterName);
            orchestrator(model.orchestrator);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getOrchestrator() {
            return orchestrator;
        }

        public final void setOrchestrator(String orchestrator) {
            this.orchestrator = orchestrator;
        }

        @Override
        public final Builder orchestrator(String orchestrator) {
            this.orchestrator = orchestrator;
            return this;
        }

        @Override
        public final Builder orchestrator(HyperPodOrchestrator orchestrator) {
            this.orchestrator(orchestrator == null ? null : orchestrator.toString());
            return this;
        }

        @Override
        public HyperPodPropertiesOutput build() {
            return new HyperPodPropertiesOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
