/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a listing for which a subscription is to be granted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GrantedEntityInput implements SdkPojo, Serializable,
        ToCopyableBuilder<GrantedEntityInput.Builder, GrantedEntityInput> {
    private static final SdkField<ListingRevisionInput> LISTING_FIELD = SdkField
            .<ListingRevisionInput> builder(MarshallingType.SDK_POJO).memberName("listing")
            .getter(getter(GrantedEntityInput::listing)).setter(setter(Builder::listing))
            .constructor(ListingRevisionInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listing").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ListingRevisionInput listing;

    private final Type type;

    private GrantedEntityInput(BuilderImpl builder) {
        this.listing = builder.listing;
        this.type = builder.type;
    }

    /**
     * <p>
     * The listing for which a subscription is to be granted.
     * </p>
     * 
     * @return The listing for which a subscription is to be granted.
     */
    public final ListingRevisionInput listing() {
        return listing;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(listing());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrantedEntityInput)) {
            return false;
        }
        GrantedEntityInput other = (GrantedEntityInput) obj;
        return Objects.equals(listing(), other.listing());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GrantedEntityInput").add("Listing", listing()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "listing":
            return Optional.ofNullable(clazz.cast(listing()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #listing()} initialized to the given value.
     *
     * <p>
     * The listing for which a subscription is to be granted.
     * </p>
     * 
     * @param listing
     *        The listing for which a subscription is to be granted.
     */
    public static GrantedEntityInput fromListing(ListingRevisionInput listing) {
        return builder().listing(listing).build();
    }

    /**
     * Create an instance of this class with {@link #listing()} initialized to the given value.
     *
     * <p>
     * The listing for which a subscription is to be granted.
     * </p>
     * 
     * @param listing
     *        The listing for which a subscription is to be granted.
     */
    public static GrantedEntityInput fromListing(Consumer<ListingRevisionInput.Builder> listing) {
        ListingRevisionInput.Builder builder = ListingRevisionInput.builder();
        listing.accept(builder);
        return fromListing(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("listing", LISTING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GrantedEntityInput, T> g) {
        return obj -> g.apply((GrantedEntityInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GrantedEntityInput> {
        /**
         * <p>
         * The listing for which a subscription is to be granted.
         * </p>
         * 
         * @param listing
         *        The listing for which a subscription is to be granted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listing(ListingRevisionInput listing);

        /**
         * <p>
         * The listing for which a subscription is to be granted.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListingRevisionInput.Builder} avoiding
         * the need to create one manually via {@link ListingRevisionInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListingRevisionInput.Builder#build()} is called immediately and
         * its result is passed to {@link #listing(ListingRevisionInput)}.
         * 
         * @param listing
         *        a consumer that will call methods on {@link ListingRevisionInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listing(ListingRevisionInput)
         */
        default Builder listing(Consumer<ListingRevisionInput.Builder> listing) {
            return listing(ListingRevisionInput.builder().applyMutation(listing).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ListingRevisionInput listing;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(GrantedEntityInput model) {
            listing(model.listing);
        }

        public final ListingRevisionInput.Builder getListing() {
            return listing != null ? listing.toBuilder() : null;
        }

        public final void setListing(ListingRevisionInput.BuilderImpl listing) {
            Object oldValue = this.listing;
            this.listing = listing != null ? listing.build() : null;
            handleUnionValueChange(Type.LISTING, oldValue, this.listing);
        }

        @Override
        public final Builder listing(ListingRevisionInput listing) {
            Object oldValue = this.listing;
            this.listing = listing;
            handleUnionValueChange(Type.LISTING, oldValue, this.listing);
            return this;
        }

        @Override
        public GrantedEntityInput build() {
            return new GrantedEntityInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see GrantedEntityInput#type()
     */
    public enum Type {
        LISTING,

        UNKNOWN_TO_SDK_VERSION
    }
}
