/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The activity details of the data source run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceRunActivity implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceRunActivity.Builder, DataSourceRunActivity> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(DataSourceRunActivity::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DATA_ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataAssetId").getter(getter(DataSourceRunActivity::dataAssetId)).setter(setter(Builder::dataAssetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAssetId").build()).build();

    private static final SdkField<String> DATA_ASSET_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataAssetStatus").getter(getter(DataSourceRunActivity::dataAssetStatusAsString))
            .setter(setter(Builder::dataAssetStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAssetStatus").build()).build();

    private static final SdkField<String> DATA_SOURCE_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceRunId").getter(getter(DataSourceRunActivity::dataSourceRunId))
            .setter(setter(Builder::dataSourceRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceRunId").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("database").getter(getter(DataSourceRunActivity::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("database").build()).build();

    private static final SdkField<DataSourceErrorMessage> ERROR_MESSAGE_FIELD = SdkField
            .<DataSourceErrorMessage> builder(MarshallingType.SDK_POJO).memberName("errorMessage")
            .getter(getter(DataSourceRunActivity::errorMessage)).setter(setter(Builder::errorMessage))
            .constructor(DataSourceErrorMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<LineageInfo> LINEAGE_SUMMARY_FIELD = SdkField.<LineageInfo> builder(MarshallingType.SDK_POJO)
            .memberName("lineageSummary").getter(getter(DataSourceRunActivity::lineageSummary))
            .setter(setter(Builder::lineageSummary)).constructor(LineageInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineageSummary").build()).build();

    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectId").getter(getter(DataSourceRunActivity::projectId)).setter(setter(Builder::projectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()).build();

    private static final SdkField<String> TECHNICAL_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("technicalDescription").getter(getter(DataSourceRunActivity::technicalDescription))
            .setter(setter(Builder::technicalDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("technicalDescription").build())
            .build();

    private static final SdkField<String> TECHNICAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("technicalName").getter(getter(DataSourceRunActivity::technicalName))
            .setter(setter(Builder::technicalName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("technicalName").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(DataSourceRunActivity::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            DATA_ASSET_ID_FIELD, DATA_ASSET_STATUS_FIELD, DATA_SOURCE_RUN_ID_FIELD, DATABASE_FIELD, ERROR_MESSAGE_FIELD,
            LINEAGE_SUMMARY_FIELD, PROJECT_ID_FIELD, TECHNICAL_DESCRIPTION_FIELD, TECHNICAL_NAME_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String dataAssetId;

    private final String dataAssetStatus;

    private final String dataSourceRunId;

    private final String database;

    private final DataSourceErrorMessage errorMessage;

    private final LineageInfo lineageSummary;

    private final String projectId;

    private final String technicalDescription;

    private final String technicalName;

    private final Instant updatedAt;

    private DataSourceRunActivity(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.dataAssetId = builder.dataAssetId;
        this.dataAssetStatus = builder.dataAssetStatus;
        this.dataSourceRunId = builder.dataSourceRunId;
        this.database = builder.database;
        this.errorMessage = builder.errorMessage;
        this.lineageSummary = builder.lineageSummary;
        this.projectId = builder.projectId;
        this.technicalDescription = builder.technicalDescription;
        this.technicalName = builder.technicalName;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The timestamp of when data source run activity was created.
     * </p>
     * 
     * @return The timestamp of when data source run activity was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The identifier of the asset included in the data source run activity.
     * </p>
     * 
     * @return The identifier of the asset included in the data source run activity.
     */
    public final String dataAssetId() {
        return dataAssetId;
    }

    /**
     * <p>
     * The status of the asset included in the data source run activity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataAssetStatus}
     * will return {@link DataAssetActivityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dataAssetStatusAsString}.
     * </p>
     * 
     * @return The status of the asset included in the data source run activity.
     * @see DataAssetActivityStatus
     */
    public final DataAssetActivityStatus dataAssetStatus() {
        return DataAssetActivityStatus.fromValue(dataAssetStatus);
    }

    /**
     * <p>
     * The status of the asset included in the data source run activity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataAssetStatus}
     * will return {@link DataAssetActivityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dataAssetStatusAsString}.
     * </p>
     * 
     * @return The status of the asset included in the data source run activity.
     * @see DataAssetActivityStatus
     */
    public final String dataAssetStatusAsString() {
        return dataAssetStatus;
    }

    /**
     * <p>
     * The identifier of the data source for the data source run activity.
     * </p>
     * 
     * @return The identifier of the data source for the data source run activity.
     */
    public final String dataSourceRunId() {
        return dataSourceRunId;
    }

    /**
     * <p>
     * The database included in the data source run activity.
     * </p>
     * 
     * @return The database included in the data source run activity.
     */
    public final String database() {
        return database;
    }

    /**
     * Returns the value of the ErrorMessage property for this object.
     * 
     * @return The value of the ErrorMessage property for this object.
     */
    public final DataSourceErrorMessage errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The data lineage summary.
     * </p>
     * 
     * @return The data lineage summary.
     */
    public final LineageInfo lineageSummary() {
        return lineageSummary;
    }

    /**
     * <p>
     * The project ID included in the data source run activity.
     * </p>
     * 
     * @return The project ID included in the data source run activity.
     */
    public final String projectId() {
        return projectId;
    }

    /**
     * <p>
     * The technical description included in the data source run activity.
     * </p>
     * 
     * @return The technical description included in the data source run activity.
     */
    public final String technicalDescription() {
        return technicalDescription;
    }

    /**
     * <p>
     * The technical name included in the data source run activity.
     * </p>
     * 
     * @return The technical name included in the data source run activity.
     */
    public final String technicalName() {
        return technicalName;
    }

    /**
     * <p>
     * The timestamp of when data source run activity was updated.
     * </p>
     * 
     * @return The timestamp of when data source run activity was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(dataAssetId());
        hashCode = 31 * hashCode + Objects.hashCode(dataAssetStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceRunId());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(lineageSummary());
        hashCode = 31 * hashCode + Objects.hashCode(projectId());
        hashCode = 31 * hashCode + Objects.hashCode(technicalDescription());
        hashCode = 31 * hashCode + Objects.hashCode(technicalName());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceRunActivity)) {
            return false;
        }
        DataSourceRunActivity other = (DataSourceRunActivity) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(dataAssetId(), other.dataAssetId())
                && Objects.equals(dataAssetStatusAsString(), other.dataAssetStatusAsString())
                && Objects.equals(dataSourceRunId(), other.dataSourceRunId()) && Objects.equals(database(), other.database())
                && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(lineageSummary(), other.lineageSummary()) && Objects.equals(projectId(), other.projectId())
                && Objects.equals(technicalDescription(), other.technicalDescription())
                && Objects.equals(technicalName(), other.technicalName()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceRunActivity").add("CreatedAt", createdAt()).add("DataAssetId", dataAssetId())
                .add("DataAssetStatus", dataAssetStatusAsString()).add("DataSourceRunId", dataSourceRunId())
                .add("Database", database() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ErrorMessage", errorMessage()).add("LineageSummary", lineageSummary()).add("ProjectId", projectId())
                .add("TechnicalDescription", technicalDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TechnicalName", technicalName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "dataAssetId":
            return Optional.ofNullable(clazz.cast(dataAssetId()));
        case "dataAssetStatus":
            return Optional.ofNullable(clazz.cast(dataAssetStatusAsString()));
        case "dataSourceRunId":
            return Optional.ofNullable(clazz.cast(dataSourceRunId()));
        case "database":
            return Optional.ofNullable(clazz.cast(database()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "lineageSummary":
            return Optional.ofNullable(clazz.cast(lineageSummary()));
        case "projectId":
            return Optional.ofNullable(clazz.cast(projectId()));
        case "technicalDescription":
            return Optional.ofNullable(clazz.cast(technicalDescription()));
        case "technicalName":
            return Optional.ofNullable(clazz.cast(technicalName()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("dataAssetId", DATA_ASSET_ID_FIELD);
        map.put("dataAssetStatus", DATA_ASSET_STATUS_FIELD);
        map.put("dataSourceRunId", DATA_SOURCE_RUN_ID_FIELD);
        map.put("database", DATABASE_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("lineageSummary", LINEAGE_SUMMARY_FIELD);
        map.put("projectId", PROJECT_ID_FIELD);
        map.put("technicalDescription", TECHNICAL_DESCRIPTION_FIELD);
        map.put("technicalName", TECHNICAL_NAME_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceRunActivity, T> g) {
        return obj -> g.apply((DataSourceRunActivity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceRunActivity> {
        /**
         * <p>
         * The timestamp of when data source run activity was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when data source run activity was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The identifier of the asset included in the data source run activity.
         * </p>
         * 
         * @param dataAssetId
         *        The identifier of the asset included in the data source run activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAssetId(String dataAssetId);

        /**
         * <p>
         * The status of the asset included in the data source run activity.
         * </p>
         * 
         * @param dataAssetStatus
         *        The status of the asset included in the data source run activity.
         * @see DataAssetActivityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataAssetActivityStatus
         */
        Builder dataAssetStatus(String dataAssetStatus);

        /**
         * <p>
         * The status of the asset included in the data source run activity.
         * </p>
         * 
         * @param dataAssetStatus
         *        The status of the asset included in the data source run activity.
         * @see DataAssetActivityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataAssetActivityStatus
         */
        Builder dataAssetStatus(DataAssetActivityStatus dataAssetStatus);

        /**
         * <p>
         * The identifier of the data source for the data source run activity.
         * </p>
         * 
         * @param dataSourceRunId
         *        The identifier of the data source for the data source run activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceRunId(String dataSourceRunId);

        /**
         * <p>
         * The database included in the data source run activity.
         * </p>
         * 
         * @param database
         *        The database included in the data source run activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * Sets the value of the ErrorMessage property for this object.
         *
         * @param errorMessage
         *        The new value for the ErrorMessage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(DataSourceErrorMessage errorMessage);

        /**
         * Sets the value of the ErrorMessage property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DataSourceErrorMessage.Builder} avoiding
         * the need to create one manually via {@link DataSourceErrorMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceErrorMessage.Builder#build()} is called immediately and
         * its result is passed to {@link #errorMessage(DataSourceErrorMessage)}.
         * 
         * @param errorMessage
         *        a consumer that will call methods on {@link DataSourceErrorMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorMessage(DataSourceErrorMessage)
         */
        default Builder errorMessage(Consumer<DataSourceErrorMessage.Builder> errorMessage) {
            return errorMessage(DataSourceErrorMessage.builder().applyMutation(errorMessage).build());
        }

        /**
         * <p>
         * The data lineage summary.
         * </p>
         * 
         * @param lineageSummary
         *        The data lineage summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineageSummary(LineageInfo lineageSummary);

        /**
         * <p>
         * The data lineage summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link LineageInfo.Builder} avoiding the need to
         * create one manually via {@link LineageInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LineageInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #lineageSummary(LineageInfo)}.
         * 
         * @param lineageSummary
         *        a consumer that will call methods on {@link LineageInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lineageSummary(LineageInfo)
         */
        default Builder lineageSummary(Consumer<LineageInfo.Builder> lineageSummary) {
            return lineageSummary(LineageInfo.builder().applyMutation(lineageSummary).build());
        }

        /**
         * <p>
         * The project ID included in the data source run activity.
         * </p>
         * 
         * @param projectId
         *        The project ID included in the data source run activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectId(String projectId);

        /**
         * <p>
         * The technical description included in the data source run activity.
         * </p>
         * 
         * @param technicalDescription
         *        The technical description included in the data source run activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder technicalDescription(String technicalDescription);

        /**
         * <p>
         * The technical name included in the data source run activity.
         * </p>
         * 
         * @param technicalName
         *        The technical name included in the data source run activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder technicalName(String technicalName);

        /**
         * <p>
         * The timestamp of when data source run activity was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when data source run activity was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String dataAssetId;

        private String dataAssetStatus;

        private String dataSourceRunId;

        private String database;

        private DataSourceErrorMessage errorMessage;

        private LineageInfo lineageSummary;

        private String projectId;

        private String technicalDescription;

        private String technicalName;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceRunActivity model) {
            createdAt(model.createdAt);
            dataAssetId(model.dataAssetId);
            dataAssetStatus(model.dataAssetStatus);
            dataSourceRunId(model.dataSourceRunId);
            database(model.database);
            errorMessage(model.errorMessage);
            lineageSummary(model.lineageSummary);
            projectId(model.projectId);
            technicalDescription(model.technicalDescription);
            technicalName(model.technicalName);
            updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDataAssetId() {
            return dataAssetId;
        }

        public final void setDataAssetId(String dataAssetId) {
            this.dataAssetId = dataAssetId;
        }

        @Override
        public final Builder dataAssetId(String dataAssetId) {
            this.dataAssetId = dataAssetId;
            return this;
        }

        public final String getDataAssetStatus() {
            return dataAssetStatus;
        }

        public final void setDataAssetStatus(String dataAssetStatus) {
            this.dataAssetStatus = dataAssetStatus;
        }

        @Override
        public final Builder dataAssetStatus(String dataAssetStatus) {
            this.dataAssetStatus = dataAssetStatus;
            return this;
        }

        @Override
        public final Builder dataAssetStatus(DataAssetActivityStatus dataAssetStatus) {
            this.dataAssetStatus(dataAssetStatus == null ? null : dataAssetStatus.toString());
            return this;
        }

        public final String getDataSourceRunId() {
            return dataSourceRunId;
        }

        public final void setDataSourceRunId(String dataSourceRunId) {
            this.dataSourceRunId = dataSourceRunId;
        }

        @Override
        public final Builder dataSourceRunId(String dataSourceRunId) {
            this.dataSourceRunId = dataSourceRunId;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final DataSourceErrorMessage.Builder getErrorMessage() {
            return errorMessage != null ? errorMessage.toBuilder() : null;
        }

        public final void setErrorMessage(DataSourceErrorMessage.BuilderImpl errorMessage) {
            this.errorMessage = errorMessage != null ? errorMessage.build() : null;
        }

        @Override
        public final Builder errorMessage(DataSourceErrorMessage errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final LineageInfo.Builder getLineageSummary() {
            return lineageSummary != null ? lineageSummary.toBuilder() : null;
        }

        public final void setLineageSummary(LineageInfo.BuilderImpl lineageSummary) {
            this.lineageSummary = lineageSummary != null ? lineageSummary.build() : null;
        }

        @Override
        public final Builder lineageSummary(LineageInfo lineageSummary) {
            this.lineageSummary = lineageSummary;
            return this;
        }

        public final String getProjectId() {
            return projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final String getTechnicalDescription() {
            return technicalDescription;
        }

        public final void setTechnicalDescription(String technicalDescription) {
            this.technicalDescription = technicalDescription;
        }

        @Override
        public final Builder technicalDescription(String technicalDescription) {
            this.technicalDescription = technicalDescription;
            return this;
        }

        public final String getTechnicalName() {
            return technicalName;
        }

        public final void setTechnicalName(String technicalName) {
            this.technicalName = technicalName;
        }

        @Override
        public final Builder technicalName(String technicalName) {
            this.technicalName = technicalName;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public DataSourceRunActivity build() {
            return new DataSourceRunActivity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
