/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSubscriptionGrantResponse extends DataZoneResponse implements
        ToCopyableBuilder<CreateSubscriptionGrantResponse.Builder, CreateSubscriptionGrantResponse> {
    private static final SdkField<List<SubscribedAsset>> ASSETS_FIELD = SdkField
            .<List<SubscribedAsset>> builder(MarshallingType.LIST)
            .memberName("assets")
            .getter(getter(CreateSubscriptionGrantResponse::assets))
            .setter(setter(Builder::assets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubscribedAsset> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubscribedAsset::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(CreateSubscriptionGrantResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(CreateSubscriptionGrantResponse::createdBy))
            .setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(CreateSubscriptionGrantResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(CreateSubscriptionGrantResponse::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<GrantedEntity> GRANTED_ENTITY_FIELD = SdkField
            .<GrantedEntity> builder(MarshallingType.SDK_POJO).memberName("grantedEntity")
            .getter(getter(CreateSubscriptionGrantResponse::grantedEntity)).setter(setter(Builder::grantedEntity))
            .constructor(GrantedEntity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grantedEntity").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateSubscriptionGrantResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateSubscriptionGrantResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> SUBSCRIPTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subscriptionId").getter(getter(CreateSubscriptionGrantResponse::subscriptionId))
            .setter(setter(Builder::subscriptionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionId").build()).build();

    private static final SdkField<String> SUBSCRIPTION_TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subscriptionTargetId").getter(getter(CreateSubscriptionGrantResponse::subscriptionTargetId))
            .setter(setter(Builder::subscriptionTargetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionTargetId").build())
            .build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(CreateSubscriptionGrantResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(CreateSubscriptionGrantResponse::updatedBy))
            .setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSETS_FIELD,
            CREATED_AT_FIELD, CREATED_BY_FIELD, DOMAIN_ID_FIELD, ENVIRONMENT_ID_FIELD, GRANTED_ENTITY_FIELD, ID_FIELD,
            STATUS_FIELD, SUBSCRIPTION_ID_FIELD, SUBSCRIPTION_TARGET_ID_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SubscribedAsset> assets;

    private final Instant createdAt;

    private final String createdBy;

    private final String domainId;

    private final String environmentId;

    private final GrantedEntity grantedEntity;

    private final String id;

    private final String status;

    private final String subscriptionId;

    private final String subscriptionTargetId;

    private final Instant updatedAt;

    private final String updatedBy;

    private CreateSubscriptionGrantResponse(BuilderImpl builder) {
        super(builder);
        this.assets = builder.assets;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.domainId = builder.domainId;
        this.environmentId = builder.environmentId;
        this.grantedEntity = builder.grantedEntity;
        this.id = builder.id;
        this.status = builder.status;
        this.subscriptionId = builder.subscriptionId;
        this.subscriptionTargetId = builder.subscriptionTargetId;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Assets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAssets() {
        return assets != null && !(assets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The assets for which the subscription grant is created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssets} method.
     * </p>
     * 
     * @return The assets for which the subscription grant is created.
     */
    public final List<SubscribedAsset> assets() {
        return assets;
    }

    /**
     * <p>
     * A timestamp of when the subscription grant is created.
     * </p>
     * 
     * @return A timestamp of when the subscription grant is created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Amazon DataZone user who created the subscription grant.
     * </p>
     * 
     * @return The Amazon DataZone user who created the subscription grant.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain in which the subscription grant is created.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain in which the subscription grant is created.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The environment ID for which subscription grant is created.
     * </p>
     * 
     * @return The environment ID for which subscription grant is created.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The entity to which the subscription is granted.
     * </p>
     * 
     * @return The entity to which the subscription is granted.
     */
    public final GrantedEntity grantedEntity() {
        return grantedEntity;
    }

    /**
     * <p>
     * The ID of the subscription grant.
     * </p>
     * 
     * @return The ID of the subscription grant.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The status of the subscription grant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SubscriptionGrantOverallStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the subscription grant.
     * @see SubscriptionGrantOverallStatus
     */
    public final SubscriptionGrantOverallStatus status() {
        return SubscriptionGrantOverallStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the subscription grant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SubscriptionGrantOverallStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the subscription grant.
     * @see SubscriptionGrantOverallStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The identifier of the subscription grant.
     * </p>
     * 
     * @return The identifier of the subscription grant.
     * @deprecated Multiple subscriptions can exist for a single grant
     */
    @Deprecated
    public final String subscriptionId() {
        return subscriptionId;
    }

    /**
     * <p>
     * The ID of the subscription target for which the subscription grant is created.
     * </p>
     * 
     * @return The ID of the subscription target for which the subscription grant is created.
     */
    public final String subscriptionTargetId() {
        return subscriptionTargetId;
    }

    /**
     * <p>
     * A timestamp of when the subscription grant was updated.
     * </p>
     * 
     * @return A timestamp of when the subscription grant was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The Amazon DataZone user who updated the subscription grant.
     * </p>
     * 
     * @return The Amazon DataZone user who updated the subscription grant.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssets() ? assets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(grantedEntity());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionId());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriptionGrantResponse)) {
            return false;
        }
        CreateSubscriptionGrantResponse other = (CreateSubscriptionGrantResponse) obj;
        return hasAssets() == other.hasAssets() && Objects.equals(assets(), other.assets())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(domainId(), other.domainId()) && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(grantedEntity(), other.grantedEntity()) && Objects.equals(id(), other.id())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(subscriptionId(), other.subscriptionId())
                && Objects.equals(subscriptionTargetId(), other.subscriptionTargetId())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(updatedBy(), other.updatedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSubscriptionGrantResponse").add("Assets", hasAssets() ? assets() : null)
                .add("CreatedAt", createdAt()).add("CreatedBy", createdBy()).add("DomainId", domainId())
                .add("EnvironmentId", environmentId()).add("GrantedEntity", grantedEntity()).add("Id", id())
                .add("Status", statusAsString()).add("SubscriptionId", subscriptionId())
                .add("SubscriptionTargetId", subscriptionTargetId()).add("UpdatedAt", updatedAt()).add("UpdatedBy", updatedBy())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assets":
            return Optional.ofNullable(clazz.cast(assets()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "grantedEntity":
            return Optional.ofNullable(clazz.cast(grantedEntity()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "subscriptionId":
            return Optional.ofNullable(clazz.cast(subscriptionId()));
        case "subscriptionTargetId":
            return Optional.ofNullable(clazz.cast(subscriptionTargetId()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assets", ASSETS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("grantedEntity", GRANTED_ENTITY_FIELD);
        map.put("id", ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("subscriptionId", SUBSCRIPTION_ID_FIELD);
        map.put("subscriptionTargetId", SUBSCRIPTION_TARGET_ID_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("updatedBy", UPDATED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSubscriptionGrantResponse, T> g) {
        return obj -> g.apply((CreateSubscriptionGrantResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateSubscriptionGrantResponse> {
        /**
         * <p>
         * The assets for which the subscription grant is created.
         * </p>
         * 
         * @param assets
         *        The assets for which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assets(Collection<SubscribedAsset> assets);

        /**
         * <p>
         * The assets for which the subscription grant is created.
         * </p>
         * 
         * @param assets
         *        The assets for which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assets(SubscribedAsset... assets);

        /**
         * <p>
         * The assets for which the subscription grant is created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.SubscribedAsset.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.datazone.model.SubscribedAsset#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.SubscribedAsset.Builder#build()} is called immediately
         * and its result is passed to {@link #assets(List<SubscribedAsset>)}.
         * 
         * @param assets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.SubscribedAsset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assets(java.util.Collection<SubscribedAsset>)
         */
        Builder assets(Consumer<SubscribedAsset.Builder>... assets);

        /**
         * <p>
         * A timestamp of when the subscription grant is created.
         * </p>
         * 
         * @param createdAt
         *        A timestamp of when the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Amazon DataZone user who created the subscription grant.
         * </p>
         * 
         * @param createdBy
         *        The Amazon DataZone user who created the subscription grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The ID of the Amazon DataZone domain in which the subscription grant is created.
         * </p>
         * 
         * @param domainId
         *        The ID of the Amazon DataZone domain in which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The environment ID for which subscription grant is created.
         * </p>
         * 
         * @param environmentId
         *        The environment ID for which subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The entity to which the subscription is granted.
         * </p>
         * 
         * @param grantedEntity
         *        The entity to which the subscription is granted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantedEntity(GrantedEntity grantedEntity);

        /**
         * <p>
         * The entity to which the subscription is granted.
         * </p>
         * This is a convenience method that creates an instance of the {@link GrantedEntity.Builder} avoiding the need
         * to create one manually via {@link GrantedEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GrantedEntity.Builder#build()} is called immediately and its
         * result is passed to {@link #grantedEntity(GrantedEntity)}.
         * 
         * @param grantedEntity
         *        a consumer that will call methods on {@link GrantedEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grantedEntity(GrantedEntity)
         */
        default Builder grantedEntity(Consumer<GrantedEntity.Builder> grantedEntity) {
            return grantedEntity(GrantedEntity.builder().applyMutation(grantedEntity).build());
        }

        /**
         * <p>
         * The ID of the subscription grant.
         * </p>
         * 
         * @param id
         *        The ID of the subscription grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The status of the subscription grant.
         * </p>
         * 
         * @param status
         *        The status of the subscription grant.
         * @see SubscriptionGrantOverallStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionGrantOverallStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the subscription grant.
         * </p>
         * 
         * @param status
         *        The status of the subscription grant.
         * @see SubscriptionGrantOverallStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionGrantOverallStatus
         */
        Builder status(SubscriptionGrantOverallStatus status);

        /**
         * <p>
         * The identifier of the subscription grant.
         * </p>
         * 
         * @param subscriptionId
         *        The identifier of the subscription grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Multiple subscriptions can exist for a single grant
         */
        @Deprecated
        Builder subscriptionId(String subscriptionId);

        /**
         * <p>
         * The ID of the subscription target for which the subscription grant is created.
         * </p>
         * 
         * @param subscriptionTargetId
         *        The ID of the subscription target for which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionTargetId(String subscriptionTargetId);

        /**
         * <p>
         * A timestamp of when the subscription grant was updated.
         * </p>
         * 
         * @param updatedAt
         *        A timestamp of when the subscription grant was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The Amazon DataZone user who updated the subscription grant.
         * </p>
         * 
         * @param updatedBy
         *        The Amazon DataZone user who updated the subscription grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private List<SubscribedAsset> assets = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private String createdBy;

        private String domainId;

        private String environmentId;

        private GrantedEntity grantedEntity;

        private String id;

        private String status;

        private String subscriptionId;

        private String subscriptionTargetId;

        private Instant updatedAt;

        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubscriptionGrantResponse model) {
            super(model);
            assets(model.assets);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            domainId(model.domainId);
            environmentId(model.environmentId);
            grantedEntity(model.grantedEntity);
            id(model.id);
            status(model.status);
            subscriptionId(model.subscriptionId);
            subscriptionTargetId(model.subscriptionTargetId);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
        }

        public final List<SubscribedAsset.Builder> getAssets() {
            List<SubscribedAsset.Builder> result = SubscribedAssetsCopier.copyToBuilder(this.assets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssets(Collection<SubscribedAsset.BuilderImpl> assets) {
            this.assets = SubscribedAssetsCopier.copyFromBuilder(assets);
        }

        @Override
        public final Builder assets(Collection<SubscribedAsset> assets) {
            this.assets = SubscribedAssetsCopier.copy(assets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assets(SubscribedAsset... assets) {
            assets(Arrays.asList(assets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assets(Consumer<SubscribedAsset.Builder>... assets) {
            assets(Stream.of(assets).map(c -> SubscribedAsset.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final GrantedEntity.Builder getGrantedEntity() {
            return grantedEntity != null ? grantedEntity.toBuilder() : null;
        }

        public final void setGrantedEntity(GrantedEntity.BuilderImpl grantedEntity) {
            this.grantedEntity = grantedEntity != null ? grantedEntity.build() : null;
        }

        @Override
        public final Builder grantedEntity(GrantedEntity grantedEntity) {
            this.grantedEntity = grantedEntity;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SubscriptionGrantOverallStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Deprecated
        public final String getSubscriptionId() {
            return subscriptionId;
        }

        @Deprecated
        public final void setSubscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        @Override
        @Deprecated
        public final Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public final String getSubscriptionTargetId() {
            return subscriptionTargetId;
        }

        public final void setSubscriptionTargetId(String subscriptionTargetId) {
            this.subscriptionTargetId = subscriptionTargetId;
        }

        @Override
        public final Builder subscriptionTargetId(String subscriptionTargetId) {
            this.subscriptionTargetId = subscriptionTargetId;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public CreateSubscriptionGrantResponse build() {
            return new CreateSubscriptionGrantResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
