/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProjectProfileRequest extends DataZoneRequest implements
        ToCopyableBuilder<CreateProjectProfileRequest.Builder, CreateProjectProfileRequest> {
    private static final SdkField<Boolean> ALLOW_CUSTOM_PROJECT_RESOURCE_TAGS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowCustomProjectResourceTags")
            .getter(getter(CreateProjectProfileRequest::allowCustomProjectResourceTags))
            .setter(setter(Builder::allowCustomProjectResourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowCustomProjectResourceTags")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateProjectProfileRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(CreateProjectProfileRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> DOMAIN_UNIT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainUnitIdentifier").getter(getter(CreateProjectProfileRequest::domainUnitIdentifier))
            .setter(setter(Builder::domainUnitIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainUnitIdentifier").build())
            .build();

    private static final SdkField<List<EnvironmentConfiguration>> ENVIRONMENT_CONFIGURATIONS_FIELD = SdkField
            .<List<EnvironmentConfiguration>> builder(MarshallingType.LIST)
            .memberName("environmentConfigurations")
            .getter(getter(CreateProjectProfileRequest::environmentConfigurations))
            .setter(setter(Builder::environmentConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateProjectProfileRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<ResourceTagParameter>> PROJECT_RESOURCE_TAGS_FIELD = SdkField
            .<List<ResourceTagParameter>> builder(MarshallingType.LIST)
            .memberName("projectResourceTags")
            .getter(getter(CreateProjectProfileRequest::projectResourceTags))
            .setter(setter(Builder::projectResourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectResourceTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceTagParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceTagParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROJECT_RESOURCE_TAGS_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("projectResourceTagsDescription")
            .getter(getter(CreateProjectProfileRequest::projectResourceTagsDescription))
            .setter(setter(Builder::projectResourceTagsDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectResourceTagsDescription")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateProjectProfileRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ALLOW_CUSTOM_PROJECT_RESOURCE_TAGS_FIELD, DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, DOMAIN_UNIT_IDENTIFIER_FIELD,
            ENVIRONMENT_CONFIGURATIONS_FIELD, NAME_FIELD, PROJECT_RESOURCE_TAGS_FIELD, PROJECT_RESOURCE_TAGS_DESCRIPTION_FIELD,
            STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean allowCustomProjectResourceTags;

    private final String description;

    private final String domainIdentifier;

    private final String domainUnitIdentifier;

    private final List<EnvironmentConfiguration> environmentConfigurations;

    private final String name;

    private final List<ResourceTagParameter> projectResourceTags;

    private final String projectResourceTagsDescription;

    private final String status;

    private CreateProjectProfileRequest(BuilderImpl builder) {
        super(builder);
        this.allowCustomProjectResourceTags = builder.allowCustomProjectResourceTags;
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.domainUnitIdentifier = builder.domainUnitIdentifier;
        this.environmentConfigurations = builder.environmentConfigurations;
        this.name = builder.name;
        this.projectResourceTags = builder.projectResourceTags;
        this.projectResourceTagsDescription = builder.projectResourceTagsDescription;
        this.status = builder.status;
    }

    /**
     * <p>
     * Specifies whether custom project resource tags are supported.
     * </p>
     * 
     * @return Specifies whether custom project resource tags are supported.
     */
    public final Boolean allowCustomProjectResourceTags() {
        return allowCustomProjectResourceTags;
    }

    /**
     * <p>
     * A description of a project profile.
     * </p>
     * 
     * @return A description of a project profile.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A domain ID of the project profile.
     * </p>
     * 
     * @return A domain ID of the project profile.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * A domain unit ID of the project profile.
     * </p>
     * 
     * @return A domain unit ID of the project profile.
     */
    public final String domainUnitIdentifier() {
        return domainUnitIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnvironmentConfigurations() {
        return environmentConfigurations != null && !(environmentConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Environment configurations of the project profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentConfigurations} method.
     * </p>
     * 
     * @return Environment configurations of the project profile.
     */
    public final List<EnvironmentConfiguration> environmentConfigurations() {
        return environmentConfigurations;
    }

    /**
     * <p>
     * Project profile name.
     * </p>
     * 
     * @return Project profile name.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProjectResourceTags property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProjectResourceTags() {
        return projectResourceTags != null && !(projectResourceTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource tags of the project profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProjectResourceTags} method.
     * </p>
     * 
     * @return The resource tags of the project profile.
     */
    public final List<ResourceTagParameter> projectResourceTags() {
        return projectResourceTags;
    }

    /**
     * <p>
     * Field viewable through the UI that provides a project user with the allowed resource tag specifications.
     * </p>
     * 
     * @return Field viewable through the UI that provides a project user with the allowed resource tag specifications.
     */
    public final String projectResourceTagsDescription() {
        return projectResourceTagsDescription;
    }

    /**
     * <p>
     * Project profile status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Project profile status.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * Project profile status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Project profile status.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(allowCustomProjectResourceTags());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(domainUnitIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentConfigurations() ? environmentConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasProjectResourceTags() ? projectResourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(projectResourceTagsDescription());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectProfileRequest)) {
            return false;
        }
        CreateProjectProfileRequest other = (CreateProjectProfileRequest) obj;
        return Objects.equals(allowCustomProjectResourceTags(), other.allowCustomProjectResourceTags())
                && Objects.equals(description(), other.description())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(domainUnitIdentifier(), other.domainUnitIdentifier())
                && hasEnvironmentConfigurations() == other.hasEnvironmentConfigurations()
                && Objects.equals(environmentConfigurations(), other.environmentConfigurations())
                && Objects.equals(name(), other.name()) && hasProjectResourceTags() == other.hasProjectResourceTags()
                && Objects.equals(projectResourceTags(), other.projectResourceTags())
                && Objects.equals(projectResourceTagsDescription(), other.projectResourceTagsDescription())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateProjectProfileRequest")
                .add("AllowCustomProjectResourceTags", allowCustomProjectResourceTags())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DomainIdentifier", domainIdentifier())
                .add("DomainUnitIdentifier", domainUnitIdentifier())
                .add("EnvironmentConfigurations", hasEnvironmentConfigurations() ? environmentConfigurations() : null)
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ProjectResourceTags", hasProjectResourceTags() ? projectResourceTags() : null)
                .add("ProjectResourceTagsDescription",
                        projectResourceTagsDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowCustomProjectResourceTags":
            return Optional.ofNullable(clazz.cast(allowCustomProjectResourceTags()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "domainUnitIdentifier":
            return Optional.ofNullable(clazz.cast(domainUnitIdentifier()));
        case "environmentConfigurations":
            return Optional.ofNullable(clazz.cast(environmentConfigurations()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "projectResourceTags":
            return Optional.ofNullable(clazz.cast(projectResourceTags()));
        case "projectResourceTagsDescription":
            return Optional.ofNullable(clazz.cast(projectResourceTagsDescription()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("allowCustomProjectResourceTags", ALLOW_CUSTOM_PROJECT_RESOURCE_TAGS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("domainUnitIdentifier", DOMAIN_UNIT_IDENTIFIER_FIELD);
        map.put("environmentConfigurations", ENVIRONMENT_CONFIGURATIONS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("projectResourceTags", PROJECT_RESOURCE_TAGS_FIELD);
        map.put("projectResourceTagsDescription", PROJECT_RESOURCE_TAGS_DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProjectProfileRequest, T> g) {
        return obj -> g.apply((CreateProjectProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateProjectProfileRequest> {
        /**
         * <p>
         * Specifies whether custom project resource tags are supported.
         * </p>
         * 
         * @param allowCustomProjectResourceTags
         *        Specifies whether custom project resource tags are supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowCustomProjectResourceTags(Boolean allowCustomProjectResourceTags);

        /**
         * <p>
         * A description of a project profile.
         * </p>
         * 
         * @param description
         *        A description of a project profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A domain ID of the project profile.
         * </p>
         * 
         * @param domainIdentifier
         *        A domain ID of the project profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * A domain unit ID of the project profile.
         * </p>
         * 
         * @param domainUnitIdentifier
         *        A domain unit ID of the project profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainUnitIdentifier(String domainUnitIdentifier);

        /**
         * <p>
         * Environment configurations of the project profile.
         * </p>
         * 
         * @param environmentConfigurations
         *        Environment configurations of the project profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentConfigurations(Collection<EnvironmentConfiguration> environmentConfigurations);

        /**
         * <p>
         * Environment configurations of the project profile.
         * </p>
         * 
         * @param environmentConfigurations
         *        Environment configurations of the project profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentConfigurations(EnvironmentConfiguration... environmentConfigurations);

        /**
         * <p>
         * Environment configurations of the project profile.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.EnvironmentConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.datazone.model.EnvironmentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.EnvironmentConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #environmentConfigurations(List<EnvironmentConfiguration>)}.
         * 
         * @param environmentConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.EnvironmentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentConfigurations(java.util.Collection<EnvironmentConfiguration>)
         */
        Builder environmentConfigurations(Consumer<EnvironmentConfiguration.Builder>... environmentConfigurations);

        /**
         * <p>
         * Project profile name.
         * </p>
         * 
         * @param name
         *        Project profile name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The resource tags of the project profile.
         * </p>
         * 
         * @param projectResourceTags
         *        The resource tags of the project profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectResourceTags(Collection<ResourceTagParameter> projectResourceTags);

        /**
         * <p>
         * The resource tags of the project profile.
         * </p>
         * 
         * @param projectResourceTags
         *        The resource tags of the project profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectResourceTags(ResourceTagParameter... projectResourceTags);

        /**
         * <p>
         * The resource tags of the project profile.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.ResourceTagParameter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.datazone.model.ResourceTagParameter#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.ResourceTagParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #projectResourceTags(List<ResourceTagParameter>)}.
         * 
         * @param projectResourceTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.ResourceTagParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projectResourceTags(java.util.Collection<ResourceTagParameter>)
         */
        Builder projectResourceTags(Consumer<ResourceTagParameter.Builder>... projectResourceTags);

        /**
         * <p>
         * Field viewable through the UI that provides a project user with the allowed resource tag specifications.
         * </p>
         * 
         * @param projectResourceTagsDescription
         *        Field viewable through the UI that provides a project user with the allowed resource tag
         *        specifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectResourceTagsDescription(String projectResourceTagsDescription);

        /**
         * <p>
         * Project profile status.
         * </p>
         * 
         * @param status
         *        Project profile status.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * Project profile status.
         * </p>
         * 
         * @param status
         *        Project profile status.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private Boolean allowCustomProjectResourceTags;

        private String description;

        private String domainIdentifier;

        private String domainUnitIdentifier;

        private List<EnvironmentConfiguration> environmentConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private List<ResourceTagParameter> projectResourceTags = DefaultSdkAutoConstructList.getInstance();

        private String projectResourceTagsDescription;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProjectProfileRequest model) {
            super(model);
            allowCustomProjectResourceTags(model.allowCustomProjectResourceTags);
            description(model.description);
            domainIdentifier(model.domainIdentifier);
            domainUnitIdentifier(model.domainUnitIdentifier);
            environmentConfigurations(model.environmentConfigurations);
            name(model.name);
            projectResourceTags(model.projectResourceTags);
            projectResourceTagsDescription(model.projectResourceTagsDescription);
            status(model.status);
        }

        public final Boolean getAllowCustomProjectResourceTags() {
            return allowCustomProjectResourceTags;
        }

        public final void setAllowCustomProjectResourceTags(Boolean allowCustomProjectResourceTags) {
            this.allowCustomProjectResourceTags = allowCustomProjectResourceTags;
        }

        @Override
        public final Builder allowCustomProjectResourceTags(Boolean allowCustomProjectResourceTags) {
            this.allowCustomProjectResourceTags = allowCustomProjectResourceTags;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getDomainUnitIdentifier() {
            return domainUnitIdentifier;
        }

        public final void setDomainUnitIdentifier(String domainUnitIdentifier) {
            this.domainUnitIdentifier = domainUnitIdentifier;
        }

        @Override
        public final Builder domainUnitIdentifier(String domainUnitIdentifier) {
            this.domainUnitIdentifier = domainUnitIdentifier;
            return this;
        }

        public final List<EnvironmentConfiguration.Builder> getEnvironmentConfigurations() {
            List<EnvironmentConfiguration.Builder> result = EnvironmentConfigurationsListCopier
                    .copyToBuilder(this.environmentConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentConfigurations(Collection<EnvironmentConfiguration.BuilderImpl> environmentConfigurations) {
            this.environmentConfigurations = EnvironmentConfigurationsListCopier.copyFromBuilder(environmentConfigurations);
        }

        @Override
        public final Builder environmentConfigurations(Collection<EnvironmentConfiguration> environmentConfigurations) {
            this.environmentConfigurations = EnvironmentConfigurationsListCopier.copy(environmentConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentConfigurations(EnvironmentConfiguration... environmentConfigurations) {
            environmentConfigurations(Arrays.asList(environmentConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentConfigurations(Consumer<EnvironmentConfiguration.Builder>... environmentConfigurations) {
            environmentConfigurations(Stream.of(environmentConfigurations)
                    .map(c -> EnvironmentConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<ResourceTagParameter.Builder> getProjectResourceTags() {
            List<ResourceTagParameter.Builder> result = ProjectResourceTagParametersCopier
                    .copyToBuilder(this.projectResourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProjectResourceTags(Collection<ResourceTagParameter.BuilderImpl> projectResourceTags) {
            this.projectResourceTags = ProjectResourceTagParametersCopier.copyFromBuilder(projectResourceTags);
        }

        @Override
        public final Builder projectResourceTags(Collection<ResourceTagParameter> projectResourceTags) {
            this.projectResourceTags = ProjectResourceTagParametersCopier.copy(projectResourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectResourceTags(ResourceTagParameter... projectResourceTags) {
            projectResourceTags(Arrays.asList(projectResourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectResourceTags(Consumer<ResourceTagParameter.Builder>... projectResourceTags) {
            projectResourceTags(Stream.of(projectResourceTags).map(c -> ResourceTagParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getProjectResourceTagsDescription() {
            return projectResourceTagsDescription;
        }

        public final void setProjectResourceTagsDescription(String projectResourceTagsDescription) {
            this.projectResourceTagsDescription = projectResourceTagsDescription;
        }

        @Override
        public final Builder projectResourceTagsDescription(String projectResourceTagsDescription) {
            this.projectResourceTagsDescription = projectResourceTagsDescription;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProjectProfileRequest build() {
            return new CreateProjectProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
