/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGlossaryRequest extends DataZoneRequest implements
        ToCopyableBuilder<CreateGlossaryRequest.Builder, CreateGlossaryRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateGlossaryRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateGlossaryRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(CreateGlossaryRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateGlossaryRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OWNING_PROJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("owningProjectIdentifier").getter(getter(CreateGlossaryRequest::owningProjectIdentifier))
            .setter(setter(Builder::owningProjectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectIdentifier").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateGlossaryRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<String>> USAGE_RESTRICTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("usageRestrictions")
            .getter(getter(CreateGlossaryRequest::usageRestrictionsAsStrings))
            .setter(setter(Builder::usageRestrictionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageRestrictions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, NAME_FIELD, OWNING_PROJECT_IDENTIFIER_FIELD, STATUS_FIELD,
            USAGE_RESTRICTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String description;

    private final String domainIdentifier;

    private final String name;

    private final String owningProjectIdentifier;

    private final String status;

    private final List<String> usageRestrictions;

    private CreateGlossaryRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.name = builder.name;
        this.owningProjectIdentifier = builder.owningProjectIdentifier;
        this.status = builder.status;
        this.usageRestrictions = builder.usageRestrictions;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The description of this business glossary.
     * </p>
     * 
     * @return The description of this business glossary.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain in which this business glossary is created.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain in which this business glossary is created.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The name of this business glossary.
     * </p>
     * 
     * @return The name of this business glossary.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the project that currently owns business glossary.
     * </p>
     * 
     * @return The ID of the project that currently owns business glossary.
     */
    public final String owningProjectIdentifier() {
        return owningProjectIdentifier;
    }

    /**
     * <p>
     * The status of this business glossary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GlossaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of this business glossary.
     * @see GlossaryStatus
     */
    public final GlossaryStatus status() {
        return GlossaryStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of this business glossary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GlossaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of this business glossary.
     * @see GlossaryStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The usage restriction of the restricted glossary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsageRestrictions} method.
     * </p>
     * 
     * @return The usage restriction of the restricted glossary.
     */
    public final List<GlossaryUsageRestriction> usageRestrictions() {
        return GlossaryUsageRestrictionsCopier.copyStringToEnum(usageRestrictions);
    }

    /**
     * For responses, this returns true if the service returned a value for the UsageRestrictions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUsageRestrictions() {
        return usageRestrictions != null && !(usageRestrictions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The usage restriction of the restricted glossary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsageRestrictions} method.
     * </p>
     * 
     * @return The usage restriction of the restricted glossary.
     */
    public final List<String> usageRestrictionsAsStrings() {
        return usageRestrictions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(owningProjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasUsageRestrictions() ? usageRestrictionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGlossaryRequest)) {
            return false;
        }
        CreateGlossaryRequest other = (CreateGlossaryRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && Objects.equals(domainIdentifier(), other.domainIdentifier()) && Objects.equals(name(), other.name())
                && Objects.equals(owningProjectIdentifier(), other.owningProjectIdentifier())
                && Objects.equals(statusAsString(), other.statusAsString())
                && hasUsageRestrictions() == other.hasUsageRestrictions()
                && Objects.equals(usageRestrictionsAsStrings(), other.usageRestrictionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGlossaryRequest").add("ClientToken", clientToken())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DomainIdentifier", domainIdentifier())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OwningProjectIdentifier", owningProjectIdentifier()).add("Status", statusAsString())
                .add("UsageRestrictions", hasUsageRestrictions() ? usageRestrictionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "owningProjectIdentifier":
            return Optional.ofNullable(clazz.cast(owningProjectIdentifier()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "usageRestrictions":
            return Optional.ofNullable(clazz.cast(usageRestrictionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("owningProjectIdentifier", OWNING_PROJECT_IDENTIFIER_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("usageRestrictions", USAGE_RESTRICTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGlossaryRequest, T> g) {
        return obj -> g.apply((CreateGlossaryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGlossaryRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The description of this business glossary.
         * </p>
         * 
         * @param description
         *        The description of this business glossary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the Amazon DataZone domain in which this business glossary is created.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the Amazon DataZone domain in which this business glossary is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The name of this business glossary.
         * </p>
         * 
         * @param name
         *        The name of this business glossary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the project that currently owns business glossary.
         * </p>
         * 
         * @param owningProjectIdentifier
         *        The ID of the project that currently owns business glossary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningProjectIdentifier(String owningProjectIdentifier);

        /**
         * <p>
         * The status of this business glossary.
         * </p>
         * 
         * @param status
         *        The status of this business glossary.
         * @see GlossaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlossaryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of this business glossary.
         * </p>
         * 
         * @param status
         *        The status of this business glossary.
         * @see GlossaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlossaryStatus
         */
        Builder status(GlossaryStatus status);

        /**
         * <p>
         * The usage restriction of the restricted glossary.
         * </p>
         * 
         * @param usageRestrictions
         *        The usage restriction of the restricted glossary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageRestrictionsWithStrings(Collection<String> usageRestrictions);

        /**
         * <p>
         * The usage restriction of the restricted glossary.
         * </p>
         * 
         * @param usageRestrictions
         *        The usage restriction of the restricted glossary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageRestrictionsWithStrings(String... usageRestrictions);

        /**
         * <p>
         * The usage restriction of the restricted glossary.
         * </p>
         * 
         * @param usageRestrictions
         *        The usage restriction of the restricted glossary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageRestrictions(Collection<GlossaryUsageRestriction> usageRestrictions);

        /**
         * <p>
         * The usage restriction of the restricted glossary.
         * </p>
         * 
         * @param usageRestrictions
         *        The usage restriction of the restricted glossary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageRestrictions(GlossaryUsageRestriction... usageRestrictions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String description;

        private String domainIdentifier;

        private String name;

        private String owningProjectIdentifier;

        private String status;

        private List<String> usageRestrictions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGlossaryRequest model) {
            super(model);
            clientToken(model.clientToken);
            description(model.description);
            domainIdentifier(model.domainIdentifier);
            name(model.name);
            owningProjectIdentifier(model.owningProjectIdentifier);
            status(model.status);
            usageRestrictionsWithStrings(model.usageRestrictions);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwningProjectIdentifier() {
            return owningProjectIdentifier;
        }

        public final void setOwningProjectIdentifier(String owningProjectIdentifier) {
            this.owningProjectIdentifier = owningProjectIdentifier;
        }

        @Override
        public final Builder owningProjectIdentifier(String owningProjectIdentifier) {
            this.owningProjectIdentifier = owningProjectIdentifier;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GlossaryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getUsageRestrictions() {
            if (usageRestrictions instanceof SdkAutoConstructList) {
                return null;
            }
            return usageRestrictions;
        }

        public final void setUsageRestrictions(Collection<String> usageRestrictions) {
            this.usageRestrictions = GlossaryUsageRestrictionsCopier.copy(usageRestrictions);
        }

        @Override
        public final Builder usageRestrictionsWithStrings(Collection<String> usageRestrictions) {
            this.usageRestrictions = GlossaryUsageRestrictionsCopier.copy(usageRestrictions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageRestrictionsWithStrings(String... usageRestrictions) {
            usageRestrictionsWithStrings(Arrays.asList(usageRestrictions));
            return this;
        }

        @Override
        public final Builder usageRestrictions(Collection<GlossaryUsageRestriction> usageRestrictions) {
            this.usageRestrictions = GlossaryUsageRestrictionsCopier.copyEnumToString(usageRestrictions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageRestrictions(GlossaryUsageRestriction... usageRestrictions) {
            usageRestrictions(Arrays.asList(usageRestrictions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGlossaryRequest build() {
            return new CreateGlossaryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
