/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEnvironmentBlueprintRequest extends DataZoneRequest implements
        ToCopyableBuilder<CreateEnvironmentBlueprintRequest.Builder, CreateEnvironmentBlueprintRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateEnvironmentBlueprintRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(CreateEnvironmentBlueprintRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateEnvironmentBlueprintRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ProvisioningProperties> PROVISIONING_PROPERTIES_FIELD = SdkField
            .<ProvisioningProperties> builder(MarshallingType.SDK_POJO).memberName("provisioningProperties")
            .getter(getter(CreateEnvironmentBlueprintRequest::provisioningProperties))
            .setter(setter(Builder::provisioningProperties)).constructor(ProvisioningProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningProperties").build())
            .build();

    private static final SdkField<List<CustomParameter>> USER_PARAMETERS_FIELD = SdkField
            .<List<CustomParameter>> builder(MarshallingType.LIST)
            .memberName("userParameters")
            .getter(getter(CreateEnvironmentBlueprintRequest::userParameters))
            .setter(setter(Builder::userParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            DOMAIN_IDENTIFIER_FIELD, NAME_FIELD, PROVISIONING_PROPERTIES_FIELD, USER_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String description;

    private final String domainIdentifier;

    private final String name;

    private final ProvisioningProperties provisioningProperties;

    private final List<CustomParameter> userParameters;

    private CreateEnvironmentBlueprintRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.name = builder.name;
        this.provisioningProperties = builder.provisioningProperties;
        this.userParameters = builder.userParameters;
    }

    /**
     * <p>
     * The description of the Amazon DataZone blueprint.
     * </p>
     * 
     * @return The description of the Amazon DataZone blueprint.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the domain in which this blueprint is created.
     * </p>
     * 
     * @return The identifier of the domain in which this blueprint is created.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The name of this Amazon DataZone blueprint.
     * </p>
     * 
     * @return The name of this Amazon DataZone blueprint.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The provisioning properties of this Amazon DataZone blueprint.
     * </p>
     * 
     * @return The provisioning properties of this Amazon DataZone blueprint.
     */
    public final ProvisioningProperties provisioningProperties() {
        return provisioningProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserParameters() {
        return userParameters != null && !(userParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user parameters of this Amazon DataZone blueprint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserParameters} method.
     * </p>
     * 
     * @return The user parameters of this Amazon DataZone blueprint.
     */
    public final List<CustomParameter> userParameters() {
        return userParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserParameters() ? userParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentBlueprintRequest)) {
            return false;
        }
        CreateEnvironmentBlueprintRequest other = (CreateEnvironmentBlueprintRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(name(), other.name())
                && Objects.equals(provisioningProperties(), other.provisioningProperties())
                && hasUserParameters() == other.hasUserParameters() && Objects.equals(userParameters(), other.userParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEnvironmentBlueprintRequest")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DomainIdentifier", domainIdentifier()).add("Name", name())
                .add("ProvisioningProperties", provisioningProperties())
                .add("UserParameters", hasUserParameters() ? userParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "provisioningProperties":
            return Optional.ofNullable(clazz.cast(provisioningProperties()));
        case "userParameters":
            return Optional.ofNullable(clazz.cast(userParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("provisioningProperties", PROVISIONING_PROPERTIES_FIELD);
        map.put("userParameters", USER_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentBlueprintRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentBlueprintRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateEnvironmentBlueprintRequest> {
        /**
         * <p>
         * The description of the Amazon DataZone blueprint.
         * </p>
         * 
         * @param description
         *        The description of the Amazon DataZone blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the domain in which this blueprint is created.
         * </p>
         * 
         * @param domainIdentifier
         *        The identifier of the domain in which this blueprint is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The name of this Amazon DataZone blueprint.
         * </p>
         * 
         * @param name
         *        The name of this Amazon DataZone blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The provisioning properties of this Amazon DataZone blueprint.
         * </p>
         * 
         * @param provisioningProperties
         *        The provisioning properties of this Amazon DataZone blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningProperties(ProvisioningProperties provisioningProperties);

        /**
         * <p>
         * The provisioning properties of this Amazon DataZone blueprint.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProvisioningProperties.Builder} avoiding
         * the need to create one manually via {@link ProvisioningProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProvisioningProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #provisioningProperties(ProvisioningProperties)}.
         * 
         * @param provisioningProperties
         *        a consumer that will call methods on {@link ProvisioningProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningProperties(ProvisioningProperties)
         */
        default Builder provisioningProperties(Consumer<ProvisioningProperties.Builder> provisioningProperties) {
            return provisioningProperties(ProvisioningProperties.builder().applyMutation(provisioningProperties).build());
        }

        /**
         * <p>
         * The user parameters of this Amazon DataZone blueprint.
         * </p>
         * 
         * @param userParameters
         *        The user parameters of this Amazon DataZone blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userParameters(Collection<CustomParameter> userParameters);

        /**
         * <p>
         * The user parameters of this Amazon DataZone blueprint.
         * </p>
         * 
         * @param userParameters
         *        The user parameters of this Amazon DataZone blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userParameters(CustomParameter... userParameters);

        /**
         * <p>
         * The user parameters of this Amazon DataZone blueprint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.CustomParameter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.datazone.model.CustomParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.CustomParameter.Builder#build()} is called immediately
         * and its result is passed to {@link #userParameters(List<CustomParameter>)}.
         * 
         * @param userParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.CustomParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userParameters(java.util.Collection<CustomParameter>)
         */
        Builder userParameters(Consumer<CustomParameter.Builder>... userParameters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String description;

        private String domainIdentifier;

        private String name;

        private ProvisioningProperties provisioningProperties;

        private List<CustomParameter> userParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentBlueprintRequest model) {
            super(model);
            description(model.description);
            domainIdentifier(model.domainIdentifier);
            name(model.name);
            provisioningProperties(model.provisioningProperties);
            userParameters(model.userParameters);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ProvisioningProperties.Builder getProvisioningProperties() {
            return provisioningProperties != null ? provisioningProperties.toBuilder() : null;
        }

        public final void setProvisioningProperties(ProvisioningProperties.BuilderImpl provisioningProperties) {
            this.provisioningProperties = provisioningProperties != null ? provisioningProperties.build() : null;
        }

        @Override
        public final Builder provisioningProperties(ProvisioningProperties provisioningProperties) {
            this.provisioningProperties = provisioningProperties;
            return this;
        }

        public final List<CustomParameter.Builder> getUserParameters() {
            List<CustomParameter.Builder> result = CustomParameterListCopier.copyToBuilder(this.userParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserParameters(Collection<CustomParameter.BuilderImpl> userParameters) {
            this.userParameters = CustomParameterListCopier.copyFromBuilder(userParameters);
        }

        @Override
        public final Builder userParameters(Collection<CustomParameter> userParameters) {
            this.userParameters = CustomParameterListCopier.copy(userParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(CustomParameter... userParameters) {
            userParameters(Arrays.asList(userParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(Consumer<CustomParameter.Builder>... userParameters) {
            userParameters(Stream.of(userParameters).map(c -> CustomParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentBlueprintRequest build() {
            return new CreateEnvironmentBlueprintRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
