/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The source of accounts for the account pool. In the current release, it's either a static list of accounts provided
 * by the customer or a custom Amazon Web Services Lambda handler.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountSource implements SdkPojo, Serializable, ToCopyableBuilder<AccountSource.Builder, AccountSource> {
    private static final SdkField<List<AccountInfo>> ACCOUNTS_FIELD = SdkField
            .<List<AccountInfo>> builder(MarshallingType.LIST)
            .memberName("accounts")
            .getter(getter(AccountSource::accounts))
            .setter(setter(Builder::accounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccountInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CustomAccountPoolHandler> CUSTOM_ACCOUNT_POOL_HANDLER_FIELD = SdkField
            .<CustomAccountPoolHandler> builder(MarshallingType.SDK_POJO).memberName("customAccountPoolHandler")
            .getter(getter(AccountSource::customAccountPoolHandler)).setter(setter(Builder::customAccountPoolHandler))
            .constructor(CustomAccountPoolHandler::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customAccountPoolHandler").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNTS_FIELD,
            CUSTOM_ACCOUNT_POOL_HANDLER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AccountInfo> accounts;

    private final CustomAccountPoolHandler customAccountPoolHandler;

    private final Type type;

    private AccountSource(BuilderImpl builder) {
        this.accounts = builder.accounts;
        this.customAccountPoolHandler = builder.customAccountPoolHandler;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Accounts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccounts() {
        return accounts != null && !(accounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The static list of accounts within an account pool.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccounts} method.
     * </p>
     * 
     * @return The static list of accounts within an account pool.
     */
    public final List<AccountInfo> accounts() {
        return accounts;
    }

    /**
     * <p>
     * The custom Amazon Web Services Lambda handler within an account pool.
     * </p>
     * 
     * @return The custom Amazon Web Services Lambda handler within an account pool.
     */
    public final CustomAccountPoolHandler customAccountPoolHandler() {
        return customAccountPoolHandler;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAccounts() ? accounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(customAccountPoolHandler());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSource)) {
            return false;
        }
        AccountSource other = (AccountSource) obj;
        return hasAccounts() == other.hasAccounts() && Objects.equals(accounts(), other.accounts())
                && Objects.equals(customAccountPoolHandler(), other.customAccountPoolHandler());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountSource").add("Accounts", hasAccounts() ? accounts() : null)
                .add("CustomAccountPoolHandler", customAccountPoolHandler()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accounts":
            return Optional.ofNullable(clazz.cast(accounts()));
        case "customAccountPoolHandler":
            return Optional.ofNullable(clazz.cast(customAccountPoolHandler()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #accounts()} initialized to the given value.
     *
     * <p>
     * The static list of accounts within an account pool.
     * </p>
     * 
     * @param accounts
     *        The static list of accounts within an account pool.
     */
    public static AccountSource fromAccounts(List<AccountInfo> accounts) {
        return builder().accounts(accounts).build();
    }

    /**
     * Create an instance of this class with {@link #customAccountPoolHandler()} initialized to the given value.
     *
     * <p>
     * The custom Amazon Web Services Lambda handler within an account pool.
     * </p>
     * 
     * @param customAccountPoolHandler
     *        The custom Amazon Web Services Lambda handler within an account pool.
     */
    public static AccountSource fromCustomAccountPoolHandler(CustomAccountPoolHandler customAccountPoolHandler) {
        return builder().customAccountPoolHandler(customAccountPoolHandler).build();
    }

    /**
     * Create an instance of this class with {@link #customAccountPoolHandler()} initialized to the given value.
     *
     * <p>
     * The custom Amazon Web Services Lambda handler within an account pool.
     * </p>
     * 
     * @param customAccountPoolHandler
     *        The custom Amazon Web Services Lambda handler within an account pool.
     */
    public static AccountSource fromCustomAccountPoolHandler(Consumer<CustomAccountPoolHandler.Builder> customAccountPoolHandler) {
        CustomAccountPoolHandler.Builder builder = CustomAccountPoolHandler.builder();
        customAccountPoolHandler.accept(builder);
        return fromCustomAccountPoolHandler(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accounts", ACCOUNTS_FIELD);
        map.put("customAccountPoolHandler", CUSTOM_ACCOUNT_POOL_HANDLER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountSource, T> g) {
        return obj -> g.apply((AccountSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountSource> {
        /**
         * <p>
         * The static list of accounts within an account pool.
         * </p>
         * 
         * @param accounts
         *        The static list of accounts within an account pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(Collection<AccountInfo> accounts);

        /**
         * <p>
         * The static list of accounts within an account pool.
         * </p>
         * 
         * @param accounts
         *        The static list of accounts within an account pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(AccountInfo... accounts);

        /**
         * <p>
         * The static list of accounts within an account pool.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.AccountInfo.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.AccountInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.AccountInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #accounts(List<AccountInfo>)}.
         * 
         * @param accounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.AccountInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accounts(java.util.Collection<AccountInfo>)
         */
        Builder accounts(Consumer<AccountInfo.Builder>... accounts);

        /**
         * <p>
         * The custom Amazon Web Services Lambda handler within an account pool.
         * </p>
         * 
         * @param customAccountPoolHandler
         *        The custom Amazon Web Services Lambda handler within an account pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAccountPoolHandler(CustomAccountPoolHandler customAccountPoolHandler);

        /**
         * <p>
         * The custom Amazon Web Services Lambda handler within an account pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomAccountPoolHandler.Builder}
         * avoiding the need to create one manually via {@link CustomAccountPoolHandler#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomAccountPoolHandler.Builder#build()} is called immediately
         * and its result is passed to {@link #customAccountPoolHandler(CustomAccountPoolHandler)}.
         * 
         * @param customAccountPoolHandler
         *        a consumer that will call methods on {@link CustomAccountPoolHandler.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customAccountPoolHandler(CustomAccountPoolHandler)
         */
        default Builder customAccountPoolHandler(Consumer<CustomAccountPoolHandler.Builder> customAccountPoolHandler) {
            return customAccountPoolHandler(CustomAccountPoolHandler.builder().applyMutation(customAccountPoolHandler).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<AccountInfo> accounts = DefaultSdkAutoConstructList.getInstance();

        private CustomAccountPoolHandler customAccountPoolHandler;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AccountSource model) {
            accounts(model.accounts);
            customAccountPoolHandler(model.customAccountPoolHandler);
        }

        public final List<AccountInfo.Builder> getAccounts() {
            List<AccountInfo.Builder> result = AccountInfoListCopier.copyToBuilder(this.accounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccounts(Collection<AccountInfo.BuilderImpl> accounts) {
            Object oldValue = this.accounts;
            this.accounts = AccountInfoListCopier.copyFromBuilder(accounts);
            handleUnionValueChange(Type.ACCOUNTS, oldValue, this.accounts);
        }

        @Override
        public final Builder accounts(Collection<AccountInfo> accounts) {
            Object oldValue = this.accounts;
            this.accounts = AccountInfoListCopier.copy(accounts);
            handleUnionValueChange(Type.ACCOUNTS, oldValue, this.accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(AccountInfo... accounts) {
            accounts(Arrays.asList(accounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(Consumer<AccountInfo.Builder>... accounts) {
            accounts(Stream.of(accounts).map(c -> AccountInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final CustomAccountPoolHandler.Builder getCustomAccountPoolHandler() {
            return customAccountPoolHandler != null ? customAccountPoolHandler.toBuilder() : null;
        }

        public final void setCustomAccountPoolHandler(CustomAccountPoolHandler.BuilderImpl customAccountPoolHandler) {
            Object oldValue = this.customAccountPoolHandler;
            this.customAccountPoolHandler = customAccountPoolHandler != null ? customAccountPoolHandler.build() : null;
            handleUnionValueChange(Type.CUSTOM_ACCOUNT_POOL_HANDLER, oldValue, this.customAccountPoolHandler);
        }

        @Override
        public final Builder customAccountPoolHandler(CustomAccountPoolHandler customAccountPoolHandler) {
            Object oldValue = this.customAccountPoolHandler;
            this.customAccountPoolHandler = customAccountPoolHandler;
            handleUnionValueChange(Type.CUSTOM_ACCOUNT_POOL_HANDLER, oldValue, this.customAccountPoolHandler);
            return this;
        }

        @Override
        public AccountSource build() {
            return new AccountSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AccountSource#type()
     */
    public enum Type {
        ACCOUNTS,

        CUSTOM_ACCOUNT_POOL_HANDLER,

        UNKNOWN_TO_SDK_VERSION
    }
}
