/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the account pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountPoolSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountPoolSummary.Builder, AccountPoolSummary> {
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(AccountPoolSummary::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(AccountPoolSummary::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> DOMAIN_UNIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainUnitId").getter(getter(AccountPoolSummary::domainUnitId)).setter(setter(Builder::domainUnitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainUnitId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AccountPoolSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AccountPoolSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> RESOLUTION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolutionStrategy").getter(getter(AccountPoolSummary::resolutionStrategyAsString))
            .setter(setter(Builder::resolutionStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolutionStrategy").build())
            .build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(AccountPoolSummary::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_BY_FIELD,
            DOMAIN_ID_FIELD, DOMAIN_UNIT_ID_FIELD, ID_FIELD, NAME_FIELD, RESOLUTION_STRATEGY_FIELD, UPDATED_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String createdBy;

    private final String domainId;

    private final String domainUnitId;

    private final String id;

    private final String name;

    private final String resolutionStrategy;

    private final String updatedBy;

    private AccountPoolSummary(BuilderImpl builder) {
        this.createdBy = builder.createdBy;
        this.domainId = builder.domainId;
        this.domainUnitId = builder.domainUnitId;
        this.id = builder.id;
        this.name = builder.name;
        this.resolutionStrategy = builder.resolutionStrategy;
        this.updatedBy = builder.updatedBy;
    }

    /**
     * <p>
     * The user who created the account pool.
     * </p>
     * 
     * @return The user who created the account pool.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The ID of the domain.
     * </p>
     * 
     * @return The ID of the domain.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The ID of the domain unit.
     * </p>
     * 
     * @return The ID of the domain unit.
     */
    public final String domainUnitId() {
        return domainUnitId;
    }

    /**
     * <p>
     * The ID of the account pool.
     * </p>
     * 
     * @return The ID of the account pool.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the account pool.
     * </p>
     * 
     * @return The name of the account pool.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The mechanism used to resolve the account selection from the account pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resolutionStrategy} will return {@link ResolutionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #resolutionStrategyAsString}.
     * </p>
     * 
     * @return The mechanism used to resolve the account selection from the account pool.
     * @see ResolutionStrategy
     */
    public final ResolutionStrategy resolutionStrategy() {
        return ResolutionStrategy.fromValue(resolutionStrategy);
    }

    /**
     * <p>
     * The mechanism used to resolve the account selection from the account pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resolutionStrategy} will return {@link ResolutionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #resolutionStrategyAsString}.
     * </p>
     * 
     * @return The mechanism used to resolve the account selection from the account pool.
     * @see ResolutionStrategy
     */
    public final String resolutionStrategyAsString() {
        return resolutionStrategy;
    }

    /**
     * <p>
     * The user who updated the account pool.
     * </p>
     * 
     * @return The user who updated the account pool.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(domainUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(resolutionStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountPoolSummary)) {
            return false;
        }
        AccountPoolSummary other = (AccountPoolSummary) obj;
        return Objects.equals(createdBy(), other.createdBy()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(domainUnitId(), other.domainUnitId()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name())
                && Objects.equals(resolutionStrategyAsString(), other.resolutionStrategyAsString())
                && Objects.equals(updatedBy(), other.updatedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountPoolSummary").add("CreatedBy", createdBy()).add("DomainId", domainId())
                .add("DomainUnitId", domainUnitId()).add("Id", id())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ResolutionStrategy", resolutionStrategyAsString()).add("UpdatedBy", updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "domainUnitId":
            return Optional.ofNullable(clazz.cast(domainUnitId()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "resolutionStrategy":
            return Optional.ofNullable(clazz.cast(resolutionStrategyAsString()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("domainUnitId", DOMAIN_UNIT_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("resolutionStrategy", RESOLUTION_STRATEGY_FIELD);
        map.put("updatedBy", UPDATED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountPoolSummary, T> g) {
        return obj -> g.apply((AccountPoolSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountPoolSummary> {
        /**
         * <p>
         * The user who created the account pool.
         * </p>
         * 
         * @param createdBy
         *        The user who created the account pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The ID of the domain.
         * </p>
         * 
         * @param domainId
         *        The ID of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The ID of the domain unit.
         * </p>
         * 
         * @param domainUnitId
         *        The ID of the domain unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainUnitId(String domainUnitId);

        /**
         * <p>
         * The ID of the account pool.
         * </p>
         * 
         * @param id
         *        The ID of the account pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the account pool.
         * </p>
         * 
         * @param name
         *        The name of the account pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The mechanism used to resolve the account selection from the account pool.
         * </p>
         * 
         * @param resolutionStrategy
         *        The mechanism used to resolve the account selection from the account pool.
         * @see ResolutionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolutionStrategy
         */
        Builder resolutionStrategy(String resolutionStrategy);

        /**
         * <p>
         * The mechanism used to resolve the account selection from the account pool.
         * </p>
         * 
         * @param resolutionStrategy
         *        The mechanism used to resolve the account selection from the account pool.
         * @see ResolutionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolutionStrategy
         */
        Builder resolutionStrategy(ResolutionStrategy resolutionStrategy);

        /**
         * <p>
         * The user who updated the account pool.
         * </p>
         * 
         * @param updatedBy
         *        The user who updated the account pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);
    }

    static final class BuilderImpl implements Builder {
        private String createdBy;

        private String domainId;

        private String domainUnitId;

        private String id;

        private String name;

        private String resolutionStrategy;

        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountPoolSummary model) {
            createdBy(model.createdBy);
            domainId(model.domainId);
            domainUnitId(model.domainUnitId);
            id(model.id);
            name(model.name);
            resolutionStrategy(model.resolutionStrategy);
            updatedBy(model.updatedBy);
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getDomainUnitId() {
            return domainUnitId;
        }

        public final void setDomainUnitId(String domainUnitId) {
            this.domainUnitId = domainUnitId;
        }

        @Override
        public final Builder domainUnitId(String domainUnitId) {
            this.domainUnitId = domainUnitId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getResolutionStrategy() {
            return resolutionStrategy;
        }

        public final void setResolutionStrategy(String resolutionStrategy) {
            this.resolutionStrategy = resolutionStrategy;
        }

        @Override
        public final Builder resolutionStrategy(String resolutionStrategy) {
            this.resolutionStrategy = resolutionStrategy;
            return this;
        }

        @Override
        public final Builder resolutionStrategy(ResolutionStrategy resolutionStrategy) {
            this.resolutionStrategy(resolutionStrategy == null ? null : resolutionStrategy.toString());
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public AccountPoolSummary build() {
            return new AccountPoolSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
