/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.S3Permission;
import software.amazon.awssdk.services.datazone.model.S3PermissionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Permissions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Permissions> {
    private static final SdkField<List<String>> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("s3").getter(Permissions.getter(Permissions::s3AsStrings)).setter(Permissions.setter(Builder::s3WithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Permissions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> s3;
    private final Type type;

    private Permissions(BuilderImpl builder) {
        this.s3 = builder.s3;
        this.type = builder.type;
    }

    public final List<S3Permission> s3() {
        return S3PermissionsCopier.copyStringToEnum(this.s3);
    }

    public final boolean hasS3() {
        return this.s3 != null && !(this.s3 instanceof SdkAutoConstructList);
    }

    public final List<String> s3AsStrings() {
        return this.s3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasS3() ? this.s3AsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Permissions)) {
            return false;
        }
        Permissions other = (Permissions)obj;
        return this.hasS3() == other.hasS3() && Objects.equals(this.s3AsStrings(), other.s3AsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"Permissions").add("S3", this.hasS3() ? this.s3AsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3": {
                return Optional.ofNullable(clazz.cast(this.s3AsStrings()));
            }
        }
        return Optional.empty();
    }

    public static Permissions fromS3WithStrings(List<String> s3WithStrings) {
        return (Permissions)Permissions.builder().s3WithStrings(s3WithStrings).build();
    }

    public static Permissions fromS3(List<S3Permission> s3WithStrings) {
        return (Permissions)Permissions.builder().s3(s3WithStrings).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("s3", S3_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Permissions, T> g) {
        return obj -> g.apply((Permissions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        S3,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<String> s3 = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Permissions model) {
            this.s3WithStrings(model.s3);
        }

        public final Collection<String> getS3() {
            if (this.s3 instanceof SdkAutoConstructList) {
                return null;
            }
            return this.s3;
        }

        public final void setS3(Collection<String> s3) {
            List<String> oldValue = this.s3;
            this.s3 = S3PermissionsCopier.copy(s3);
            this.handleUnionValueChange(Type.S3, oldValue, this.s3);
        }

        @Override
        public final Builder s3WithStrings(Collection<String> s3) {
            List<String> oldValue = this.s3;
            this.s3 = S3PermissionsCopier.copy(s3);
            this.handleUnionValueChange(Type.S3, oldValue, this.s3);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3WithStrings(String ... s3) {
            this.s3WithStrings(Arrays.asList(s3));
            return this;
        }

        @Override
        public final Builder s3(Collection<S3Permission> s3) {
            List<String> oldValue = this.s3;
            this.s3 = S3PermissionsCopier.copyEnumToString(s3);
            this.handleUnionValueChange(Type.S3, oldValue, this.s3);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3(S3Permission ... s3) {
            this.s3(Arrays.asList(s3));
            return this;
        }

        public Permissions build() {
            return new Permissions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Permissions> {
        public Builder s3WithStrings(Collection<String> var1);

        public Builder s3WithStrings(String ... var1);

        public Builder s3(Collection<S3Permission> var1);

        public Builder s3(S3Permission ... var1);
    }
}

