/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.SortKey;
import software.amazon.awssdk.services.datazone.model.SortOrder;
import software.amazon.awssdk.services.datazone.model.SubscriptionRequestStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSubscriptionRequestsRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, ListSubscriptionRequestsRequest> {
    private static final SdkField<String> APPROVER_PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("approverProjectId").getter(ListSubscriptionRequestsRequest.getter(ListSubscriptionRequestsRequest::approverProjectId)).setter(ListSubscriptionRequestsRequest.setter(Builder::approverProjectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("approverProjectId").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(ListSubscriptionRequestsRequest.getter(ListSubscriptionRequestsRequest::domainIdentifier)).setter(ListSubscriptionRequestsRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListSubscriptionRequestsRequest.getter(ListSubscriptionRequestsRequest::maxResults)).setter(ListSubscriptionRequestsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSubscriptionRequestsRequest.getter(ListSubscriptionRequestsRequest::nextToken)).setter(ListSubscriptionRequestsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> OWNING_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owningGroupId").getter(ListSubscriptionRequestsRequest.getter(ListSubscriptionRequestsRequest::owningGroupId)).setter(ListSubscriptionRequestsRequest.setter(Builder::owningGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("owningGroupId").build()}).build();
    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owningProjectId").getter(ListSubscriptionRequestsRequest.getter(ListSubscriptionRequestsRequest::owningProjectId)).setter(ListSubscriptionRequestsRequest.setter(Builder::owningProjectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("owningProjectId").build()}).build();
    private static final SdkField<String> OWNING_USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owningUserId").getter(ListSubscriptionRequestsRequest.getter(ListSubscriptionRequestsRequest::owningUserId)).setter(ListSubscriptionRequestsRequest.setter(Builder::owningUserId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("owningUserId").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortBy").getter(ListSubscriptionRequestsRequest.getter(ListSubscriptionRequestsRequest::sortByAsString)).setter(ListSubscriptionRequestsRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortOrder").getter(ListSubscriptionRequestsRequest.getter(ListSubscriptionRequestsRequest::sortOrderAsString)).setter(ListSubscriptionRequestsRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortOrder").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ListSubscriptionRequestsRequest.getter(ListSubscriptionRequestsRequest::statusAsString)).setter(ListSubscriptionRequestsRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()}).build();
    private static final SdkField<String> SUBSCRIBED_LISTING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscribedListingId").getter(ListSubscriptionRequestsRequest.getter(ListSubscriptionRequestsRequest::subscribedListingId)).setter(ListSubscriptionRequestsRequest.setter(Builder::subscribedListingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("subscribedListingId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROVER_PROJECT_ID_FIELD, DOMAIN_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, OWNING_GROUP_ID_FIELD, OWNING_PROJECT_ID_FIELD, OWNING_USER_ID_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, STATUS_FIELD, SUBSCRIBED_LISTING_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSubscriptionRequestsRequest.memberNameToFieldInitializer();
    private final String approverProjectId;
    private final String domainIdentifier;
    private final Integer maxResults;
    private final String nextToken;
    private final String owningGroupId;
    private final String owningProjectId;
    private final String owningUserId;
    private final String sortBy;
    private final String sortOrder;
    private final String status;
    private final String subscribedListingId;

    private ListSubscriptionRequestsRequest(BuilderImpl builder) {
        super(builder);
        this.approverProjectId = builder.approverProjectId;
        this.domainIdentifier = builder.domainIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.owningGroupId = builder.owningGroupId;
        this.owningProjectId = builder.owningProjectId;
        this.owningUserId = builder.owningUserId;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.status = builder.status;
        this.subscribedListingId = builder.subscribedListingId;
    }

    public final String approverProjectId() {
        return this.approverProjectId;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String owningGroupId() {
        return this.owningGroupId;
    }

    public final String owningProjectId() {
        return this.owningProjectId;
    }

    public final String owningUserId() {
        return this.owningUserId;
    }

    @Deprecated
    public final SortKey sortBy() {
        return SortKey.fromValue(this.sortBy);
    }

    @Deprecated
    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final SubscriptionRequestStatus status() {
        return SubscriptionRequestStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String subscribedListingId() {
        return this.subscribedListingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.approverProjectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.owningGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.owningProjectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.owningUserId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscribedListingId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubscriptionRequestsRequest)) {
            return false;
        }
        ListSubscriptionRequestsRequest other = (ListSubscriptionRequestsRequest)((Object)obj);
        return Objects.equals(this.approverProjectId(), other.approverProjectId()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.owningGroupId(), other.owningGroupId()) && Objects.equals(this.owningProjectId(), other.owningProjectId()) && Objects.equals(this.owningUserId(), other.owningUserId()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.subscribedListingId(), other.subscribedListingId());
    }

    public final String toString() {
        return ToString.builder((String)"ListSubscriptionRequestsRequest").add("ApproverProjectId", (Object)this.approverProjectId()).add("DomainIdentifier", (Object)this.domainIdentifier()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("OwningGroupId", (Object)this.owningGroupId()).add("OwningProjectId", (Object)this.owningProjectId()).add("OwningUserId", (Object)this.owningUserId()).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).add("Status", (Object)this.statusAsString()).add("SubscribedListingId", (Object)this.subscribedListingId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "approverProjectId": {
                return Optional.ofNullable(clazz.cast(this.approverProjectId()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "owningGroupId": {
                return Optional.ofNullable(clazz.cast(this.owningGroupId()));
            }
            case "owningProjectId": {
                return Optional.ofNullable(clazz.cast(this.owningProjectId()));
            }
            case "owningUserId": {
                return Optional.ofNullable(clazz.cast(this.owningUserId()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "sortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "subscribedListingId": {
                return Optional.ofNullable(clazz.cast(this.subscribedListingId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("approverProjectId", APPROVER_PROJECT_ID_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("owningGroupId", OWNING_GROUP_ID_FIELD);
        map.put("owningProjectId", OWNING_PROJECT_ID_FIELD);
        map.put("owningUserId", OWNING_USER_ID_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("subscribedListingId", SUBSCRIBED_LISTING_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSubscriptionRequestsRequest, T> g) {
        return obj -> g.apply((ListSubscriptionRequestsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String approverProjectId;
        private String domainIdentifier;
        private Integer maxResults;
        private String nextToken;
        private String owningGroupId;
        private String owningProjectId;
        private String owningUserId;
        private String sortBy;
        private String sortOrder;
        private String status;
        private String subscribedListingId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSubscriptionRequestsRequest model) {
            super(model);
            this.approverProjectId(model.approverProjectId);
            this.domainIdentifier(model.domainIdentifier);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.owningGroupId(model.owningGroupId);
            this.owningProjectId(model.owningProjectId);
            this.owningUserId(model.owningUserId);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
            this.status(model.status);
            this.subscribedListingId(model.subscribedListingId);
        }

        public final String getApproverProjectId() {
            return this.approverProjectId;
        }

        public final void setApproverProjectId(String approverProjectId) {
            this.approverProjectId = approverProjectId;
        }

        @Override
        public final Builder approverProjectId(String approverProjectId) {
            this.approverProjectId = approverProjectId;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getOwningGroupId() {
            return this.owningGroupId;
        }

        public final void setOwningGroupId(String owningGroupId) {
            this.owningGroupId = owningGroupId;
        }

        @Override
        public final Builder owningGroupId(String owningGroupId) {
            this.owningGroupId = owningGroupId;
            return this;
        }

        public final String getOwningProjectId() {
            return this.owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        public final String getOwningUserId() {
            return this.owningUserId;
        }

        public final void setOwningUserId(String owningUserId) {
            this.owningUserId = owningUserId;
        }

        @Override
        public final Builder owningUserId(String owningUserId) {
            this.owningUserId = owningUserId;
            return this;
        }

        @Deprecated
        public final String getSortBy() {
            return this.sortBy;
        }

        @Deprecated
        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        @Deprecated
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        @Deprecated
        public final Builder sortBy(SortKey sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SubscriptionRequestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSubscribedListingId() {
            return this.subscribedListingId;
        }

        public final void setSubscribedListingId(String subscribedListingId) {
            this.subscribedListingId = subscribedListingId;
        }

        @Override
        public final Builder subscribedListingId(String subscribedListingId) {
            this.subscribedListingId = subscribedListingId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSubscriptionRequestsRequest build() {
            return new ListSubscriptionRequestsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSubscriptionRequestsRequest> {
        public Builder approverProjectId(String var1);

        public Builder domainIdentifier(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder owningGroupId(String var1);

        public Builder owningProjectId(String var1);

        public Builder owningUserId(String var1);

        @Deprecated
        public Builder sortBy(String var1);

        @Deprecated
        public Builder sortBy(SortKey var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder status(String var1);

        public Builder status(SubscriptionRequestStatus var1);

        public Builder subscribedListingId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

