/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.DataSourceRunActivity;
import software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest;
import software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesResponse;

public class ListDataSourceRunActivitiesIterable
implements SdkIterable<ListDataSourceRunActivitiesResponse> {
    private final DataZoneClient client;
    private final ListDataSourceRunActivitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataSourceRunActivitiesIterable(DataZoneClient client, ListDataSourceRunActivitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataSourceRunActivitiesResponseFetcher();
    }

    public Iterator<ListDataSourceRunActivitiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataSourceRunActivity> items() {
        Function<ListDataSourceRunActivitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataSourceRunActivitiesResponseFetcher
    implements SyncPageFetcher<ListDataSourceRunActivitiesResponse> {
        private ListDataSourceRunActivitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListDataSourceRunActivitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataSourceRunActivitiesResponse nextPage(ListDataSourceRunActivitiesResponse previousPage) {
            if (previousPage == null) {
                return ListDataSourceRunActivitiesIterable.this.client.listDataSourceRunActivities(ListDataSourceRunActivitiesIterable.this.firstRequest);
            }
            return ListDataSourceRunActivitiesIterable.this.client.listDataSourceRunActivities((ListDataSourceRunActivitiesRequest)((Object)ListDataSourceRunActivitiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

