/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConnectionType {
    ATHENA("ATHENA"),
    BIGQUERY("BIGQUERY"),
    DATABRICKS("DATABRICKS"),
    DOCUMENTDB("DOCUMENTDB"),
    DYNAMODB("DYNAMODB"),
    HYPERPOD("HYPERPOD"),
    IAM("IAM"),
    MYSQL("MYSQL"),
    OPENSEARCH("OPENSEARCH"),
    ORACLE("ORACLE"),
    POSTGRESQL("POSTGRESQL"),
    REDSHIFT("REDSHIFT"),
    S3("S3"),
    SAPHANA("SAPHANA"),
    SNOWFLAKE("SNOWFLAKE"),
    SPARK("SPARK"),
    SQLSERVER("SQLSERVER"),
    TERADATA("TERADATA"),
    VERTICA("VERTICA"),
    WORKFLOWS_MWAA("WORKFLOWS_MWAA"),
    AMAZON_Q("AMAZON_Q"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConnectionType> VALUE_MAP;
    private final String value;

    private ConnectionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectionType> knownValues() {
        EnumSet<ConnectionType> knownValues = EnumSet.allOf(ConnectionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConnectionType.class, ConnectionType::toString);
    }
}

