/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.AmazonQPropertiesOutput;
import software.amazon.awssdk.services.datazone.model.AthenaPropertiesOutput;
import software.amazon.awssdk.services.datazone.model.GluePropertiesOutput;
import software.amazon.awssdk.services.datazone.model.HyperPodPropertiesOutput;
import software.amazon.awssdk.services.datazone.model.IamPropertiesOutput;
import software.amazon.awssdk.services.datazone.model.RedshiftPropertiesOutput;
import software.amazon.awssdk.services.datazone.model.S3PropertiesOutput;
import software.amazon.awssdk.services.datazone.model.SparkEmrPropertiesOutput;
import software.amazon.awssdk.services.datazone.model.SparkGluePropertiesOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionPropertiesOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionPropertiesOutput> {
    private static final SdkField<AmazonQPropertiesOutput> AMAZON_Q_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("amazonQProperties").getter(ConnectionPropertiesOutput.getter(ConnectionPropertiesOutput::amazonQProperties)).setter(ConnectionPropertiesOutput.setter(Builder::amazonQProperties)).constructor(AmazonQPropertiesOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amazonQProperties").build()}).build();
    private static final SdkField<AthenaPropertiesOutput> ATHENA_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("athenaProperties").getter(ConnectionPropertiesOutput.getter(ConnectionPropertiesOutput::athenaProperties)).setter(ConnectionPropertiesOutput.setter(Builder::athenaProperties)).constructor(AthenaPropertiesOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("athenaProperties").build()}).build();
    private static final SdkField<GluePropertiesOutput> GLUE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("glueProperties").getter(ConnectionPropertiesOutput.getter(ConnectionPropertiesOutput::glueProperties)).setter(ConnectionPropertiesOutput.setter(Builder::glueProperties)).constructor(GluePropertiesOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueProperties").build()}).build();
    private static final SdkField<HyperPodPropertiesOutput> HYPER_POD_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("hyperPodProperties").getter(ConnectionPropertiesOutput.getter(ConnectionPropertiesOutput::hyperPodProperties)).setter(ConnectionPropertiesOutput.setter(Builder::hyperPodProperties)).constructor(HyperPodPropertiesOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hyperPodProperties").build()}).build();
    private static final SdkField<IamPropertiesOutput> IAM_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iamProperties").getter(ConnectionPropertiesOutput.getter(ConnectionPropertiesOutput::iamProperties)).setter(ConnectionPropertiesOutput.setter(Builder::iamProperties)).constructor(IamPropertiesOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamProperties").build()}).build();
    private static final SdkField<RedshiftPropertiesOutput> REDSHIFT_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("redshiftProperties").getter(ConnectionPropertiesOutput.getter(ConnectionPropertiesOutput::redshiftProperties)).setter(ConnectionPropertiesOutput.setter(Builder::redshiftProperties)).constructor(RedshiftPropertiesOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftProperties").build()}).build();
    private static final SdkField<S3PropertiesOutput> S3_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Properties").getter(ConnectionPropertiesOutput.getter(ConnectionPropertiesOutput::s3Properties)).setter(ConnectionPropertiesOutput.setter(Builder::s3Properties)).constructor(S3PropertiesOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Properties").build()}).build();
    private static final SdkField<SparkEmrPropertiesOutput> SPARK_EMR_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sparkEmrProperties").getter(ConnectionPropertiesOutput.getter(ConnectionPropertiesOutput::sparkEmrProperties)).setter(ConnectionPropertiesOutput.setter(Builder::sparkEmrProperties)).constructor(SparkEmrPropertiesOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparkEmrProperties").build()}).build();
    private static final SdkField<SparkGluePropertiesOutput> SPARK_GLUE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sparkGlueProperties").getter(ConnectionPropertiesOutput.getter(ConnectionPropertiesOutput::sparkGlueProperties)).setter(ConnectionPropertiesOutput.setter(Builder::sparkGlueProperties)).constructor(SparkGluePropertiesOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparkGlueProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMAZON_Q_PROPERTIES_FIELD, ATHENA_PROPERTIES_FIELD, GLUE_PROPERTIES_FIELD, HYPER_POD_PROPERTIES_FIELD, IAM_PROPERTIES_FIELD, REDSHIFT_PROPERTIES_FIELD, S3_PROPERTIES_FIELD, SPARK_EMR_PROPERTIES_FIELD, SPARK_GLUE_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConnectionPropertiesOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AmazonQPropertiesOutput amazonQProperties;
    private final AthenaPropertiesOutput athenaProperties;
    private final GluePropertiesOutput glueProperties;
    private final HyperPodPropertiesOutput hyperPodProperties;
    private final IamPropertiesOutput iamProperties;
    private final RedshiftPropertiesOutput redshiftProperties;
    private final S3PropertiesOutput s3Properties;
    private final SparkEmrPropertiesOutput sparkEmrProperties;
    private final SparkGluePropertiesOutput sparkGlueProperties;
    private final Type type;

    private ConnectionPropertiesOutput(BuilderImpl builder) {
        this.amazonQProperties = builder.amazonQProperties;
        this.athenaProperties = builder.athenaProperties;
        this.glueProperties = builder.glueProperties;
        this.hyperPodProperties = builder.hyperPodProperties;
        this.iamProperties = builder.iamProperties;
        this.redshiftProperties = builder.redshiftProperties;
        this.s3Properties = builder.s3Properties;
        this.sparkEmrProperties = builder.sparkEmrProperties;
        this.sparkGlueProperties = builder.sparkGlueProperties;
        this.type = builder.type;
    }

    public final AmazonQPropertiesOutput amazonQProperties() {
        return this.amazonQProperties;
    }

    public final AthenaPropertiesOutput athenaProperties() {
        return this.athenaProperties;
    }

    public final GluePropertiesOutput glueProperties() {
        return this.glueProperties;
    }

    public final HyperPodPropertiesOutput hyperPodProperties() {
        return this.hyperPodProperties;
    }

    public final IamPropertiesOutput iamProperties() {
        return this.iamProperties;
    }

    public final RedshiftPropertiesOutput redshiftProperties() {
        return this.redshiftProperties;
    }

    public final S3PropertiesOutput s3Properties() {
        return this.s3Properties;
    }

    public final SparkEmrPropertiesOutput sparkEmrProperties() {
        return this.sparkEmrProperties;
    }

    public final SparkGluePropertiesOutput sparkGlueProperties() {
        return this.sparkGlueProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonQProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.athenaProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.glueProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperPodProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Properties());
        hashCode = 31 * hashCode + Objects.hashCode(this.sparkEmrProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.sparkGlueProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionPropertiesOutput)) {
            return false;
        }
        ConnectionPropertiesOutput other = (ConnectionPropertiesOutput)obj;
        return Objects.equals(this.amazonQProperties(), other.amazonQProperties()) && Objects.equals(this.athenaProperties(), other.athenaProperties()) && Objects.equals(this.glueProperties(), other.glueProperties()) && Objects.equals(this.hyperPodProperties(), other.hyperPodProperties()) && Objects.equals(this.iamProperties(), other.iamProperties()) && Objects.equals(this.redshiftProperties(), other.redshiftProperties()) && Objects.equals(this.s3Properties(), other.s3Properties()) && Objects.equals(this.sparkEmrProperties(), other.sparkEmrProperties()) && Objects.equals(this.sparkGlueProperties(), other.sparkGlueProperties());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectionPropertiesOutput").add("AmazonQProperties", (Object)this.amazonQProperties()).add("AthenaProperties", (Object)this.athenaProperties()).add("GlueProperties", (Object)this.glueProperties()).add("HyperPodProperties", (Object)this.hyperPodProperties()).add("IamProperties", (Object)this.iamProperties()).add("RedshiftProperties", (Object)this.redshiftProperties()).add("S3Properties", (Object)this.s3Properties()).add("SparkEmrProperties", (Object)this.sparkEmrProperties()).add("SparkGlueProperties", (Object)this.sparkGlueProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "amazonQProperties": {
                return Optional.ofNullable(clazz.cast(this.amazonQProperties()));
            }
            case "athenaProperties": {
                return Optional.ofNullable(clazz.cast(this.athenaProperties()));
            }
            case "glueProperties": {
                return Optional.ofNullable(clazz.cast(this.glueProperties()));
            }
            case "hyperPodProperties": {
                return Optional.ofNullable(clazz.cast(this.hyperPodProperties()));
            }
            case "iamProperties": {
                return Optional.ofNullable(clazz.cast(this.iamProperties()));
            }
            case "redshiftProperties": {
                return Optional.ofNullable(clazz.cast(this.redshiftProperties()));
            }
            case "s3Properties": {
                return Optional.ofNullable(clazz.cast(this.s3Properties()));
            }
            case "sparkEmrProperties": {
                return Optional.ofNullable(clazz.cast(this.sparkEmrProperties()));
            }
            case "sparkGlueProperties": {
                return Optional.ofNullable(clazz.cast(this.sparkGlueProperties()));
            }
        }
        return Optional.empty();
    }

    public static ConnectionPropertiesOutput fromAmazonQProperties(AmazonQPropertiesOutput amazonQProperties) {
        return (ConnectionPropertiesOutput)ConnectionPropertiesOutput.builder().amazonQProperties(amazonQProperties).build();
    }

    public static ConnectionPropertiesOutput fromAmazonQProperties(Consumer<AmazonQPropertiesOutput.Builder> amazonQProperties) {
        AmazonQPropertiesOutput.Builder builder = AmazonQPropertiesOutput.builder();
        amazonQProperties.accept(builder);
        return ConnectionPropertiesOutput.fromAmazonQProperties((AmazonQPropertiesOutput)builder.build());
    }

    public static ConnectionPropertiesOutput fromAthenaProperties(AthenaPropertiesOutput athenaProperties) {
        return (ConnectionPropertiesOutput)ConnectionPropertiesOutput.builder().athenaProperties(athenaProperties).build();
    }

    public static ConnectionPropertiesOutput fromAthenaProperties(Consumer<AthenaPropertiesOutput.Builder> athenaProperties) {
        AthenaPropertiesOutput.Builder builder = AthenaPropertiesOutput.builder();
        athenaProperties.accept(builder);
        return ConnectionPropertiesOutput.fromAthenaProperties((AthenaPropertiesOutput)builder.build());
    }

    public static ConnectionPropertiesOutput fromGlueProperties(GluePropertiesOutput glueProperties) {
        return (ConnectionPropertiesOutput)ConnectionPropertiesOutput.builder().glueProperties(glueProperties).build();
    }

    public static ConnectionPropertiesOutput fromGlueProperties(Consumer<GluePropertiesOutput.Builder> glueProperties) {
        GluePropertiesOutput.Builder builder = GluePropertiesOutput.builder();
        glueProperties.accept(builder);
        return ConnectionPropertiesOutput.fromGlueProperties((GluePropertiesOutput)builder.build());
    }

    public static ConnectionPropertiesOutput fromHyperPodProperties(HyperPodPropertiesOutput hyperPodProperties) {
        return (ConnectionPropertiesOutput)ConnectionPropertiesOutput.builder().hyperPodProperties(hyperPodProperties).build();
    }

    public static ConnectionPropertiesOutput fromHyperPodProperties(Consumer<HyperPodPropertiesOutput.Builder> hyperPodProperties) {
        HyperPodPropertiesOutput.Builder builder = HyperPodPropertiesOutput.builder();
        hyperPodProperties.accept(builder);
        return ConnectionPropertiesOutput.fromHyperPodProperties((HyperPodPropertiesOutput)builder.build());
    }

    public static ConnectionPropertiesOutput fromIamProperties(IamPropertiesOutput iamProperties) {
        return (ConnectionPropertiesOutput)ConnectionPropertiesOutput.builder().iamProperties(iamProperties).build();
    }

    public static ConnectionPropertiesOutput fromIamProperties(Consumer<IamPropertiesOutput.Builder> iamProperties) {
        IamPropertiesOutput.Builder builder = IamPropertiesOutput.builder();
        iamProperties.accept(builder);
        return ConnectionPropertiesOutput.fromIamProperties((IamPropertiesOutput)builder.build());
    }

    public static ConnectionPropertiesOutput fromRedshiftProperties(RedshiftPropertiesOutput redshiftProperties) {
        return (ConnectionPropertiesOutput)ConnectionPropertiesOutput.builder().redshiftProperties(redshiftProperties).build();
    }

    public static ConnectionPropertiesOutput fromRedshiftProperties(Consumer<RedshiftPropertiesOutput.Builder> redshiftProperties) {
        RedshiftPropertiesOutput.Builder builder = RedshiftPropertiesOutput.builder();
        redshiftProperties.accept(builder);
        return ConnectionPropertiesOutput.fromRedshiftProperties((RedshiftPropertiesOutput)builder.build());
    }

    public static ConnectionPropertiesOutput fromS3Properties(S3PropertiesOutput s3Properties) {
        return (ConnectionPropertiesOutput)ConnectionPropertiesOutput.builder().s3Properties(s3Properties).build();
    }

    public static ConnectionPropertiesOutput fromS3Properties(Consumer<S3PropertiesOutput.Builder> s3Properties) {
        S3PropertiesOutput.Builder builder = S3PropertiesOutput.builder();
        s3Properties.accept(builder);
        return ConnectionPropertiesOutput.fromS3Properties((S3PropertiesOutput)builder.build());
    }

    public static ConnectionPropertiesOutput fromSparkEmrProperties(SparkEmrPropertiesOutput sparkEmrProperties) {
        return (ConnectionPropertiesOutput)ConnectionPropertiesOutput.builder().sparkEmrProperties(sparkEmrProperties).build();
    }

    public static ConnectionPropertiesOutput fromSparkEmrProperties(Consumer<SparkEmrPropertiesOutput.Builder> sparkEmrProperties) {
        SparkEmrPropertiesOutput.Builder builder = SparkEmrPropertiesOutput.builder();
        sparkEmrProperties.accept(builder);
        return ConnectionPropertiesOutput.fromSparkEmrProperties((SparkEmrPropertiesOutput)builder.build());
    }

    public static ConnectionPropertiesOutput fromSparkGlueProperties(SparkGluePropertiesOutput sparkGlueProperties) {
        return (ConnectionPropertiesOutput)ConnectionPropertiesOutput.builder().sparkGlueProperties(sparkGlueProperties).build();
    }

    public static ConnectionPropertiesOutput fromSparkGlueProperties(Consumer<SparkGluePropertiesOutput.Builder> sparkGlueProperties) {
        SparkGluePropertiesOutput.Builder builder = SparkGluePropertiesOutput.builder();
        sparkGlueProperties.accept(builder);
        return ConnectionPropertiesOutput.fromSparkGlueProperties((SparkGluePropertiesOutput)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("amazonQProperties", AMAZON_Q_PROPERTIES_FIELD);
        map.put("athenaProperties", ATHENA_PROPERTIES_FIELD);
        map.put("glueProperties", GLUE_PROPERTIES_FIELD);
        map.put("hyperPodProperties", HYPER_POD_PROPERTIES_FIELD);
        map.put("iamProperties", IAM_PROPERTIES_FIELD);
        map.put("redshiftProperties", REDSHIFT_PROPERTIES_FIELD);
        map.put("s3Properties", S3_PROPERTIES_FIELD);
        map.put("sparkEmrProperties", SPARK_EMR_PROPERTIES_FIELD);
        map.put("sparkGlueProperties", SPARK_GLUE_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionPropertiesOutput, T> g) {
        return obj -> g.apply((ConnectionPropertiesOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        AMAZON_Q_PROPERTIES,
        ATHENA_PROPERTIES,
        GLUE_PROPERTIES,
        HYPER_POD_PROPERTIES,
        IAM_PROPERTIES,
        REDSHIFT_PROPERTIES,
        S3_PROPERTIES,
        SPARK_EMR_PROPERTIES,
        SPARK_GLUE_PROPERTIES,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AmazonQPropertiesOutput amazonQProperties;
        private AthenaPropertiesOutput athenaProperties;
        private GluePropertiesOutput glueProperties;
        private HyperPodPropertiesOutput hyperPodProperties;
        private IamPropertiesOutput iamProperties;
        private RedshiftPropertiesOutput redshiftProperties;
        private S3PropertiesOutput s3Properties;
        private SparkEmrPropertiesOutput sparkEmrProperties;
        private SparkGluePropertiesOutput sparkGlueProperties;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionPropertiesOutput model) {
            this.amazonQProperties(model.amazonQProperties);
            this.athenaProperties(model.athenaProperties);
            this.glueProperties(model.glueProperties);
            this.hyperPodProperties(model.hyperPodProperties);
            this.iamProperties(model.iamProperties);
            this.redshiftProperties(model.redshiftProperties);
            this.s3Properties(model.s3Properties);
            this.sparkEmrProperties(model.sparkEmrProperties);
            this.sparkGlueProperties(model.sparkGlueProperties);
        }

        public final AmazonQPropertiesOutput.Builder getAmazonQProperties() {
            return this.amazonQProperties != null ? this.amazonQProperties.toBuilder() : null;
        }

        public final void setAmazonQProperties(AmazonQPropertiesOutput.BuilderImpl amazonQProperties) {
            AmazonQPropertiesOutput oldValue = this.amazonQProperties;
            this.amazonQProperties = amazonQProperties != null ? amazonQProperties.build() : null;
            this.handleUnionValueChange(Type.AMAZON_Q_PROPERTIES, oldValue, this.amazonQProperties);
        }

        @Override
        public final Builder amazonQProperties(AmazonQPropertiesOutput amazonQProperties) {
            AmazonQPropertiesOutput oldValue = this.amazonQProperties;
            this.amazonQProperties = amazonQProperties;
            this.handleUnionValueChange(Type.AMAZON_Q_PROPERTIES, oldValue, this.amazonQProperties);
            return this;
        }

        public final AthenaPropertiesOutput.Builder getAthenaProperties() {
            return this.athenaProperties != null ? this.athenaProperties.toBuilder() : null;
        }

        public final void setAthenaProperties(AthenaPropertiesOutput.BuilderImpl athenaProperties) {
            AthenaPropertiesOutput oldValue = this.athenaProperties;
            this.athenaProperties = athenaProperties != null ? athenaProperties.build() : null;
            this.handleUnionValueChange(Type.ATHENA_PROPERTIES, oldValue, this.athenaProperties);
        }

        @Override
        public final Builder athenaProperties(AthenaPropertiesOutput athenaProperties) {
            AthenaPropertiesOutput oldValue = this.athenaProperties;
            this.athenaProperties = athenaProperties;
            this.handleUnionValueChange(Type.ATHENA_PROPERTIES, oldValue, this.athenaProperties);
            return this;
        }

        public final GluePropertiesOutput.Builder getGlueProperties() {
            return this.glueProperties != null ? this.glueProperties.toBuilder() : null;
        }

        public final void setGlueProperties(GluePropertiesOutput.BuilderImpl glueProperties) {
            GluePropertiesOutput oldValue = this.glueProperties;
            this.glueProperties = glueProperties != null ? glueProperties.build() : null;
            this.handleUnionValueChange(Type.GLUE_PROPERTIES, oldValue, this.glueProperties);
        }

        @Override
        public final Builder glueProperties(GluePropertiesOutput glueProperties) {
            GluePropertiesOutput oldValue = this.glueProperties;
            this.glueProperties = glueProperties;
            this.handleUnionValueChange(Type.GLUE_PROPERTIES, oldValue, this.glueProperties);
            return this;
        }

        public final HyperPodPropertiesOutput.Builder getHyperPodProperties() {
            return this.hyperPodProperties != null ? this.hyperPodProperties.toBuilder() : null;
        }

        public final void setHyperPodProperties(HyperPodPropertiesOutput.BuilderImpl hyperPodProperties) {
            HyperPodPropertiesOutput oldValue = this.hyperPodProperties;
            this.hyperPodProperties = hyperPodProperties != null ? hyperPodProperties.build() : null;
            this.handleUnionValueChange(Type.HYPER_POD_PROPERTIES, oldValue, this.hyperPodProperties);
        }

        @Override
        public final Builder hyperPodProperties(HyperPodPropertiesOutput hyperPodProperties) {
            HyperPodPropertiesOutput oldValue = this.hyperPodProperties;
            this.hyperPodProperties = hyperPodProperties;
            this.handleUnionValueChange(Type.HYPER_POD_PROPERTIES, oldValue, this.hyperPodProperties);
            return this;
        }

        public final IamPropertiesOutput.Builder getIamProperties() {
            return this.iamProperties != null ? this.iamProperties.toBuilder() : null;
        }

        public final void setIamProperties(IamPropertiesOutput.BuilderImpl iamProperties) {
            IamPropertiesOutput oldValue = this.iamProperties;
            this.iamProperties = iamProperties != null ? iamProperties.build() : null;
            this.handleUnionValueChange(Type.IAM_PROPERTIES, oldValue, this.iamProperties);
        }

        @Override
        public final Builder iamProperties(IamPropertiesOutput iamProperties) {
            IamPropertiesOutput oldValue = this.iamProperties;
            this.iamProperties = iamProperties;
            this.handleUnionValueChange(Type.IAM_PROPERTIES, oldValue, this.iamProperties);
            return this;
        }

        public final RedshiftPropertiesOutput.Builder getRedshiftProperties() {
            return this.redshiftProperties != null ? this.redshiftProperties.toBuilder() : null;
        }

        public final void setRedshiftProperties(RedshiftPropertiesOutput.BuilderImpl redshiftProperties) {
            RedshiftPropertiesOutput oldValue = this.redshiftProperties;
            this.redshiftProperties = redshiftProperties != null ? redshiftProperties.build() : null;
            this.handleUnionValueChange(Type.REDSHIFT_PROPERTIES, oldValue, this.redshiftProperties);
        }

        @Override
        public final Builder redshiftProperties(RedshiftPropertiesOutput redshiftProperties) {
            RedshiftPropertiesOutput oldValue = this.redshiftProperties;
            this.redshiftProperties = redshiftProperties;
            this.handleUnionValueChange(Type.REDSHIFT_PROPERTIES, oldValue, this.redshiftProperties);
            return this;
        }

        public final S3PropertiesOutput.Builder getS3Properties() {
            return this.s3Properties != null ? this.s3Properties.toBuilder() : null;
        }

        public final void setS3Properties(S3PropertiesOutput.BuilderImpl s3Properties) {
            S3PropertiesOutput oldValue = this.s3Properties;
            this.s3Properties = s3Properties != null ? s3Properties.build() : null;
            this.handleUnionValueChange(Type.S3_PROPERTIES, oldValue, this.s3Properties);
        }

        @Override
        public final Builder s3Properties(S3PropertiesOutput s3Properties) {
            S3PropertiesOutput oldValue = this.s3Properties;
            this.s3Properties = s3Properties;
            this.handleUnionValueChange(Type.S3_PROPERTIES, oldValue, this.s3Properties);
            return this;
        }

        public final SparkEmrPropertiesOutput.Builder getSparkEmrProperties() {
            return this.sparkEmrProperties != null ? this.sparkEmrProperties.toBuilder() : null;
        }

        public final void setSparkEmrProperties(SparkEmrPropertiesOutput.BuilderImpl sparkEmrProperties) {
            SparkEmrPropertiesOutput oldValue = this.sparkEmrProperties;
            this.sparkEmrProperties = sparkEmrProperties != null ? sparkEmrProperties.build() : null;
            this.handleUnionValueChange(Type.SPARK_EMR_PROPERTIES, oldValue, this.sparkEmrProperties);
        }

        @Override
        public final Builder sparkEmrProperties(SparkEmrPropertiesOutput sparkEmrProperties) {
            SparkEmrPropertiesOutput oldValue = this.sparkEmrProperties;
            this.sparkEmrProperties = sparkEmrProperties;
            this.handleUnionValueChange(Type.SPARK_EMR_PROPERTIES, oldValue, this.sparkEmrProperties);
            return this;
        }

        public final SparkGluePropertiesOutput.Builder getSparkGlueProperties() {
            return this.sparkGlueProperties != null ? this.sparkGlueProperties.toBuilder() : null;
        }

        public final void setSparkGlueProperties(SparkGluePropertiesOutput.BuilderImpl sparkGlueProperties) {
            SparkGluePropertiesOutput oldValue = this.sparkGlueProperties;
            this.sparkGlueProperties = sparkGlueProperties != null ? sparkGlueProperties.build() : null;
            this.handleUnionValueChange(Type.SPARK_GLUE_PROPERTIES, oldValue, this.sparkGlueProperties);
        }

        @Override
        public final Builder sparkGlueProperties(SparkGluePropertiesOutput sparkGlueProperties) {
            SparkGluePropertiesOutput oldValue = this.sparkGlueProperties;
            this.sparkGlueProperties = sparkGlueProperties;
            this.handleUnionValueChange(Type.SPARK_GLUE_PROPERTIES, oldValue, this.sparkGlueProperties);
            return this;
        }

        public ConnectionPropertiesOutput build() {
            return new ConnectionPropertiesOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionPropertiesOutput> {
        public Builder amazonQProperties(AmazonQPropertiesOutput var1);

        default public Builder amazonQProperties(Consumer<AmazonQPropertiesOutput.Builder> amazonQProperties) {
            return this.amazonQProperties((AmazonQPropertiesOutput)((AmazonQPropertiesOutput.Builder)AmazonQPropertiesOutput.builder().applyMutation(amazonQProperties)).build());
        }

        public Builder athenaProperties(AthenaPropertiesOutput var1);

        default public Builder athenaProperties(Consumer<AthenaPropertiesOutput.Builder> athenaProperties) {
            return this.athenaProperties((AthenaPropertiesOutput)((AthenaPropertiesOutput.Builder)AthenaPropertiesOutput.builder().applyMutation(athenaProperties)).build());
        }

        public Builder glueProperties(GluePropertiesOutput var1);

        default public Builder glueProperties(Consumer<GluePropertiesOutput.Builder> glueProperties) {
            return this.glueProperties((GluePropertiesOutput)((GluePropertiesOutput.Builder)GluePropertiesOutput.builder().applyMutation(glueProperties)).build());
        }

        public Builder hyperPodProperties(HyperPodPropertiesOutput var1);

        default public Builder hyperPodProperties(Consumer<HyperPodPropertiesOutput.Builder> hyperPodProperties) {
            return this.hyperPodProperties((HyperPodPropertiesOutput)((HyperPodPropertiesOutput.Builder)HyperPodPropertiesOutput.builder().applyMutation(hyperPodProperties)).build());
        }

        public Builder iamProperties(IamPropertiesOutput var1);

        default public Builder iamProperties(Consumer<IamPropertiesOutput.Builder> iamProperties) {
            return this.iamProperties((IamPropertiesOutput)((IamPropertiesOutput.Builder)IamPropertiesOutput.builder().applyMutation(iamProperties)).build());
        }

        public Builder redshiftProperties(RedshiftPropertiesOutput var1);

        default public Builder redshiftProperties(Consumer<RedshiftPropertiesOutput.Builder> redshiftProperties) {
            return this.redshiftProperties((RedshiftPropertiesOutput)((RedshiftPropertiesOutput.Builder)RedshiftPropertiesOutput.builder().applyMutation(redshiftProperties)).build());
        }

        public Builder s3Properties(S3PropertiesOutput var1);

        default public Builder s3Properties(Consumer<S3PropertiesOutput.Builder> s3Properties) {
            return this.s3Properties((S3PropertiesOutput)((S3PropertiesOutput.Builder)S3PropertiesOutput.builder().applyMutation(s3Properties)).build());
        }

        public Builder sparkEmrProperties(SparkEmrPropertiesOutput var1);

        default public Builder sparkEmrProperties(Consumer<SparkEmrPropertiesOutput.Builder> sparkEmrProperties) {
            return this.sparkEmrProperties((SparkEmrPropertiesOutput)((SparkEmrPropertiesOutput.Builder)SparkEmrPropertiesOutput.builder().applyMutation(sparkEmrProperties)).build());
        }

        public Builder sparkGlueProperties(SparkGluePropertiesOutput var1);

        default public Builder sparkGlueProperties(Consumer<SparkGluePropertiesOutput.Builder> sparkGlueProperties) {
            return this.sparkGlueProperties((SparkGluePropertiesOutput)((SparkGluePropertiesOutput.Builder)SparkGluePropertiesOutput.builder().applyMutation(sparkGlueProperties)).build());
        }
    }
}

