/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProjectStatus {
    ACTIVE("ACTIVE"),
    DELETING("DELETING"),
    DELETE_FAILED("DELETE_FAILED"),
    UPDATING("UPDATING"),
    UPDATE_FAILED("UPDATE_FAILED"),
    MOVING("MOVING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProjectStatus> VALUE_MAP;
    private final String value;

    private ProjectStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProjectStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProjectStatus> knownValues() {
        EnumSet<ProjectStatus> knownValues = EnumSet.allOf(ProjectStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProjectStatus.class, ProjectStatus::toString);
    }
}

