/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.JobRunSummary;
import software.amazon.awssdk.services.datazone.model.ListJobRunsRequest;
import software.amazon.awssdk.services.datazone.model.ListJobRunsResponse;

public class ListJobRunsPublisher
implements SdkPublisher<ListJobRunsResponse> {
    private final DataZoneAsyncClient client;
    private final ListJobRunsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListJobRunsPublisher(DataZoneAsyncClient client, ListJobRunsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListJobRunsPublisher(DataZoneAsyncClient client, ListJobRunsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListJobRunsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListJobRunsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<JobRunSummary> items() {
        Function<ListJobRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListJobRunsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListJobRunsResponseFetcher
    implements AsyncPageFetcher<ListJobRunsResponse> {
        private ListJobRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListJobRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListJobRunsResponse> nextPage(ListJobRunsResponse previousPage) {
            if (previousPage == null) {
                return ListJobRunsPublisher.this.client.listJobRuns(ListJobRunsPublisher.this.firstRequest);
            }
            return ListJobRunsPublisher.this.client.listJobRuns((ListJobRunsRequest)((Object)ListJobRunsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

