/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.LineageNodeSummary;
import software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryRequest;
import software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryResponse;

public class ListLineageNodeHistoryIterable
implements SdkIterable<ListLineageNodeHistoryResponse> {
    private final DataZoneClient client;
    private final ListLineageNodeHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLineageNodeHistoryIterable(DataZoneClient client, ListLineageNodeHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLineageNodeHistoryResponseFetcher();
    }

    public Iterator<ListLineageNodeHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LineageNodeSummary> nodes() {
        Function<ListLineageNodeHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.nodes() != null) {
                return response.nodes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLineageNodeHistoryResponseFetcher
    implements SyncPageFetcher<ListLineageNodeHistoryResponse> {
        private ListLineageNodeHistoryResponseFetcher() {
        }

        public boolean hasNextPage(ListLineageNodeHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLineageNodeHistoryResponse nextPage(ListLineageNodeHistoryResponse previousPage) {
            if (previousPage == null) {
                return ListLineageNodeHistoryIterable.this.client.listLineageNodeHistory(ListLineageNodeHistoryIterable.this.firstRequest);
            }
            return ListLineageNodeHistoryIterable.this.client.listLineageNodeHistory((ListLineageNodeHistoryRequest)((Object)ListLineageNodeHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

