/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DomainVersion {
    V1("V1"),
    V2("V2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DomainVersion> VALUE_MAP;
    private final String value;

    private DomainVersion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DomainVersion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DomainVersion> knownValues() {
        EnumSet<DomainVersion> knownValues = EnumSet.allOf(DomainVersion.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DomainVersion.class, DomainVersion::toString);
    }
}

