/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.AssetListingDetails;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.FormOutput;
import software.amazon.awssdk.services.datazone.model.FormOutputListCopier;
import software.amazon.awssdk.services.datazone.model.GlossaryTermsCopier;
import software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointSummaryFormOutput;
import software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointSummaryFormOutputListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAssetResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, GetAssetResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetAssetResponse.getter(GetAssetResponse::createdAt)).setter(GetAssetResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(GetAssetResponse.getter(GetAssetResponse::createdBy)).setter(GetAssetResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetAssetResponse.getter(GetAssetResponse::description)).setter(GetAssetResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(GetAssetResponse.getter(GetAssetResponse::domainId)).setter(GetAssetResponse.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()}).build();
    private static final SdkField<String> EXTERNAL_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalIdentifier").getter(GetAssetResponse.getter(GetAssetResponse::externalIdentifier)).setter(GetAssetResponse.setter(Builder::externalIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalIdentifier").build()}).build();
    private static final SdkField<Instant> FIRST_REVISION_CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("firstRevisionCreatedAt").getter(GetAssetResponse.getter(GetAssetResponse::firstRevisionCreatedAt)).setter(GetAssetResponse.setter(Builder::firstRevisionCreatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstRevisionCreatedAt").build()}).build();
    private static final SdkField<String> FIRST_REVISION_CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("firstRevisionCreatedBy").getter(GetAssetResponse.getter(GetAssetResponse::firstRevisionCreatedBy)).setter(GetAssetResponse.setter(Builder::firstRevisionCreatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstRevisionCreatedBy").build()}).build();
    private static final SdkField<List<FormOutput>> FORMS_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("formsOutput").getter(GetAssetResponse.getter(GetAssetResponse::formsOutput)).setter(GetAssetResponse.setter(Builder::formsOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formsOutput").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FormOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> GLOSSARY_TERMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("glossaryTerms").getter(GetAssetResponse.getter(GetAssetResponse::glossaryTerms)).setter(GetAssetResponse.setter(Builder::glossaryTerms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetAssetResponse.getter(GetAssetResponse::id)).setter(GetAssetResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<List<TimeSeriesDataPointSummaryFormOutput>> LATEST_TIME_SERIES_DATA_POINT_FORMS_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("latestTimeSeriesDataPointFormsOutput").getter(GetAssetResponse.getter(GetAssetResponse::latestTimeSeriesDataPointFormsOutput)).setter(GetAssetResponse.setter(Builder::latestTimeSeriesDataPointFormsOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestTimeSeriesDataPointFormsOutput").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimeSeriesDataPointSummaryFormOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AssetListingDetails> LISTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("listing").getter(GetAssetResponse.getter(GetAssetResponse::listing)).setter(GetAssetResponse.setter(Builder::listing)).constructor(AssetListingDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listing").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetAssetResponse.getter(GetAssetResponse::name)).setter(GetAssetResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owningProjectId").getter(GetAssetResponse.getter(GetAssetResponse::owningProjectId)).setter(GetAssetResponse.setter(Builder::owningProjectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectId").build()}).build();
    private static final SdkField<List<FormOutput>> READ_ONLY_FORMS_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("readOnlyFormsOutput").getter(GetAssetResponse.getter(GetAssetResponse::readOnlyFormsOutput)).setter(GetAssetResponse.setter(Builder::readOnlyFormsOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readOnlyFormsOutput").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FormOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revision").getter(GetAssetResponse.getter(GetAssetResponse::revision)).setter(GetAssetResponse.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()}).build();
    private static final SdkField<String> TYPE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("typeIdentifier").getter(GetAssetResponse.getter(GetAssetResponse::typeIdentifier)).setter(GetAssetResponse.setter(Builder::typeIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeIdentifier").build()}).build();
    private static final SdkField<String> TYPE_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("typeRevision").getter(GetAssetResponse.getter(GetAssetResponse::typeRevision)).setter(GetAssetResponse.setter(Builder::typeRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeRevision").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, CREATED_BY_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, EXTERNAL_IDENTIFIER_FIELD, FIRST_REVISION_CREATED_AT_FIELD, FIRST_REVISION_CREATED_BY_FIELD, FORMS_OUTPUT_FIELD, GLOSSARY_TERMS_FIELD, ID_FIELD, LATEST_TIME_SERIES_DATA_POINT_FORMS_OUTPUT_FIELD, LISTING_FIELD, NAME_FIELD, OWNING_PROJECT_ID_FIELD, READ_ONLY_FORMS_OUTPUT_FIELD, REVISION_FIELD, TYPE_IDENTIFIER_FIELD, TYPE_REVISION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAssetResponse.memberNameToFieldInitializer();
    private final Instant createdAt;
    private final String createdBy;
    private final String description;
    private final String domainId;
    private final String externalIdentifier;
    private final Instant firstRevisionCreatedAt;
    private final String firstRevisionCreatedBy;
    private final List<FormOutput> formsOutput;
    private final List<String> glossaryTerms;
    private final String id;
    private final List<TimeSeriesDataPointSummaryFormOutput> latestTimeSeriesDataPointFormsOutput;
    private final AssetListingDetails listing;
    private final String name;
    private final String owningProjectId;
    private final List<FormOutput> readOnlyFormsOutput;
    private final String revision;
    private final String typeIdentifier;
    private final String typeRevision;

    private GetAssetResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.externalIdentifier = builder.externalIdentifier;
        this.firstRevisionCreatedAt = builder.firstRevisionCreatedAt;
        this.firstRevisionCreatedBy = builder.firstRevisionCreatedBy;
        this.formsOutput = builder.formsOutput;
        this.glossaryTerms = builder.glossaryTerms;
        this.id = builder.id;
        this.latestTimeSeriesDataPointFormsOutput = builder.latestTimeSeriesDataPointFormsOutput;
        this.listing = builder.listing;
        this.name = builder.name;
        this.owningProjectId = builder.owningProjectId;
        this.readOnlyFormsOutput = builder.readOnlyFormsOutput;
        this.revision = builder.revision;
        this.typeIdentifier = builder.typeIdentifier;
        this.typeRevision = builder.typeRevision;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String description() {
        return this.description;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String externalIdentifier() {
        return this.externalIdentifier;
    }

    public final Instant firstRevisionCreatedAt() {
        return this.firstRevisionCreatedAt;
    }

    public final String firstRevisionCreatedBy() {
        return this.firstRevisionCreatedBy;
    }

    public final boolean hasFormsOutput() {
        return this.formsOutput != null && !(this.formsOutput instanceof SdkAutoConstructList);
    }

    public final List<FormOutput> formsOutput() {
        return this.formsOutput;
    }

    public final boolean hasGlossaryTerms() {
        return this.glossaryTerms != null && !(this.glossaryTerms instanceof SdkAutoConstructList);
    }

    public final List<String> glossaryTerms() {
        return this.glossaryTerms;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasLatestTimeSeriesDataPointFormsOutput() {
        return this.latestTimeSeriesDataPointFormsOutput != null && !(this.latestTimeSeriesDataPointFormsOutput instanceof SdkAutoConstructList);
    }

    public final List<TimeSeriesDataPointSummaryFormOutput> latestTimeSeriesDataPointFormsOutput() {
        return this.latestTimeSeriesDataPointFormsOutput;
    }

    public final AssetListingDetails listing() {
        return this.listing;
    }

    public final String name() {
        return this.name;
    }

    public final String owningProjectId() {
        return this.owningProjectId;
    }

    public final boolean hasReadOnlyFormsOutput() {
        return this.readOnlyFormsOutput != null && !(this.readOnlyFormsOutput instanceof SdkAutoConstructList);
    }

    public final List<FormOutput> readOnlyFormsOutput() {
        return this.readOnlyFormsOutput;
    }

    public final String revision() {
        return this.revision;
    }

    public final String typeIdentifier() {
        return this.typeIdentifier;
    }

    public final String typeRevision() {
        return this.typeRevision;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstRevisionCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstRevisionCreatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFormsOutput() ? this.formsOutput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlossaryTerms() ? this.glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLatestTimeSeriesDataPointFormsOutput() ? this.latestTimeSeriesDataPointFormsOutput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.listing());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owningProjectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReadOnlyFormsOutput() ? this.readOnlyFormsOutput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeRevision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssetResponse)) {
            return false;
        }
        GetAssetResponse other = (GetAssetResponse)((Object)obj);
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.externalIdentifier(), other.externalIdentifier()) && Objects.equals(this.firstRevisionCreatedAt(), other.firstRevisionCreatedAt()) && Objects.equals(this.firstRevisionCreatedBy(), other.firstRevisionCreatedBy()) && this.hasFormsOutput() == other.hasFormsOutput() && Objects.equals(this.formsOutput(), other.formsOutput()) && this.hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(this.glossaryTerms(), other.glossaryTerms()) && Objects.equals(this.id(), other.id()) && this.hasLatestTimeSeriesDataPointFormsOutput() == other.hasLatestTimeSeriesDataPointFormsOutput() && Objects.equals(this.latestTimeSeriesDataPointFormsOutput(), other.latestTimeSeriesDataPointFormsOutput()) && Objects.equals(this.listing(), other.listing()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owningProjectId(), other.owningProjectId()) && this.hasReadOnlyFormsOutput() == other.hasReadOnlyFormsOutput() && Objects.equals(this.readOnlyFormsOutput(), other.readOnlyFormsOutput()) && Objects.equals(this.revision(), other.revision()) && Objects.equals(this.typeIdentifier(), other.typeIdentifier()) && Objects.equals(this.typeRevision(), other.typeRevision());
    }

    public final String toString() {
        return ToString.builder((String)"GetAssetResponse").add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainId", (Object)this.domainId()).add("ExternalIdentifier", (Object)this.externalIdentifier()).add("FirstRevisionCreatedAt", (Object)this.firstRevisionCreatedAt()).add("FirstRevisionCreatedBy", (Object)this.firstRevisionCreatedBy()).add("FormsOutput", this.hasFormsOutput() ? this.formsOutput() : null).add("GlossaryTerms", this.hasGlossaryTerms() ? this.glossaryTerms() : null).add("Id", (Object)this.id()).add("LatestTimeSeriesDataPointFormsOutput", this.hasLatestTimeSeriesDataPointFormsOutput() ? this.latestTimeSeriesDataPointFormsOutput() : null).add("Listing", (Object)this.listing()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("OwningProjectId", (Object)this.owningProjectId()).add("ReadOnlyFormsOutput", this.hasReadOnlyFormsOutput() ? this.readOnlyFormsOutput() : null).add("Revision", (Object)this.revision()).add("TypeIdentifier", (Object)this.typeIdentifier()).add("TypeRevision", (Object)this.typeRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "externalIdentifier": {
                return Optional.ofNullable(clazz.cast(this.externalIdentifier()));
            }
            case "firstRevisionCreatedAt": {
                return Optional.ofNullable(clazz.cast(this.firstRevisionCreatedAt()));
            }
            case "firstRevisionCreatedBy": {
                return Optional.ofNullable(clazz.cast(this.firstRevisionCreatedBy()));
            }
            case "formsOutput": {
                return Optional.ofNullable(clazz.cast(this.formsOutput()));
            }
            case "glossaryTerms": {
                return Optional.ofNullable(clazz.cast(this.glossaryTerms()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "latestTimeSeriesDataPointFormsOutput": {
                return Optional.ofNullable(clazz.cast(this.latestTimeSeriesDataPointFormsOutput()));
            }
            case "listing": {
                return Optional.ofNullable(clazz.cast(this.listing()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "owningProjectId": {
                return Optional.ofNullable(clazz.cast(this.owningProjectId()));
            }
            case "readOnlyFormsOutput": {
                return Optional.ofNullable(clazz.cast(this.readOnlyFormsOutput()));
            }
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "typeIdentifier": {
                return Optional.ofNullable(clazz.cast(this.typeIdentifier()));
            }
            case "typeRevision": {
                return Optional.ofNullable(clazz.cast(this.typeRevision()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("externalIdentifier", EXTERNAL_IDENTIFIER_FIELD);
        map.put("firstRevisionCreatedAt", FIRST_REVISION_CREATED_AT_FIELD);
        map.put("firstRevisionCreatedBy", FIRST_REVISION_CREATED_BY_FIELD);
        map.put("formsOutput", FORMS_OUTPUT_FIELD);
        map.put("glossaryTerms", GLOSSARY_TERMS_FIELD);
        map.put("id", ID_FIELD);
        map.put("latestTimeSeriesDataPointFormsOutput", LATEST_TIME_SERIES_DATA_POINT_FORMS_OUTPUT_FIELD);
        map.put("listing", LISTING_FIELD);
        map.put("name", NAME_FIELD);
        map.put("owningProjectId", OWNING_PROJECT_ID_FIELD);
        map.put("readOnlyFormsOutput", READ_ONLY_FORMS_OUTPUT_FIELD);
        map.put("revision", REVISION_FIELD);
        map.put("typeIdentifier", TYPE_IDENTIFIER_FIELD);
        map.put("typeRevision", TYPE_REVISION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAssetResponse, T> g) {
        return obj -> g.apply((GetAssetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String createdBy;
        private String description;
        private String domainId;
        private String externalIdentifier;
        private Instant firstRevisionCreatedAt;
        private String firstRevisionCreatedBy;
        private List<FormOutput> formsOutput = DefaultSdkAutoConstructList.getInstance();
        private List<String> glossaryTerms = DefaultSdkAutoConstructList.getInstance();
        private String id;
        private List<TimeSeriesDataPointSummaryFormOutput> latestTimeSeriesDataPointFormsOutput = DefaultSdkAutoConstructList.getInstance();
        private AssetListingDetails listing;
        private String name;
        private String owningProjectId;
        private List<FormOutput> readOnlyFormsOutput = DefaultSdkAutoConstructList.getInstance();
        private String revision;
        private String typeIdentifier;
        private String typeRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssetResponse model) {
            super(model);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.description(model.description);
            this.domainId(model.domainId);
            this.externalIdentifier(model.externalIdentifier);
            this.firstRevisionCreatedAt(model.firstRevisionCreatedAt);
            this.firstRevisionCreatedBy(model.firstRevisionCreatedBy);
            this.formsOutput(model.formsOutput);
            this.glossaryTerms(model.glossaryTerms);
            this.id(model.id);
            this.latestTimeSeriesDataPointFormsOutput(model.latestTimeSeriesDataPointFormsOutput);
            this.listing(model.listing);
            this.name(model.name);
            this.owningProjectId(model.owningProjectId);
            this.readOnlyFormsOutput(model.readOnlyFormsOutput);
            this.revision(model.revision);
            this.typeIdentifier(model.typeIdentifier);
            this.typeRevision(model.typeRevision);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getExternalIdentifier() {
            return this.externalIdentifier;
        }

        public final void setExternalIdentifier(String externalIdentifier) {
            this.externalIdentifier = externalIdentifier;
        }

        @Override
        public final Builder externalIdentifier(String externalIdentifier) {
            this.externalIdentifier = externalIdentifier;
            return this;
        }

        public final Instant getFirstRevisionCreatedAt() {
            return this.firstRevisionCreatedAt;
        }

        public final void setFirstRevisionCreatedAt(Instant firstRevisionCreatedAt) {
            this.firstRevisionCreatedAt = firstRevisionCreatedAt;
        }

        @Override
        public final Builder firstRevisionCreatedAt(Instant firstRevisionCreatedAt) {
            this.firstRevisionCreatedAt = firstRevisionCreatedAt;
            return this;
        }

        public final String getFirstRevisionCreatedBy() {
            return this.firstRevisionCreatedBy;
        }

        public final void setFirstRevisionCreatedBy(String firstRevisionCreatedBy) {
            this.firstRevisionCreatedBy = firstRevisionCreatedBy;
        }

        @Override
        public final Builder firstRevisionCreatedBy(String firstRevisionCreatedBy) {
            this.firstRevisionCreatedBy = firstRevisionCreatedBy;
            return this;
        }

        public final List<FormOutput.Builder> getFormsOutput() {
            List<FormOutput.Builder> result = FormOutputListCopier.copyToBuilder(this.formsOutput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFormsOutput(Collection<FormOutput.BuilderImpl> formsOutput) {
            this.formsOutput = FormOutputListCopier.copyFromBuilder(formsOutput);
        }

        @Override
        public final Builder formsOutput(Collection<FormOutput> formsOutput) {
            this.formsOutput = FormOutputListCopier.copy(formsOutput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formsOutput(FormOutput ... formsOutput) {
            this.formsOutput(Arrays.asList(formsOutput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formsOutput(Consumer<FormOutput.Builder> ... formsOutput) {
            this.formsOutput(Stream.of(formsOutput).map(c -> (FormOutput)((FormOutput.Builder)FormOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getGlossaryTerms() {
            if (this.glossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.glossaryTerms;
        }

        public final void setGlossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(String ... glossaryTerms) {
            this.glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<TimeSeriesDataPointSummaryFormOutput.Builder> getLatestTimeSeriesDataPointFormsOutput() {
            List<TimeSeriesDataPointSummaryFormOutput.Builder> result = TimeSeriesDataPointSummaryFormOutputListCopier.copyToBuilder(this.latestTimeSeriesDataPointFormsOutput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLatestTimeSeriesDataPointFormsOutput(Collection<TimeSeriesDataPointSummaryFormOutput.BuilderImpl> latestTimeSeriesDataPointFormsOutput) {
            this.latestTimeSeriesDataPointFormsOutput = TimeSeriesDataPointSummaryFormOutputListCopier.copyFromBuilder(latestTimeSeriesDataPointFormsOutput);
        }

        @Override
        public final Builder latestTimeSeriesDataPointFormsOutput(Collection<TimeSeriesDataPointSummaryFormOutput> latestTimeSeriesDataPointFormsOutput) {
            this.latestTimeSeriesDataPointFormsOutput = TimeSeriesDataPointSummaryFormOutputListCopier.copy(latestTimeSeriesDataPointFormsOutput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder latestTimeSeriesDataPointFormsOutput(TimeSeriesDataPointSummaryFormOutput ... latestTimeSeriesDataPointFormsOutput) {
            this.latestTimeSeriesDataPointFormsOutput(Arrays.asList(latestTimeSeriesDataPointFormsOutput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder latestTimeSeriesDataPointFormsOutput(Consumer<TimeSeriesDataPointSummaryFormOutput.Builder> ... latestTimeSeriesDataPointFormsOutput) {
            this.latestTimeSeriesDataPointFormsOutput(Stream.of(latestTimeSeriesDataPointFormsOutput).map(c -> (TimeSeriesDataPointSummaryFormOutput)((TimeSeriesDataPointSummaryFormOutput.Builder)TimeSeriesDataPointSummaryFormOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AssetListingDetails.Builder getListing() {
            return this.listing != null ? this.listing.toBuilder() : null;
        }

        public final void setListing(AssetListingDetails.BuilderImpl listing) {
            this.listing = listing != null ? listing.build() : null;
        }

        @Override
        public final Builder listing(AssetListingDetails listing) {
            this.listing = listing;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwningProjectId() {
            return this.owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        public final List<FormOutput.Builder> getReadOnlyFormsOutput() {
            List<FormOutput.Builder> result = FormOutputListCopier.copyToBuilder(this.readOnlyFormsOutput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReadOnlyFormsOutput(Collection<FormOutput.BuilderImpl> readOnlyFormsOutput) {
            this.readOnlyFormsOutput = FormOutputListCopier.copyFromBuilder(readOnlyFormsOutput);
        }

        @Override
        public final Builder readOnlyFormsOutput(Collection<FormOutput> readOnlyFormsOutput) {
            this.readOnlyFormsOutput = FormOutputListCopier.copy(readOnlyFormsOutput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readOnlyFormsOutput(FormOutput ... readOnlyFormsOutput) {
            this.readOnlyFormsOutput(Arrays.asList(readOnlyFormsOutput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readOnlyFormsOutput(Consumer<FormOutput.Builder> ... readOnlyFormsOutput) {
            this.readOnlyFormsOutput(Stream.of(readOnlyFormsOutput).map(c -> (FormOutput)((FormOutput.Builder)FormOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRevision() {
            return this.revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final String getTypeIdentifier() {
            return this.typeIdentifier;
        }

        public final void setTypeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
        }

        @Override
        public final Builder typeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
            return this;
        }

        public final String getTypeRevision() {
            return this.typeRevision;
        }

        public final void setTypeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
        }

        @Override
        public final Builder typeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
            return this;
        }

        @Override
        public GetAssetResponse build() {
            return new GetAssetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAssetResponse> {
        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder description(String var1);

        public Builder domainId(String var1);

        public Builder externalIdentifier(String var1);

        public Builder firstRevisionCreatedAt(Instant var1);

        public Builder firstRevisionCreatedBy(String var1);

        public Builder formsOutput(Collection<FormOutput> var1);

        public Builder formsOutput(FormOutput ... var1);

        public Builder formsOutput(Consumer<FormOutput.Builder> ... var1);

        public Builder glossaryTerms(Collection<String> var1);

        public Builder glossaryTerms(String ... var1);

        public Builder id(String var1);

        public Builder latestTimeSeriesDataPointFormsOutput(Collection<TimeSeriesDataPointSummaryFormOutput> var1);

        public Builder latestTimeSeriesDataPointFormsOutput(TimeSeriesDataPointSummaryFormOutput ... var1);

        public Builder latestTimeSeriesDataPointFormsOutput(Consumer<TimeSeriesDataPointSummaryFormOutput.Builder> ... var1);

        public Builder listing(AssetListingDetails var1);

        default public Builder listing(Consumer<AssetListingDetails.Builder> listing) {
            return this.listing((AssetListingDetails)((AssetListingDetails.Builder)AssetListingDetails.builder().applyMutation(listing)).build());
        }

        public Builder name(String var1);

        public Builder owningProjectId(String var1);

        public Builder readOnlyFormsOutput(Collection<FormOutput> var1);

        public Builder readOnlyFormsOutput(FormOutput ... var1);

        public Builder readOnlyFormsOutput(Consumer<FormOutput.Builder> ... var1);

        public Builder revision(String var1);

        public Builder typeIdentifier(String var1);

        public Builder typeRevision(String var1);
    }
}

