/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.AccountPoolListCopier;
import software.amazon.awssdk.services.datazone.model.AwsAccount;
import software.amazon.awssdk.services.datazone.model.DeploymentMode;
import software.amazon.awssdk.services.datazone.model.EnvironmentConfigurationParametersDetails;
import software.amazon.awssdk.services.datazone.model.Region;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentConfiguration> {
    private static final SdkField<List<String>> ACCOUNT_POOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountPools").getter(EnvironmentConfiguration.getter(EnvironmentConfiguration::accountPools)).setter(EnvironmentConfiguration.setter(Builder::accountPools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountPools").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AwsAccount> AWS_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsAccount").getter(EnvironmentConfiguration.getter(EnvironmentConfiguration::awsAccount)).setter(EnvironmentConfiguration.setter(Builder::awsAccount)).constructor(AwsAccount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccount").build()}).build();
    private static final SdkField<Region> AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsRegion").getter(EnvironmentConfiguration.getter(EnvironmentConfiguration::awsRegion)).setter(EnvironmentConfiguration.setter(Builder::awsRegion)).constructor(Region::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsRegion").build()}).build();
    private static final SdkField<EnvironmentConfigurationParametersDetails> CONFIGURATION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configurationParameters").getter(EnvironmentConfiguration.getter(EnvironmentConfiguration::configurationParameters)).setter(EnvironmentConfiguration.setter(Builder::configurationParameters)).constructor(EnvironmentConfigurationParametersDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationParameters").build()}).build();
    private static final SdkField<String> DEPLOYMENT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentMode").getter(EnvironmentConfiguration.getter(EnvironmentConfiguration::deploymentModeAsString)).setter(EnvironmentConfiguration.setter(Builder::deploymentMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentMode").build()}).build();
    private static final SdkField<Integer> DEPLOYMENT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("deploymentOrder").getter(EnvironmentConfiguration.getter(EnvironmentConfiguration::deploymentOrder)).setter(EnvironmentConfiguration.setter(Builder::deploymentOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentOrder").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(EnvironmentConfiguration.getter(EnvironmentConfiguration::description)).setter(EnvironmentConfiguration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENVIRONMENT_BLUEPRINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentBlueprintId").getter(EnvironmentConfiguration.getter(EnvironmentConfiguration::environmentBlueprintId)).setter(EnvironmentConfiguration.setter(Builder::environmentBlueprintId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentBlueprintId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(EnvironmentConfiguration.getter(EnvironmentConfiguration::id)).setter(EnvironmentConfiguration.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(EnvironmentConfiguration.getter(EnvironmentConfiguration::name)).setter(EnvironmentConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_POOLS_FIELD, AWS_ACCOUNT_FIELD, AWS_REGION_FIELD, CONFIGURATION_PARAMETERS_FIELD, DEPLOYMENT_MODE_FIELD, DEPLOYMENT_ORDER_FIELD, DESCRIPTION_FIELD, ENVIRONMENT_BLUEPRINT_ID_FIELD, ID_FIELD, NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnvironmentConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> accountPools;
    private final AwsAccount awsAccount;
    private final Region awsRegion;
    private final EnvironmentConfigurationParametersDetails configurationParameters;
    private final String deploymentMode;
    private final Integer deploymentOrder;
    private final String description;
    private final String environmentBlueprintId;
    private final String id;
    private final String name;

    private EnvironmentConfiguration(BuilderImpl builder) {
        this.accountPools = builder.accountPools;
        this.awsAccount = builder.awsAccount;
        this.awsRegion = builder.awsRegion;
        this.configurationParameters = builder.configurationParameters;
        this.deploymentMode = builder.deploymentMode;
        this.deploymentOrder = builder.deploymentOrder;
        this.description = builder.description;
        this.environmentBlueprintId = builder.environmentBlueprintId;
        this.id = builder.id;
        this.name = builder.name;
    }

    public final boolean hasAccountPools() {
        return this.accountPools != null && !(this.accountPools instanceof SdkAutoConstructList);
    }

    public final List<String> accountPools() {
        return this.accountPools;
    }

    public final AwsAccount awsAccount() {
        return this.awsAccount;
    }

    public final Region awsRegion() {
        return this.awsRegion;
    }

    public final EnvironmentConfigurationParametersDetails configurationParameters() {
        return this.configurationParameters;
    }

    public final DeploymentMode deploymentMode() {
        return DeploymentMode.fromValue(this.deploymentMode);
    }

    public final String deploymentModeAsString() {
        return this.deploymentMode;
    }

    public final Integer deploymentOrder() {
        return this.deploymentOrder;
    }

    public final String description() {
        return this.description;
    }

    public final String environmentBlueprintId() {
        return this.environmentBlueprintId;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountPools() ? this.accountPools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentBlueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentConfiguration)) {
            return false;
        }
        EnvironmentConfiguration other = (EnvironmentConfiguration)obj;
        return this.hasAccountPools() == other.hasAccountPools() && Objects.equals(this.accountPools(), other.accountPools()) && Objects.equals(this.awsAccount(), other.awsAccount()) && Objects.equals(this.awsRegion(), other.awsRegion()) && Objects.equals(this.configurationParameters(), other.configurationParameters()) && Objects.equals(this.deploymentModeAsString(), other.deploymentModeAsString()) && Objects.equals(this.deploymentOrder(), other.deploymentOrder()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.environmentBlueprintId(), other.environmentBlueprintId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"EnvironmentConfiguration").add("AccountPools", this.hasAccountPools() ? this.accountPools() : null).add("AwsAccount", (Object)this.awsAccount()).add("AwsRegion", (Object)this.awsRegion()).add("ConfigurationParameters", (Object)this.configurationParameters()).add("DeploymentMode", (Object)this.deploymentModeAsString()).add("DeploymentOrder", (Object)this.deploymentOrder()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("EnvironmentBlueprintId", (Object)this.environmentBlueprintId()).add("Id", (Object)(this.id() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountPools": {
                return Optional.ofNullable(clazz.cast(this.accountPools()));
            }
            case "awsAccount": {
                return Optional.ofNullable(clazz.cast(this.awsAccount()));
            }
            case "awsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
            case "configurationParameters": {
                return Optional.ofNullable(clazz.cast(this.configurationParameters()));
            }
            case "deploymentMode": {
                return Optional.ofNullable(clazz.cast(this.deploymentModeAsString()));
            }
            case "deploymentOrder": {
                return Optional.ofNullable(clazz.cast(this.deploymentOrder()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "environmentBlueprintId": {
                return Optional.ofNullable(clazz.cast(this.environmentBlueprintId()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountPools", ACCOUNT_POOLS_FIELD);
        map.put("awsAccount", AWS_ACCOUNT_FIELD);
        map.put("awsRegion", AWS_REGION_FIELD);
        map.put("configurationParameters", CONFIGURATION_PARAMETERS_FIELD);
        map.put("deploymentMode", DEPLOYMENT_MODE_FIELD);
        map.put("deploymentOrder", DEPLOYMENT_ORDER_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("environmentBlueprintId", ENVIRONMENT_BLUEPRINT_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentConfiguration, T> g) {
        return obj -> g.apply((EnvironmentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> accountPools = DefaultSdkAutoConstructList.getInstance();
        private AwsAccount awsAccount;
        private Region awsRegion;
        private EnvironmentConfigurationParametersDetails configurationParameters;
        private String deploymentMode;
        private Integer deploymentOrder;
        private String description;
        private String environmentBlueprintId;
        private String id;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentConfiguration model) {
            this.accountPools(model.accountPools);
            this.awsAccount(model.awsAccount);
            this.awsRegion(model.awsRegion);
            this.configurationParameters(model.configurationParameters);
            this.deploymentMode(model.deploymentMode);
            this.deploymentOrder(model.deploymentOrder);
            this.description(model.description);
            this.environmentBlueprintId(model.environmentBlueprintId);
            this.id(model.id);
            this.name(model.name);
        }

        public final Collection<String> getAccountPools() {
            if (this.accountPools instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountPools;
        }

        public final void setAccountPools(Collection<String> accountPools) {
            this.accountPools = AccountPoolListCopier.copy(accountPools);
        }

        @Override
        public final Builder accountPools(Collection<String> accountPools) {
            this.accountPools = AccountPoolListCopier.copy(accountPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountPools(String ... accountPools) {
            this.accountPools(Arrays.asList(accountPools));
            return this;
        }

        public final AwsAccount.Builder getAwsAccount() {
            return this.awsAccount != null ? this.awsAccount.toBuilder() : null;
        }

        public final void setAwsAccount(AwsAccount.BuilderImpl awsAccount) {
            this.awsAccount = awsAccount != null ? awsAccount.build() : null;
        }

        @Override
        public final Builder awsAccount(AwsAccount awsAccount) {
            this.awsAccount = awsAccount;
            return this;
        }

        public final Region.Builder getAwsRegion() {
            return this.awsRegion != null ? this.awsRegion.toBuilder() : null;
        }

        public final void setAwsRegion(Region.BuilderImpl awsRegion) {
            this.awsRegion = awsRegion != null ? awsRegion.build() : null;
        }

        @Override
        public final Builder awsRegion(Region awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final EnvironmentConfigurationParametersDetails.Builder getConfigurationParameters() {
            return this.configurationParameters != null ? this.configurationParameters.toBuilder() : null;
        }

        public final void setConfigurationParameters(EnvironmentConfigurationParametersDetails.BuilderImpl configurationParameters) {
            this.configurationParameters = configurationParameters != null ? configurationParameters.build() : null;
        }

        @Override
        public final Builder configurationParameters(EnvironmentConfigurationParametersDetails configurationParameters) {
            this.configurationParameters = configurationParameters;
            return this;
        }

        public final String getDeploymentMode() {
            return this.deploymentMode;
        }

        public final void setDeploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
        }

        @Override
        public final Builder deploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
            return this;
        }

        @Override
        public final Builder deploymentMode(DeploymentMode deploymentMode) {
            this.deploymentMode(deploymentMode == null ? null : deploymentMode.toString());
            return this;
        }

        public final Integer getDeploymentOrder() {
            return this.deploymentOrder;
        }

        public final void setDeploymentOrder(Integer deploymentOrder) {
            this.deploymentOrder = deploymentOrder;
        }

        @Override
        public final Builder deploymentOrder(Integer deploymentOrder) {
            this.deploymentOrder = deploymentOrder;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEnvironmentBlueprintId() {
            return this.environmentBlueprintId;
        }

        public final void setEnvironmentBlueprintId(String environmentBlueprintId) {
            this.environmentBlueprintId = environmentBlueprintId;
        }

        @Override
        public final Builder environmentBlueprintId(String environmentBlueprintId) {
            this.environmentBlueprintId = environmentBlueprintId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public EnvironmentConfiguration build() {
            return new EnvironmentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentConfiguration> {
        public Builder accountPools(Collection<String> var1);

        public Builder accountPools(String ... var1);

        public Builder awsAccount(AwsAccount var1);

        default public Builder awsAccount(Consumer<AwsAccount.Builder> awsAccount) {
            return this.awsAccount((AwsAccount)((AwsAccount.Builder)AwsAccount.builder().applyMutation(awsAccount)).build());
        }

        public Builder awsRegion(Region var1);

        default public Builder awsRegion(Consumer<Region.Builder> awsRegion) {
            return this.awsRegion((Region)((Region.Builder)Region.builder().applyMutation(awsRegion)).build());
        }

        public Builder configurationParameters(EnvironmentConfigurationParametersDetails var1);

        default public Builder configurationParameters(Consumer<EnvironmentConfigurationParametersDetails.Builder> configurationParameters) {
            return this.configurationParameters((EnvironmentConfigurationParametersDetails)((EnvironmentConfigurationParametersDetails.Builder)EnvironmentConfigurationParametersDetails.builder().applyMutation(configurationParameters)).build());
        }

        public Builder deploymentMode(String var1);

        public Builder deploymentMode(DeploymentMode var1);

        public Builder deploymentOrder(Integer var1);

        public Builder description(String var1);

        public Builder environmentBlueprintId(String var1);

        public Builder id(String var1);

        public Builder name(String var1);
    }
}

