/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataSourceErrorType {
    ACCESS_DENIED_EXCEPTION("ACCESS_DENIED_EXCEPTION"),
    CONFLICT_EXCEPTION("CONFLICT_EXCEPTION"),
    INTERNAL_SERVER_EXCEPTION("INTERNAL_SERVER_EXCEPTION"),
    RESOURCE_NOT_FOUND_EXCEPTION("RESOURCE_NOT_FOUND_EXCEPTION"),
    SERVICE_QUOTA_EXCEEDED_EXCEPTION("SERVICE_QUOTA_EXCEEDED_EXCEPTION"),
    THROTTLING_EXCEPTION("THROTTLING_EXCEPTION"),
    VALIDATION_EXCEPTION("VALIDATION_EXCEPTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataSourceErrorType> VALUE_MAP;
    private final String value;

    private DataSourceErrorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataSourceErrorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataSourceErrorType> knownValues() {
        EnumSet<DataSourceErrorType> knownValues = EnumSet.allOf(DataSourceErrorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataSourceErrorType.class, DataSourceErrorType::toString);
    }
}

