/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.RuleDetail;
import software.amazon.awssdk.services.datazone.model.RuleScope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRuleRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, UpdateRuleRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateRuleRequest.getter(UpdateRuleRequest::description)).setter(UpdateRuleRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<RuleDetail> DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("detail").getter(UpdateRuleRequest.getter(UpdateRuleRequest::detail)).setter(UpdateRuleRequest.setter(Builder::detail)).constructor(RuleDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detail").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(UpdateRuleRequest.getter(UpdateRuleRequest::domainIdentifier)).setter(UpdateRuleRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(UpdateRuleRequest.getter(UpdateRuleRequest::identifier)).setter(UpdateRuleRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()}).build();
    private static final SdkField<Boolean> INCLUDE_CHILD_DOMAIN_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeChildDomainUnits").getter(UpdateRuleRequest.getter(UpdateRuleRequest::includeChildDomainUnits)).setter(UpdateRuleRequest.setter(Builder::includeChildDomainUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeChildDomainUnits").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateRuleRequest.getter(UpdateRuleRequest::name)).setter(UpdateRuleRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<RuleScope> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scope").getter(UpdateRuleRequest.getter(UpdateRuleRequest::scope)).setter(UpdateRuleRequest.setter(Builder::scope)).constructor(RuleScope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DETAIL_FIELD, DOMAIN_IDENTIFIER_FIELD, IDENTIFIER_FIELD, INCLUDE_CHILD_DOMAIN_UNITS_FIELD, NAME_FIELD, SCOPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateRuleRequest.memberNameToFieldInitializer();
    private final String description;
    private final RuleDetail detail;
    private final String domainIdentifier;
    private final String identifier;
    private final Boolean includeChildDomainUnits;
    private final String name;
    private final RuleScope scope;

    private UpdateRuleRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.detail = builder.detail;
        this.domainIdentifier = builder.domainIdentifier;
        this.identifier = builder.identifier;
        this.includeChildDomainUnits = builder.includeChildDomainUnits;
        this.name = builder.name;
        this.scope = builder.scope;
    }

    public final String description() {
        return this.description;
    }

    public final RuleDetail detail() {
        return this.detail;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final Boolean includeChildDomainUnits() {
        return this.includeChildDomainUnits;
    }

    public final String name() {
        return this.name;
    }

    public final RuleScope scope() {
        return this.scope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.detail());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeChildDomainUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRuleRequest)) {
            return false;
        }
        UpdateRuleRequest other = (UpdateRuleRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.detail(), other.detail()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.includeChildDomainUnits(), other.includeChildDomainUnits()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.scope(), other.scope());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRuleRequest").add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Detail", (Object)this.detail()).add("DomainIdentifier", (Object)this.domainIdentifier()).add("Identifier", (Object)this.identifier()).add("IncludeChildDomainUnits", (Object)this.includeChildDomainUnits()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Scope", (Object)this.scope()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "detail": {
                return Optional.ofNullable(clazz.cast(this.detail()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "includeChildDomainUnits": {
                return Optional.ofNullable(clazz.cast(this.includeChildDomainUnits()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("detail", DETAIL_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("includeChildDomainUnits", INCLUDE_CHILD_DOMAIN_UNITS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("scope", SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRuleRequest, T> g) {
        return obj -> g.apply((UpdateRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String description;
        private RuleDetail detail;
        private String domainIdentifier;
        private String identifier;
        private Boolean includeChildDomainUnits;
        private String name;
        private RuleScope scope;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRuleRequest model) {
            super(model);
            this.description(model.description);
            this.detail(model.detail);
            this.domainIdentifier(model.domainIdentifier);
            this.identifier(model.identifier);
            this.includeChildDomainUnits(model.includeChildDomainUnits);
            this.name(model.name);
            this.scope(model.scope);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final RuleDetail.Builder getDetail() {
            return this.detail != null ? this.detail.toBuilder() : null;
        }

        public final void setDetail(RuleDetail.BuilderImpl detail) {
            this.detail = detail != null ? detail.build() : null;
        }

        @Override
        public final Builder detail(RuleDetail detail) {
            this.detail = detail;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Boolean getIncludeChildDomainUnits() {
            return this.includeChildDomainUnits;
        }

        public final void setIncludeChildDomainUnits(Boolean includeChildDomainUnits) {
            this.includeChildDomainUnits = includeChildDomainUnits;
        }

        @Override
        public final Builder includeChildDomainUnits(Boolean includeChildDomainUnits) {
            this.includeChildDomainUnits = includeChildDomainUnits;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RuleScope.Builder getScope() {
            return this.scope != null ? this.scope.toBuilder() : null;
        }

        public final void setScope(RuleScope.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        @Override
        public final Builder scope(RuleScope scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRuleRequest build() {
            return new UpdateRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRuleRequest> {
        public Builder description(String var1);

        public Builder detail(RuleDetail var1);

        default public Builder detail(Consumer<RuleDetail.Builder> detail) {
            return this.detail((RuleDetail)((RuleDetail.Builder)RuleDetail.builder().applyMutation(detail)).build());
        }

        public Builder domainIdentifier(String var1);

        public Builder identifier(String var1);

        public Builder includeChildDomainUnits(Boolean var1);

        public Builder name(String var1);

        public Builder scope(RuleScope var1);

        default public Builder scope(Consumer<RuleScope.Builder> scope) {
            return this.scope((RuleScope)((RuleScope.Builder)RuleScope.builder().applyMutation(scope)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

