/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.GovernanceType;
import software.amazon.awssdk.services.datazone.model.UsernamePassword;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SparkEmrPropertiesOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SparkEmrPropertiesOutput> {
    private static final SdkField<String> COMPUTE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computeArn").getter(SparkEmrPropertiesOutput.getter(SparkEmrPropertiesOutput::computeArn)).setter(SparkEmrPropertiesOutput.setter(Builder::computeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeArn").build()}).build();
    private static final SdkField<UsernamePassword> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("credentials").getter(SparkEmrPropertiesOutput.getter(SparkEmrPropertiesOutput::credentials)).setter(SparkEmrPropertiesOutput.setter(Builder::credentials)).constructor(UsernamePassword::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentials").build()}).build();
    private static final SdkField<Instant> CREDENTIALS_EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("credentialsExpiration").getter(SparkEmrPropertiesOutput.getter(SparkEmrPropertiesOutput::credentialsExpiration)).setter(SparkEmrPropertiesOutput.setter(Builder::credentialsExpiration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsExpiration").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> GOVERNANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("governanceType").getter(SparkEmrPropertiesOutput.getter(SparkEmrPropertiesOutput::governanceTypeAsString)).setter(SparkEmrPropertiesOutput.setter(Builder::governanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("governanceType").build()}).build();
    private static final SdkField<String> INSTANCE_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceProfileArn").getter(SparkEmrPropertiesOutput.getter(SparkEmrPropertiesOutput::instanceProfileArn)).setter(SparkEmrPropertiesOutput.setter(Builder::instanceProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceProfileArn").build()}).build();
    private static final SdkField<String> JAVA_VIRTUAL_ENV_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("javaVirtualEnv").getter(SparkEmrPropertiesOutput.getter(SparkEmrPropertiesOutput::javaVirtualEnv)).setter(SparkEmrPropertiesOutput.setter(Builder::javaVirtualEnv)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("javaVirtualEnv").build()}).build();
    private static final SdkField<String> LIVY_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("livyEndpoint").getter(SparkEmrPropertiesOutput.getter(SparkEmrPropertiesOutput::livyEndpoint)).setter(SparkEmrPropertiesOutput.setter(Builder::livyEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("livyEndpoint").build()}).build();
    private static final SdkField<String> LOG_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logUri").getter(SparkEmrPropertiesOutput.getter(SparkEmrPropertiesOutput::logUri)).setter(SparkEmrPropertiesOutput.setter(Builder::logUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logUri").build()}).build();
    private static final SdkField<String> PYTHON_VIRTUAL_ENV_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pythonVirtualEnv").getter(SparkEmrPropertiesOutput.getter(SparkEmrPropertiesOutput::pythonVirtualEnv)).setter(SparkEmrPropertiesOutput.setter(Builder::pythonVirtualEnv)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pythonVirtualEnv").build()}).build();
    private static final SdkField<String> RUNTIME_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runtimeRole").getter(SparkEmrPropertiesOutput.getter(SparkEmrPropertiesOutput::runtimeRole)).setter(SparkEmrPropertiesOutput.setter(Builder::runtimeRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeRole").build()}).build();
    private static final SdkField<String> TRUSTED_CERTIFICATES_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trustedCertificatesS3Uri").getter(SparkEmrPropertiesOutput.getter(SparkEmrPropertiesOutput::trustedCertificatesS3Uri)).setter(SparkEmrPropertiesOutput.setter(Builder::trustedCertificatesS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustedCertificatesS3Uri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_ARN_FIELD, CREDENTIALS_FIELD, CREDENTIALS_EXPIRATION_FIELD, GOVERNANCE_TYPE_FIELD, INSTANCE_PROFILE_ARN_FIELD, JAVA_VIRTUAL_ENV_FIELD, LIVY_ENDPOINT_FIELD, LOG_URI_FIELD, PYTHON_VIRTUAL_ENV_FIELD, RUNTIME_ROLE_FIELD, TRUSTED_CERTIFICATES_S3_URI_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SparkEmrPropertiesOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String computeArn;
    private final UsernamePassword credentials;
    private final Instant credentialsExpiration;
    private final String governanceType;
    private final String instanceProfileArn;
    private final String javaVirtualEnv;
    private final String livyEndpoint;
    private final String logUri;
    private final String pythonVirtualEnv;
    private final String runtimeRole;
    private final String trustedCertificatesS3Uri;

    private SparkEmrPropertiesOutput(BuilderImpl builder) {
        this.computeArn = builder.computeArn;
        this.credentials = builder.credentials;
        this.credentialsExpiration = builder.credentialsExpiration;
        this.governanceType = builder.governanceType;
        this.instanceProfileArn = builder.instanceProfileArn;
        this.javaVirtualEnv = builder.javaVirtualEnv;
        this.livyEndpoint = builder.livyEndpoint;
        this.logUri = builder.logUri;
        this.pythonVirtualEnv = builder.pythonVirtualEnv;
        this.runtimeRole = builder.runtimeRole;
        this.trustedCertificatesS3Uri = builder.trustedCertificatesS3Uri;
    }

    public final String computeArn() {
        return this.computeArn;
    }

    public final UsernamePassword credentials() {
        return this.credentials;
    }

    public final Instant credentialsExpiration() {
        return this.credentialsExpiration;
    }

    public final GovernanceType governanceType() {
        return GovernanceType.fromValue(this.governanceType);
    }

    public final String governanceTypeAsString() {
        return this.governanceType;
    }

    public final String instanceProfileArn() {
        return this.instanceProfileArn;
    }

    public final String javaVirtualEnv() {
        return this.javaVirtualEnv;
    }

    public final String livyEndpoint() {
        return this.livyEndpoint;
    }

    public final String logUri() {
        return this.logUri;
    }

    public final String pythonVirtualEnv() {
        return this.pythonVirtualEnv;
    }

    public final String runtimeRole() {
        return this.runtimeRole;
    }

    public final String trustedCertificatesS3Uri() {
        return this.trustedCertificatesS3Uri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.computeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialsExpiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.governanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.javaVirtualEnv());
        hashCode = 31 * hashCode + Objects.hashCode(this.livyEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.logUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.pythonVirtualEnv());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustedCertificatesS3Uri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SparkEmrPropertiesOutput)) {
            return false;
        }
        SparkEmrPropertiesOutput other = (SparkEmrPropertiesOutput)obj;
        return Objects.equals(this.computeArn(), other.computeArn()) && Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.credentialsExpiration(), other.credentialsExpiration()) && Objects.equals(this.governanceTypeAsString(), other.governanceTypeAsString()) && Objects.equals(this.instanceProfileArn(), other.instanceProfileArn()) && Objects.equals(this.javaVirtualEnv(), other.javaVirtualEnv()) && Objects.equals(this.livyEndpoint(), other.livyEndpoint()) && Objects.equals(this.logUri(), other.logUri()) && Objects.equals(this.pythonVirtualEnv(), other.pythonVirtualEnv()) && Objects.equals(this.runtimeRole(), other.runtimeRole()) && Objects.equals(this.trustedCertificatesS3Uri(), other.trustedCertificatesS3Uri());
    }

    public final String toString() {
        return ToString.builder((String)"SparkEmrPropertiesOutput").add("ComputeArn", (Object)this.computeArn()).add("Credentials", (Object)(this.credentials() == null ? null : "*** Sensitive Data Redacted ***")).add("CredentialsExpiration", (Object)this.credentialsExpiration()).add("GovernanceType", (Object)this.governanceTypeAsString()).add("InstanceProfileArn", (Object)this.instanceProfileArn()).add("JavaVirtualEnv", (Object)this.javaVirtualEnv()).add("LivyEndpoint", (Object)this.livyEndpoint()).add("LogUri", (Object)this.logUri()).add("PythonVirtualEnv", (Object)this.pythonVirtualEnv()).add("RuntimeRole", (Object)this.runtimeRole()).add("TrustedCertificatesS3Uri", (Object)this.trustedCertificatesS3Uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computeArn": {
                return Optional.ofNullable(clazz.cast(this.computeArn()));
            }
            case "credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "credentialsExpiration": {
                return Optional.ofNullable(clazz.cast(this.credentialsExpiration()));
            }
            case "governanceType": {
                return Optional.ofNullable(clazz.cast(this.governanceTypeAsString()));
            }
            case "instanceProfileArn": {
                return Optional.ofNullable(clazz.cast(this.instanceProfileArn()));
            }
            case "javaVirtualEnv": {
                return Optional.ofNullable(clazz.cast(this.javaVirtualEnv()));
            }
            case "livyEndpoint": {
                return Optional.ofNullable(clazz.cast(this.livyEndpoint()));
            }
            case "logUri": {
                return Optional.ofNullable(clazz.cast(this.logUri()));
            }
            case "pythonVirtualEnv": {
                return Optional.ofNullable(clazz.cast(this.pythonVirtualEnv()));
            }
            case "runtimeRole": {
                return Optional.ofNullable(clazz.cast(this.runtimeRole()));
            }
            case "trustedCertificatesS3Uri": {
                return Optional.ofNullable(clazz.cast(this.trustedCertificatesS3Uri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("computeArn", COMPUTE_ARN_FIELD);
        map.put("credentials", CREDENTIALS_FIELD);
        map.put("credentialsExpiration", CREDENTIALS_EXPIRATION_FIELD);
        map.put("governanceType", GOVERNANCE_TYPE_FIELD);
        map.put("instanceProfileArn", INSTANCE_PROFILE_ARN_FIELD);
        map.put("javaVirtualEnv", JAVA_VIRTUAL_ENV_FIELD);
        map.put("livyEndpoint", LIVY_ENDPOINT_FIELD);
        map.put("logUri", LOG_URI_FIELD);
        map.put("pythonVirtualEnv", PYTHON_VIRTUAL_ENV_FIELD);
        map.put("runtimeRole", RUNTIME_ROLE_FIELD);
        map.put("trustedCertificatesS3Uri", TRUSTED_CERTIFICATES_S3_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SparkEmrPropertiesOutput, T> g) {
        return obj -> g.apply((SparkEmrPropertiesOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String computeArn;
        private UsernamePassword credentials;
        private Instant credentialsExpiration;
        private String governanceType;
        private String instanceProfileArn;
        private String javaVirtualEnv;
        private String livyEndpoint;
        private String logUri;
        private String pythonVirtualEnv;
        private String runtimeRole;
        private String trustedCertificatesS3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(SparkEmrPropertiesOutput model) {
            this.computeArn(model.computeArn);
            this.credentials(model.credentials);
            this.credentialsExpiration(model.credentialsExpiration);
            this.governanceType(model.governanceType);
            this.instanceProfileArn(model.instanceProfileArn);
            this.javaVirtualEnv(model.javaVirtualEnv);
            this.livyEndpoint(model.livyEndpoint);
            this.logUri(model.logUri);
            this.pythonVirtualEnv(model.pythonVirtualEnv);
            this.runtimeRole(model.runtimeRole);
            this.trustedCertificatesS3Uri(model.trustedCertificatesS3Uri);
        }

        public final String getComputeArn() {
            return this.computeArn;
        }

        public final void setComputeArn(String computeArn) {
            this.computeArn = computeArn;
        }

        @Override
        public final Builder computeArn(String computeArn) {
            this.computeArn = computeArn;
            return this;
        }

        public final UsernamePassword.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(UsernamePassword.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(UsernamePassword credentials) {
            this.credentials = credentials;
            return this;
        }

        public final Instant getCredentialsExpiration() {
            return this.credentialsExpiration;
        }

        public final void setCredentialsExpiration(Instant credentialsExpiration) {
            this.credentialsExpiration = credentialsExpiration;
        }

        @Override
        public final Builder credentialsExpiration(Instant credentialsExpiration) {
            this.credentialsExpiration = credentialsExpiration;
            return this;
        }

        public final String getGovernanceType() {
            return this.governanceType;
        }

        public final void setGovernanceType(String governanceType) {
            this.governanceType = governanceType;
        }

        @Override
        public final Builder governanceType(String governanceType) {
            this.governanceType = governanceType;
            return this;
        }

        @Override
        public final Builder governanceType(GovernanceType governanceType) {
            this.governanceType(governanceType == null ? null : governanceType.toString());
            return this;
        }

        public final String getInstanceProfileArn() {
            return this.instanceProfileArn;
        }

        public final void setInstanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
        }

        @Override
        public final Builder instanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
            return this;
        }

        public final String getJavaVirtualEnv() {
            return this.javaVirtualEnv;
        }

        public final void setJavaVirtualEnv(String javaVirtualEnv) {
            this.javaVirtualEnv = javaVirtualEnv;
        }

        @Override
        public final Builder javaVirtualEnv(String javaVirtualEnv) {
            this.javaVirtualEnv = javaVirtualEnv;
            return this;
        }

        public final String getLivyEndpoint() {
            return this.livyEndpoint;
        }

        public final void setLivyEndpoint(String livyEndpoint) {
            this.livyEndpoint = livyEndpoint;
        }

        @Override
        public final Builder livyEndpoint(String livyEndpoint) {
            this.livyEndpoint = livyEndpoint;
            return this;
        }

        public final String getLogUri() {
            return this.logUri;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final String getPythonVirtualEnv() {
            return this.pythonVirtualEnv;
        }

        public final void setPythonVirtualEnv(String pythonVirtualEnv) {
            this.pythonVirtualEnv = pythonVirtualEnv;
        }

        @Override
        public final Builder pythonVirtualEnv(String pythonVirtualEnv) {
            this.pythonVirtualEnv = pythonVirtualEnv;
            return this;
        }

        public final String getRuntimeRole() {
            return this.runtimeRole;
        }

        public final void setRuntimeRole(String runtimeRole) {
            this.runtimeRole = runtimeRole;
        }

        @Override
        public final Builder runtimeRole(String runtimeRole) {
            this.runtimeRole = runtimeRole;
            return this;
        }

        public final String getTrustedCertificatesS3Uri() {
            return this.trustedCertificatesS3Uri;
        }

        public final void setTrustedCertificatesS3Uri(String trustedCertificatesS3Uri) {
            this.trustedCertificatesS3Uri = trustedCertificatesS3Uri;
        }

        @Override
        public final Builder trustedCertificatesS3Uri(String trustedCertificatesS3Uri) {
            this.trustedCertificatesS3Uri = trustedCertificatesS3Uri;
            return this;
        }

        public SparkEmrPropertiesOutput build() {
            return new SparkEmrPropertiesOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SparkEmrPropertiesOutput> {
        public Builder computeArn(String var1);

        public Builder credentials(UsernamePassword var1);

        default public Builder credentials(Consumer<UsernamePassword.Builder> credentials) {
            return this.credentials((UsernamePassword)((UsernamePassword.Builder)UsernamePassword.builder().applyMutation(credentials)).build());
        }

        public Builder credentialsExpiration(Instant var1);

        public Builder governanceType(String var1);

        public Builder governanceType(GovernanceType var1);

        public Builder instanceProfileArn(String var1);

        public Builder javaVirtualEnv(String var1);

        public Builder livyEndpoint(String var1);

        public Builder logUri(String var1);

        public Builder pythonVirtualEnv(String var1);

        public Builder runtimeRole(String var1);

        public Builder trustedCertificatesS3Uri(String var1);
    }
}

