/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.AggregationOutputItem;
import software.amazon.awssdk.services.datazone.model.AggregationOutputItemsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregationOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregationOutput> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attribute").getter(AggregationOutput.getter(AggregationOutput::attribute)).setter(AggregationOutput.setter(Builder::attribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attribute").build()}).build();
    private static final SdkField<String> DISPLAY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayValue").getter(AggregationOutput.getter(AggregationOutput::displayValue)).setter(AggregationOutput.setter(Builder::displayValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayValue").build()}).build();
    private static final SdkField<List<AggregationOutputItem>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("items").getter(AggregationOutput.getter(AggregationOutput::items)).setter(AggregationOutput.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregationOutputItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD, DISPLAY_VALUE_FIELD, ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AggregationOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String attribute;
    private final String displayValue;
    private final List<AggregationOutputItem> items;

    private AggregationOutput(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.displayValue = builder.displayValue;
        this.items = builder.items;
    }

    public final String attribute() {
        return this.attribute;
    }

    public final String displayValue() {
        return this.displayValue;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<AggregationOutputItem> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregationOutput)) {
            return false;
        }
        AggregationOutput other = (AggregationOutput)obj;
        return Objects.equals(this.attribute(), other.attribute()) && Objects.equals(this.displayValue(), other.displayValue()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items());
    }

    public final String toString() {
        return ToString.builder((String)"AggregationOutput").add("Attribute", (Object)this.attribute()).add("DisplayValue", (Object)this.displayValue()).add("Items", this.hasItems() ? this.items() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attribute": {
                return Optional.ofNullable(clazz.cast(this.attribute()));
            }
            case "displayValue": {
                return Optional.ofNullable(clazz.cast(this.displayValue()));
            }
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("attribute", ATTRIBUTE_FIELD);
        map.put("displayValue", DISPLAY_VALUE_FIELD);
        map.put("items", ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregationOutput, T> g) {
        return obj -> g.apply((AggregationOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attribute;
        private String displayValue;
        private List<AggregationOutputItem> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AggregationOutput model) {
            this.attribute(model.attribute);
            this.displayValue(model.displayValue);
            this.items(model.items);
        }

        public final String getAttribute() {
            return this.attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        public final String getDisplayValue() {
            return this.displayValue;
        }

        public final void setDisplayValue(String displayValue) {
            this.displayValue = displayValue;
        }

        @Override
        public final Builder displayValue(String displayValue) {
            this.displayValue = displayValue;
            return this;
        }

        public final List<AggregationOutputItem.Builder> getItems() {
            List<AggregationOutputItem.Builder> result = AggregationOutputItemsCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<AggregationOutputItem.BuilderImpl> items) {
            this.items = AggregationOutputItemsCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<AggregationOutputItem> items) {
            this.items = AggregationOutputItemsCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(AggregationOutputItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<AggregationOutputItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (AggregationOutputItem)((AggregationOutputItem.Builder)AggregationOutputItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AggregationOutput build() {
            return new AggregationOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregationOutput> {
        public Builder attribute(String var1);

        public Builder displayValue(String var1);

        public Builder items(Collection<AggregationOutputItem> var1);

        public Builder items(AggregationOutputItem ... var1);

        public Builder items(Consumer<AggregationOutputItem.Builder> ... var1);
    }
}

