/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RejectPredictionsResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, RejectPredictionsResponse> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetId").getter(RejectPredictionsResponse.getter(RejectPredictionsResponse::assetId)).setter(RejectPredictionsResponse.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()}).build();
    private static final SdkField<String> ASSET_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetRevision").getter(RejectPredictionsResponse.getter(RejectPredictionsResponse::assetRevision)).setter(RejectPredictionsResponse.setter(Builder::assetRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetRevision").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(RejectPredictionsResponse.getter(RejectPredictionsResponse::domainId)).setter(RejectPredictionsResponse.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, ASSET_REVISION_FIELD, DOMAIN_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RejectPredictionsResponse.memberNameToFieldInitializer();
    private final String assetId;
    private final String assetRevision;
    private final String domainId;

    private RejectPredictionsResponse(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.assetRevision = builder.assetRevision;
        this.domainId = builder.domainId;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final String assetRevision() {
        return this.assetRevision;
    }

    public final String domainId() {
        return this.domainId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectPredictionsResponse)) {
            return false;
        }
        RejectPredictionsResponse other = (RejectPredictionsResponse)((Object)obj);
        return Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.assetRevision(), other.assetRevision()) && Objects.equals(this.domainId(), other.domainId());
    }

    public final String toString() {
        return ToString.builder((String)"RejectPredictionsResponse").add("AssetId", (Object)this.assetId()).add("AssetRevision", (Object)this.assetRevision()).add("DomainId", (Object)this.domainId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "assetRevision": {
                return Optional.ofNullable(clazz.cast(this.assetRevision()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("assetId", ASSET_ID_FIELD);
        map.put("assetRevision", ASSET_REVISION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RejectPredictionsResponse, T> g) {
        return obj -> g.apply((RejectPredictionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private String assetId;
        private String assetRevision;
        private String domainId;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectPredictionsResponse model) {
            super(model);
            this.assetId(model.assetId);
            this.assetRevision(model.assetRevision);
            this.domainId(model.domainId);
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getAssetRevision() {
            return this.assetRevision;
        }

        public final void setAssetRevision(String assetRevision) {
            this.assetRevision = assetRevision;
        }

        @Override
        public final Builder assetRevision(String assetRevision) {
            this.assetRevision = assetRevision;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        @Override
        public RejectPredictionsResponse build() {
            return new RejectPredictionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RejectPredictionsResponse> {
        public Builder assetId(String var1);

        public Builder assetRevision(String var1);

        public Builder domainId(String var1);
    }
}

