/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.AssetItemAdditionalAttributes;
import software.amazon.awssdk.services.datazone.model.GlossaryTermsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetItem> {
    private static final SdkField<AssetItemAdditionalAttributes> ADDITIONAL_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("additionalAttributes").getter(AssetItem.getter(AssetItem::additionalAttributes)).setter(AssetItem.setter(Builder::additionalAttributes)).constructor(AssetItemAdditionalAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalAttributes").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(AssetItem.getter(AssetItem::createdAt)).setter(AssetItem.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(AssetItem.getter(AssetItem::createdBy)).setter(AssetItem.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AssetItem.getter(AssetItem::description)).setter(AssetItem.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(AssetItem.getter(AssetItem::domainId)).setter(AssetItem.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()}).build();
    private static final SdkField<String> EXTERNAL_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalIdentifier").getter(AssetItem.getter(AssetItem::externalIdentifier)).setter(AssetItem.setter(Builder::externalIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalIdentifier").build()}).build();
    private static final SdkField<Instant> FIRST_REVISION_CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("firstRevisionCreatedAt").getter(AssetItem.getter(AssetItem::firstRevisionCreatedAt)).setter(AssetItem.setter(Builder::firstRevisionCreatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstRevisionCreatedAt").build()}).build();
    private static final SdkField<String> FIRST_REVISION_CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("firstRevisionCreatedBy").getter(AssetItem.getter(AssetItem::firstRevisionCreatedBy)).setter(AssetItem.setter(Builder::firstRevisionCreatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstRevisionCreatedBy").build()}).build();
    private static final SdkField<List<String>> GLOSSARY_TERMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("glossaryTerms").getter(AssetItem.getter(AssetItem::glossaryTerms)).setter(AssetItem.setter(Builder::glossaryTerms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(AssetItem.getter(AssetItem::identifier)).setter(AssetItem.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AssetItem.getter(AssetItem::name)).setter(AssetItem.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owningProjectId").getter(AssetItem.getter(AssetItem::owningProjectId)).setter(AssetItem.setter(Builder::owningProjectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectId").build()}).build();
    private static final SdkField<String> TYPE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("typeIdentifier").getter(AssetItem.getter(AssetItem::typeIdentifier)).setter(AssetItem.setter(Builder::typeIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeIdentifier").build()}).build();
    private static final SdkField<String> TYPE_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("typeRevision").getter(AssetItem.getter(AssetItem::typeRevision)).setter(AssetItem.setter(Builder::typeRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeRevision").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_ATTRIBUTES_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, EXTERNAL_IDENTIFIER_FIELD, FIRST_REVISION_CREATED_AT_FIELD, FIRST_REVISION_CREATED_BY_FIELD, GLOSSARY_TERMS_FIELD, IDENTIFIER_FIELD, NAME_FIELD, OWNING_PROJECT_ID_FIELD, TYPE_IDENTIFIER_FIELD, TYPE_REVISION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssetItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AssetItemAdditionalAttributes additionalAttributes;
    private final Instant createdAt;
    private final String createdBy;
    private final String description;
    private final String domainId;
    private final String externalIdentifier;
    private final Instant firstRevisionCreatedAt;
    private final String firstRevisionCreatedBy;
    private final List<String> glossaryTerms;
    private final String identifier;
    private final String name;
    private final String owningProjectId;
    private final String typeIdentifier;
    private final String typeRevision;

    private AssetItem(BuilderImpl builder) {
        this.additionalAttributes = builder.additionalAttributes;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.externalIdentifier = builder.externalIdentifier;
        this.firstRevisionCreatedAt = builder.firstRevisionCreatedAt;
        this.firstRevisionCreatedBy = builder.firstRevisionCreatedBy;
        this.glossaryTerms = builder.glossaryTerms;
        this.identifier = builder.identifier;
        this.name = builder.name;
        this.owningProjectId = builder.owningProjectId;
        this.typeIdentifier = builder.typeIdentifier;
        this.typeRevision = builder.typeRevision;
    }

    public final AssetItemAdditionalAttributes additionalAttributes() {
        return this.additionalAttributes;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String description() {
        return this.description;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String externalIdentifier() {
        return this.externalIdentifier;
    }

    public final Instant firstRevisionCreatedAt() {
        return this.firstRevisionCreatedAt;
    }

    public final String firstRevisionCreatedBy() {
        return this.firstRevisionCreatedBy;
    }

    public final boolean hasGlossaryTerms() {
        return this.glossaryTerms != null && !(this.glossaryTerms instanceof SdkAutoConstructList);
    }

    public final List<String> glossaryTerms() {
        return this.glossaryTerms;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String name() {
        return this.name;
    }

    public final String owningProjectId() {
        return this.owningProjectId;
    }

    public final String typeIdentifier() {
        return this.typeIdentifier;
    }

    public final String typeRevision() {
        return this.typeRevision;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstRevisionCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstRevisionCreatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlossaryTerms() ? this.glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owningProjectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeRevision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetItem)) {
            return false;
        }
        AssetItem other = (AssetItem)obj;
        return Objects.equals(this.additionalAttributes(), other.additionalAttributes()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.externalIdentifier(), other.externalIdentifier()) && Objects.equals(this.firstRevisionCreatedAt(), other.firstRevisionCreatedAt()) && Objects.equals(this.firstRevisionCreatedBy(), other.firstRevisionCreatedBy()) && this.hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(this.glossaryTerms(), other.glossaryTerms()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owningProjectId(), other.owningProjectId()) && Objects.equals(this.typeIdentifier(), other.typeIdentifier()) && Objects.equals(this.typeRevision(), other.typeRevision());
    }

    public final String toString() {
        return ToString.builder((String)"AssetItem").add("AdditionalAttributes", (Object)this.additionalAttributes()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainId", (Object)this.domainId()).add("ExternalIdentifier", (Object)this.externalIdentifier()).add("FirstRevisionCreatedAt", (Object)this.firstRevisionCreatedAt()).add("FirstRevisionCreatedBy", (Object)this.firstRevisionCreatedBy()).add("GlossaryTerms", this.hasGlossaryTerms() ? this.glossaryTerms() : null).add("Identifier", (Object)this.identifier()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("OwningProjectId", (Object)this.owningProjectId()).add("TypeIdentifier", (Object)this.typeIdentifier()).add("TypeRevision", (Object)this.typeRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "additionalAttributes": {
                return Optional.ofNullable(clazz.cast(this.additionalAttributes()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "externalIdentifier": {
                return Optional.ofNullable(clazz.cast(this.externalIdentifier()));
            }
            case "firstRevisionCreatedAt": {
                return Optional.ofNullable(clazz.cast(this.firstRevisionCreatedAt()));
            }
            case "firstRevisionCreatedBy": {
                return Optional.ofNullable(clazz.cast(this.firstRevisionCreatedBy()));
            }
            case "glossaryTerms": {
                return Optional.ofNullable(clazz.cast(this.glossaryTerms()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "owningProjectId": {
                return Optional.ofNullable(clazz.cast(this.owningProjectId()));
            }
            case "typeIdentifier": {
                return Optional.ofNullable(clazz.cast(this.typeIdentifier()));
            }
            case "typeRevision": {
                return Optional.ofNullable(clazz.cast(this.typeRevision()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("additionalAttributes", ADDITIONAL_ATTRIBUTES_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("externalIdentifier", EXTERNAL_IDENTIFIER_FIELD);
        map.put("firstRevisionCreatedAt", FIRST_REVISION_CREATED_AT_FIELD);
        map.put("firstRevisionCreatedBy", FIRST_REVISION_CREATED_BY_FIELD);
        map.put("glossaryTerms", GLOSSARY_TERMS_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("owningProjectId", OWNING_PROJECT_ID_FIELD);
        map.put("typeIdentifier", TYPE_IDENTIFIER_FIELD);
        map.put("typeRevision", TYPE_REVISION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetItem, T> g) {
        return obj -> g.apply((AssetItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AssetItemAdditionalAttributes additionalAttributes;
        private Instant createdAt;
        private String createdBy;
        private String description;
        private String domainId;
        private String externalIdentifier;
        private Instant firstRevisionCreatedAt;
        private String firstRevisionCreatedBy;
        private List<String> glossaryTerms = DefaultSdkAutoConstructList.getInstance();
        private String identifier;
        private String name;
        private String owningProjectId;
        private String typeIdentifier;
        private String typeRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetItem model) {
            this.additionalAttributes(model.additionalAttributes);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.description(model.description);
            this.domainId(model.domainId);
            this.externalIdentifier(model.externalIdentifier);
            this.firstRevisionCreatedAt(model.firstRevisionCreatedAt);
            this.firstRevisionCreatedBy(model.firstRevisionCreatedBy);
            this.glossaryTerms(model.glossaryTerms);
            this.identifier(model.identifier);
            this.name(model.name);
            this.owningProjectId(model.owningProjectId);
            this.typeIdentifier(model.typeIdentifier);
            this.typeRevision(model.typeRevision);
        }

        public final AssetItemAdditionalAttributes.Builder getAdditionalAttributes() {
            return this.additionalAttributes != null ? this.additionalAttributes.toBuilder() : null;
        }

        public final void setAdditionalAttributes(AssetItemAdditionalAttributes.BuilderImpl additionalAttributes) {
            this.additionalAttributes = additionalAttributes != null ? additionalAttributes.build() : null;
        }

        @Override
        public final Builder additionalAttributes(AssetItemAdditionalAttributes additionalAttributes) {
            this.additionalAttributes = additionalAttributes;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getExternalIdentifier() {
            return this.externalIdentifier;
        }

        public final void setExternalIdentifier(String externalIdentifier) {
            this.externalIdentifier = externalIdentifier;
        }

        @Override
        public final Builder externalIdentifier(String externalIdentifier) {
            this.externalIdentifier = externalIdentifier;
            return this;
        }

        public final Instant getFirstRevisionCreatedAt() {
            return this.firstRevisionCreatedAt;
        }

        public final void setFirstRevisionCreatedAt(Instant firstRevisionCreatedAt) {
            this.firstRevisionCreatedAt = firstRevisionCreatedAt;
        }

        @Override
        public final Builder firstRevisionCreatedAt(Instant firstRevisionCreatedAt) {
            this.firstRevisionCreatedAt = firstRevisionCreatedAt;
            return this;
        }

        public final String getFirstRevisionCreatedBy() {
            return this.firstRevisionCreatedBy;
        }

        public final void setFirstRevisionCreatedBy(String firstRevisionCreatedBy) {
            this.firstRevisionCreatedBy = firstRevisionCreatedBy;
        }

        @Override
        public final Builder firstRevisionCreatedBy(String firstRevisionCreatedBy) {
            this.firstRevisionCreatedBy = firstRevisionCreatedBy;
            return this;
        }

        public final Collection<String> getGlossaryTerms() {
            if (this.glossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.glossaryTerms;
        }

        public final void setGlossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(String ... glossaryTerms) {
            this.glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwningProjectId() {
            return this.owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        public final String getTypeIdentifier() {
            return this.typeIdentifier;
        }

        public final void setTypeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
        }

        @Override
        public final Builder typeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
            return this;
        }

        public final String getTypeRevision() {
            return this.typeRevision;
        }

        public final void setTypeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
        }

        @Override
        public final Builder typeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
            return this;
        }

        public AssetItem build() {
            return new AssetItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetItem> {
        public Builder additionalAttributes(AssetItemAdditionalAttributes var1);

        default public Builder additionalAttributes(Consumer<AssetItemAdditionalAttributes.Builder> additionalAttributes) {
            return this.additionalAttributes((AssetItemAdditionalAttributes)((AssetItemAdditionalAttributes.Builder)AssetItemAdditionalAttributes.builder().applyMutation(additionalAttributes)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder description(String var1);

        public Builder domainId(String var1);

        public Builder externalIdentifier(String var1);

        public Builder firstRevisionCreatedAt(Instant var1);

        public Builder firstRevisionCreatedBy(String var1);

        public Builder glossaryTerms(Collection<String> var1);

        public Builder glossaryTerms(String ... var1);

        public Builder identifier(String var1);

        public Builder name(String var1);

        public Builder owningProjectId(String var1);

        public Builder typeIdentifier(String var1);

        public Builder typeRevision(String var1);
    }
}

