/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.AssetFilterConfiguration;
import software.amazon.awssdk.services.datazone.model.ColumnNameListCopier;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.FilterStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAssetFilterResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, GetAssetFilterResponse> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetId").getter(GetAssetFilterResponse.getter(GetAssetFilterResponse::assetId)).setter(GetAssetFilterResponse.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()}).build();
    private static final SdkField<AssetFilterConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(GetAssetFilterResponse.getter(GetAssetFilterResponse::configuration)).setter(GetAssetFilterResponse.setter(Builder::configuration)).constructor(AssetFilterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetAssetFilterResponse.getter(GetAssetFilterResponse::createdAt)).setter(GetAssetFilterResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetAssetFilterResponse.getter(GetAssetFilterResponse::description)).setter(GetAssetFilterResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(GetAssetFilterResponse.getter(GetAssetFilterResponse::domainId)).setter(GetAssetFilterResponse.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()}).build();
    private static final SdkField<List<String>> EFFECTIVE_COLUMN_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("effectiveColumnNames").getter(GetAssetFilterResponse.getter(GetAssetFilterResponse::effectiveColumnNames)).setter(GetAssetFilterResponse.setter(Builder::effectiveColumnNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveColumnNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EFFECTIVE_ROW_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("effectiveRowFilter").getter(GetAssetFilterResponse.getter(GetAssetFilterResponse::effectiveRowFilter)).setter(GetAssetFilterResponse.setter(Builder::effectiveRowFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveRowFilter").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(GetAssetFilterResponse.getter(GetAssetFilterResponse::errorMessage)).setter(GetAssetFilterResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetAssetFilterResponse.getter(GetAssetFilterResponse::id)).setter(GetAssetFilterResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetAssetFilterResponse.getter(GetAssetFilterResponse::name)).setter(GetAssetFilterResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetAssetFilterResponse.getter(GetAssetFilterResponse::statusAsString)).setter(GetAssetFilterResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, CONFIGURATION_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, EFFECTIVE_COLUMN_NAMES_FIELD, EFFECTIVE_ROW_FILTER_FIELD, ERROR_MESSAGE_FIELD, ID_FIELD, NAME_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAssetFilterResponse.memberNameToFieldInitializer();
    private final String assetId;
    private final AssetFilterConfiguration configuration;
    private final Instant createdAt;
    private final String description;
    private final String domainId;
    private final List<String> effectiveColumnNames;
    private final String effectiveRowFilter;
    private final String errorMessage;
    private final String id;
    private final String name;
    private final String status;

    private GetAssetFilterResponse(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.configuration = builder.configuration;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.effectiveColumnNames = builder.effectiveColumnNames;
        this.effectiveRowFilter = builder.effectiveRowFilter;
        this.errorMessage = builder.errorMessage;
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final AssetFilterConfiguration configuration() {
        return this.configuration;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final boolean hasEffectiveColumnNames() {
        return this.effectiveColumnNames != null && !(this.effectiveColumnNames instanceof SdkAutoConstructList);
    }

    public final List<String> effectiveColumnNames() {
        return this.effectiveColumnNames;
    }

    public final String effectiveRowFilter() {
        return this.effectiveRowFilter;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final FilterStatus status() {
        return FilterStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEffectiveColumnNames() ? this.effectiveColumnNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveRowFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssetFilterResponse)) {
            return false;
        }
        GetAssetFilterResponse other = (GetAssetFilterResponse)((Object)obj);
        return Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainId(), other.domainId()) && this.hasEffectiveColumnNames() == other.hasEffectiveColumnNames() && Objects.equals(this.effectiveColumnNames(), other.effectiveColumnNames()) && Objects.equals(this.effectiveRowFilter(), other.effectiveRowFilter()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetAssetFilterResponse").add("AssetId", (Object)this.assetId()).add("Configuration", (Object)this.configuration()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainId", (Object)this.domainId()).add("EffectiveColumnNames", this.hasEffectiveColumnNames() ? this.effectiveColumnNames() : null).add("EffectiveRowFilter", (Object)this.effectiveRowFilter()).add("ErrorMessage", (Object)this.errorMessage()).add("Id", (Object)this.id()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "effectiveColumnNames": {
                return Optional.ofNullable(clazz.cast(this.effectiveColumnNames()));
            }
            case "effectiveRowFilter": {
                return Optional.ofNullable(clazz.cast(this.effectiveRowFilter()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assetId", ASSET_ID_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("effectiveColumnNames", EFFECTIVE_COLUMN_NAMES_FIELD);
        map.put("effectiveRowFilter", EFFECTIVE_ROW_FILTER_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAssetFilterResponse, T> g) {
        return obj -> g.apply((GetAssetFilterResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private String assetId;
        private AssetFilterConfiguration configuration;
        private Instant createdAt;
        private String description;
        private String domainId;
        private List<String> effectiveColumnNames = DefaultSdkAutoConstructList.getInstance();
        private String effectiveRowFilter;
        private String errorMessage;
        private String id;
        private String name;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssetFilterResponse model) {
            super(model);
            this.assetId(model.assetId);
            this.configuration(model.configuration);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.domainId(model.domainId);
            this.effectiveColumnNames(model.effectiveColumnNames);
            this.effectiveRowFilter(model.effectiveRowFilter);
            this.errorMessage(model.errorMessage);
            this.id(model.id);
            this.name(model.name);
            this.status(model.status);
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final AssetFilterConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(AssetFilterConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AssetFilterConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final Collection<String> getEffectiveColumnNames() {
            if (this.effectiveColumnNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.effectiveColumnNames;
        }

        public final void setEffectiveColumnNames(Collection<String> effectiveColumnNames) {
            this.effectiveColumnNames = ColumnNameListCopier.copy(effectiveColumnNames);
        }

        @Override
        public final Builder effectiveColumnNames(Collection<String> effectiveColumnNames) {
            this.effectiveColumnNames = ColumnNameListCopier.copy(effectiveColumnNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectiveColumnNames(String ... effectiveColumnNames) {
            this.effectiveColumnNames(Arrays.asList(effectiveColumnNames));
            return this;
        }

        public final String getEffectiveRowFilter() {
            return this.effectiveRowFilter;
        }

        public final void setEffectiveRowFilter(String effectiveRowFilter) {
            this.effectiveRowFilter = effectiveRowFilter;
        }

        @Override
        public final Builder effectiveRowFilter(String effectiveRowFilter) {
            this.effectiveRowFilter = effectiveRowFilter;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FilterStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetAssetFilterResponse build() {
            return new GetAssetFilterResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAssetFilterResponse> {
        public Builder assetId(String var1);

        public Builder configuration(AssetFilterConfiguration var1);

        default public Builder configuration(Consumer<AssetFilterConfiguration.Builder> configuration) {
            return this.configuration((AssetFilterConfiguration)((AssetFilterConfiguration.Builder)AssetFilterConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder domainId(String var1);

        public Builder effectiveColumnNames(Collection<String> var1);

        public Builder effectiveColumnNames(String ... var1);

        public Builder effectiveRowFilter(String var1);

        public Builder errorMessage(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(FilterStatus var1);
    }
}

