/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.AcceptRuleBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AcceptRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AcceptRule> {
    private static final SdkField<String> RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rule").getter(AcceptRule.getter(AcceptRule::ruleAsString)).setter(AcceptRule.setter(Builder::rule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rule").build()}).build();
    private static final SdkField<Float> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("threshold").getter(AcceptRule.getter(AcceptRule::threshold)).setter(AcceptRule.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_FIELD, THRESHOLD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AcceptRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String rule;
    private final Float threshold;

    private AcceptRule(BuilderImpl builder) {
        this.rule = builder.rule;
        this.threshold = builder.threshold;
    }

    public final AcceptRuleBehavior rule() {
        return AcceptRuleBehavior.fromValue(this.rule);
    }

    public final String ruleAsString() {
        return this.rule;
    }

    public final Float threshold() {
        return this.threshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptRule)) {
            return false;
        }
        AcceptRule other = (AcceptRule)obj;
        return Objects.equals(this.ruleAsString(), other.ruleAsString()) && Objects.equals(this.threshold(), other.threshold());
    }

    public final String toString() {
        return ToString.builder((String)"AcceptRule").add("Rule", (Object)this.ruleAsString()).add("Threshold", (Object)this.threshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "rule": {
                return Optional.ofNullable(clazz.cast(this.ruleAsString()));
            }
            case "threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rule", RULE_FIELD);
        map.put("threshold", THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AcceptRule, T> g) {
        return obj -> g.apply((AcceptRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String rule;
        private Float threshold;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptRule model) {
            this.rule(model.rule);
            this.threshold(model.threshold);
        }

        public final String getRule() {
            return this.rule;
        }

        public final void setRule(String rule) {
            this.rule = rule;
        }

        @Override
        public final Builder rule(String rule) {
            this.rule = rule;
            return this;
        }

        @Override
        public final Builder rule(AcceptRuleBehavior rule) {
            this.rule(rule == null ? null : rule.toString());
            return this;
        }

        public final Float getThreshold() {
            return this.threshold;
        }

        public final void setThreshold(Float threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Float threshold) {
            this.threshold = threshold;
            return this;
        }

        public AcceptRule build() {
            return new AcceptRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AcceptRule> {
        public Builder rule(String var1);

        public Builder rule(AcceptRuleBehavior var1);

        public Builder threshold(Float var1);
    }
}

