/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.AssetListingItemAdditionalAttributes;
import software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm;
import software.amazon.awssdk.services.datazone.model.DetailedGlossaryTermsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetListingItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetListingItem> {
    private static final SdkField<AssetListingItemAdditionalAttributes> ADDITIONAL_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("additionalAttributes").getter(AssetListingItem.getter(AssetListingItem::additionalAttributes)).setter(AssetListingItem.setter(Builder::additionalAttributes)).constructor(AssetListingItemAdditionalAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalAttributes").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(AssetListingItem.getter(AssetListingItem::createdAt)).setter(AssetListingItem.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AssetListingItem.getter(AssetListingItem::description)).setter(AssetListingItem.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityId").getter(AssetListingItem.getter(AssetListingItem::entityId)).setter(AssetListingItem.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()}).build();
    private static final SdkField<String> ENTITY_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityRevision").getter(AssetListingItem.getter(AssetListingItem::entityRevision)).setter(AssetListingItem.setter(Builder::entityRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityRevision").build()}).build();
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityType").getter(AssetListingItem.getter(AssetListingItem::entityType)).setter(AssetListingItem.setter(Builder::entityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityType").build()}).build();
    private static final SdkField<List<DetailedGlossaryTerm>> GLOSSARY_TERMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("glossaryTerms").getter(AssetListingItem.getter(AssetListingItem::glossaryTerms)).setter(AssetListingItem.setter(Builder::glossaryTerms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DetailedGlossaryTerm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LISTING_CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("listingCreatedBy").getter(AssetListingItem.getter(AssetListingItem::listingCreatedBy)).setter(AssetListingItem.setter(Builder::listingCreatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingCreatedBy").build()}).build();
    private static final SdkField<String> LISTING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("listingId").getter(AssetListingItem.getter(AssetListingItem::listingId)).setter(AssetListingItem.setter(Builder::listingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingId").build()}).build();
    private static final SdkField<String> LISTING_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("listingRevision").getter(AssetListingItem.getter(AssetListingItem::listingRevision)).setter(AssetListingItem.setter(Builder::listingRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingRevision").build()}).build();
    private static final SdkField<String> LISTING_UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("listingUpdatedBy").getter(AssetListingItem.getter(AssetListingItem::listingUpdatedBy)).setter(AssetListingItem.setter(Builder::listingUpdatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingUpdatedBy").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AssetListingItem.getter(AssetListingItem::name)).setter(AssetListingItem.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owningProjectId").getter(AssetListingItem.getter(AssetListingItem::owningProjectId)).setter(AssetListingItem.setter(Builder::owningProjectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_ATTRIBUTES_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, ENTITY_ID_FIELD, ENTITY_REVISION_FIELD, ENTITY_TYPE_FIELD, GLOSSARY_TERMS_FIELD, LISTING_CREATED_BY_FIELD, LISTING_ID_FIELD, LISTING_REVISION_FIELD, LISTING_UPDATED_BY_FIELD, NAME_FIELD, OWNING_PROJECT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssetListingItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AssetListingItemAdditionalAttributes additionalAttributes;
    private final Instant createdAt;
    private final String description;
    private final String entityId;
    private final String entityRevision;
    private final String entityType;
    private final List<DetailedGlossaryTerm> glossaryTerms;
    private final String listingCreatedBy;
    private final String listingId;
    private final String listingRevision;
    private final String listingUpdatedBy;
    private final String name;
    private final String owningProjectId;

    private AssetListingItem(BuilderImpl builder) {
        this.additionalAttributes = builder.additionalAttributes;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.entityId = builder.entityId;
        this.entityRevision = builder.entityRevision;
        this.entityType = builder.entityType;
        this.glossaryTerms = builder.glossaryTerms;
        this.listingCreatedBy = builder.listingCreatedBy;
        this.listingId = builder.listingId;
        this.listingRevision = builder.listingRevision;
        this.listingUpdatedBy = builder.listingUpdatedBy;
        this.name = builder.name;
        this.owningProjectId = builder.owningProjectId;
    }

    public final AssetListingItemAdditionalAttributes additionalAttributes() {
        return this.additionalAttributes;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final String entityRevision() {
        return this.entityRevision;
    }

    public final String entityType() {
        return this.entityType;
    }

    public final boolean hasGlossaryTerms() {
        return this.glossaryTerms != null && !(this.glossaryTerms instanceof SdkAutoConstructList);
    }

    public final List<DetailedGlossaryTerm> glossaryTerms() {
        return this.glossaryTerms;
    }

    public final String listingCreatedBy() {
        return this.listingCreatedBy;
    }

    public final String listingId() {
        return this.listingId;
    }

    public final String listingRevision() {
        return this.listingRevision;
    }

    public final String listingUpdatedBy() {
        return this.listingUpdatedBy;
    }

    public final String name() {
        return this.name;
    }

    public final String owningProjectId() {
        return this.owningProjectId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlossaryTerms() ? this.glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.listingCreatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.listingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.listingRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.listingUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owningProjectId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetListingItem)) {
            return false;
        }
        AssetListingItem other = (AssetListingItem)obj;
        return Objects.equals(this.additionalAttributes(), other.additionalAttributes()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.entityRevision(), other.entityRevision()) && Objects.equals(this.entityType(), other.entityType()) && this.hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(this.glossaryTerms(), other.glossaryTerms()) && Objects.equals(this.listingCreatedBy(), other.listingCreatedBy()) && Objects.equals(this.listingId(), other.listingId()) && Objects.equals(this.listingRevision(), other.listingRevision()) && Objects.equals(this.listingUpdatedBy(), other.listingUpdatedBy()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owningProjectId(), other.owningProjectId());
    }

    public final String toString() {
        return ToString.builder((String)"AssetListingItem").add("AdditionalAttributes", (Object)this.additionalAttributes()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("EntityId", (Object)this.entityId()).add("EntityRevision", (Object)this.entityRevision()).add("EntityType", (Object)this.entityType()).add("GlossaryTerms", this.hasGlossaryTerms() ? this.glossaryTerms() : null).add("ListingCreatedBy", (Object)this.listingCreatedBy()).add("ListingId", (Object)this.listingId()).add("ListingRevision", (Object)this.listingRevision()).add("ListingUpdatedBy", (Object)this.listingUpdatedBy()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("OwningProjectId", (Object)this.owningProjectId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "additionalAttributes": {
                return Optional.ofNullable(clazz.cast(this.additionalAttributes()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "entityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "entityRevision": {
                return Optional.ofNullable(clazz.cast(this.entityRevision()));
            }
            case "entityType": {
                return Optional.ofNullable(clazz.cast(this.entityType()));
            }
            case "glossaryTerms": {
                return Optional.ofNullable(clazz.cast(this.glossaryTerms()));
            }
            case "listingCreatedBy": {
                return Optional.ofNullable(clazz.cast(this.listingCreatedBy()));
            }
            case "listingId": {
                return Optional.ofNullable(clazz.cast(this.listingId()));
            }
            case "listingRevision": {
                return Optional.ofNullable(clazz.cast(this.listingRevision()));
            }
            case "listingUpdatedBy": {
                return Optional.ofNullable(clazz.cast(this.listingUpdatedBy()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "owningProjectId": {
                return Optional.ofNullable(clazz.cast(this.owningProjectId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("additionalAttributes", ADDITIONAL_ATTRIBUTES_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("entityId", ENTITY_ID_FIELD);
        map.put("entityRevision", ENTITY_REVISION_FIELD);
        map.put("entityType", ENTITY_TYPE_FIELD);
        map.put("glossaryTerms", GLOSSARY_TERMS_FIELD);
        map.put("listingCreatedBy", LISTING_CREATED_BY_FIELD);
        map.put("listingId", LISTING_ID_FIELD);
        map.put("listingRevision", LISTING_REVISION_FIELD);
        map.put("listingUpdatedBy", LISTING_UPDATED_BY_FIELD);
        map.put("name", NAME_FIELD);
        map.put("owningProjectId", OWNING_PROJECT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetListingItem, T> g) {
        return obj -> g.apply((AssetListingItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AssetListingItemAdditionalAttributes additionalAttributes;
        private Instant createdAt;
        private String description;
        private String entityId;
        private String entityRevision;
        private String entityType;
        private List<DetailedGlossaryTerm> glossaryTerms = DefaultSdkAutoConstructList.getInstance();
        private String listingCreatedBy;
        private String listingId;
        private String listingRevision;
        private String listingUpdatedBy;
        private String name;
        private String owningProjectId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetListingItem model) {
            this.additionalAttributes(model.additionalAttributes);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.entityId(model.entityId);
            this.entityRevision(model.entityRevision);
            this.entityType(model.entityType);
            this.glossaryTerms(model.glossaryTerms);
            this.listingCreatedBy(model.listingCreatedBy);
            this.listingId(model.listingId);
            this.listingRevision(model.listingRevision);
            this.listingUpdatedBy(model.listingUpdatedBy);
            this.name(model.name);
            this.owningProjectId(model.owningProjectId);
        }

        public final AssetListingItemAdditionalAttributes.Builder getAdditionalAttributes() {
            return this.additionalAttributes != null ? this.additionalAttributes.toBuilder() : null;
        }

        public final void setAdditionalAttributes(AssetListingItemAdditionalAttributes.BuilderImpl additionalAttributes) {
            this.additionalAttributes = additionalAttributes != null ? additionalAttributes.build() : null;
        }

        @Override
        public final Builder additionalAttributes(AssetListingItemAdditionalAttributes additionalAttributes) {
            this.additionalAttributes = additionalAttributes;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityRevision() {
            return this.entityRevision;
        }

        public final void setEntityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
        }

        @Override
        public final Builder entityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
            return this;
        }

        public final String getEntityType() {
            return this.entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public final List<DetailedGlossaryTerm.Builder> getGlossaryTerms() {
            List<DetailedGlossaryTerm.Builder> result = DetailedGlossaryTermsCopier.copyToBuilder(this.glossaryTerms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlossaryTerms(Collection<DetailedGlossaryTerm.BuilderImpl> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copyFromBuilder(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<DetailedGlossaryTerm> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(DetailedGlossaryTerm ... glossaryTerms) {
            this.glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder> ... glossaryTerms) {
            this.glossaryTerms(Stream.of(glossaryTerms).map(c -> (DetailedGlossaryTerm)((DetailedGlossaryTerm.Builder)DetailedGlossaryTerm.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getListingCreatedBy() {
            return this.listingCreatedBy;
        }

        public final void setListingCreatedBy(String listingCreatedBy) {
            this.listingCreatedBy = listingCreatedBy;
        }

        @Override
        public final Builder listingCreatedBy(String listingCreatedBy) {
            this.listingCreatedBy = listingCreatedBy;
            return this;
        }

        public final String getListingId() {
            return this.listingId;
        }

        public final void setListingId(String listingId) {
            this.listingId = listingId;
        }

        @Override
        public final Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public final String getListingRevision() {
            return this.listingRevision;
        }

        public final void setListingRevision(String listingRevision) {
            this.listingRevision = listingRevision;
        }

        @Override
        public final Builder listingRevision(String listingRevision) {
            this.listingRevision = listingRevision;
            return this;
        }

        public final String getListingUpdatedBy() {
            return this.listingUpdatedBy;
        }

        public final void setListingUpdatedBy(String listingUpdatedBy) {
            this.listingUpdatedBy = listingUpdatedBy;
        }

        @Override
        public final Builder listingUpdatedBy(String listingUpdatedBy) {
            this.listingUpdatedBy = listingUpdatedBy;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwningProjectId() {
            return this.owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        public AssetListingItem build() {
            return new AssetListingItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetListingItem> {
        public Builder additionalAttributes(AssetListingItemAdditionalAttributes var1);

        default public Builder additionalAttributes(Consumer<AssetListingItemAdditionalAttributes.Builder> additionalAttributes) {
            return this.additionalAttributes((AssetListingItemAdditionalAttributes)((AssetListingItemAdditionalAttributes.Builder)AssetListingItemAdditionalAttributes.builder().applyMutation(additionalAttributes)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder entityId(String var1);

        public Builder entityRevision(String var1);

        public Builder entityType(String var1);

        public Builder glossaryTerms(Collection<DetailedGlossaryTerm> var1);

        public Builder glossaryTerms(DetailedGlossaryTerm ... var1);

        public Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder> ... var1);

        public Builder listingCreatedBy(String var1);

        public Builder listingId(String var1);

        public Builder listingRevision(String var1);

        public Builder listingUpdatedBy(String var1);

        public Builder name(String var1);

        public Builder owningProjectId(String var1);
    }
}

