/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.SearchResultItem;
import software.amazon.awssdk.services.datazone.model.SearchResultItemsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchListingsResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, SearchListingsResponse> {
    private static final SdkField<List<SearchResultItem>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("items").getter(SearchListingsResponse.getter(SearchListingsResponse::items)).setter(SearchListingsResponse.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SearchResultItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(SearchListingsResponse.getter(SearchListingsResponse::nextToken)).setter(SearchListingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> TOTAL_MATCH_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalMatchCount").getter(SearchListingsResponse.getter(SearchListingsResponse::totalMatchCount)).setter(SearchListingsResponse.setter(Builder::totalMatchCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalMatchCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_FIELD, NEXT_TOKEN_FIELD, TOTAL_MATCH_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchListingsResponse.memberNameToFieldInitializer();
    private final List<SearchResultItem> items;
    private final String nextToken;
    private final Integer totalMatchCount;

    private SearchListingsResponse(BuilderImpl builder) {
        super(builder);
        this.items = builder.items;
        this.nextToken = builder.nextToken;
        this.totalMatchCount = builder.totalMatchCount;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<SearchResultItem> items() {
        return this.items;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer totalMatchCount() {
        return this.totalMatchCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalMatchCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchListingsResponse)) {
            return false;
        }
        SearchListingsResponse other = (SearchListingsResponse)((Object)obj);
        return this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.totalMatchCount(), other.totalMatchCount());
    }

    public final String toString() {
        return ToString.builder((String)"SearchListingsResponse").add("Items", this.hasItems() ? this.items() : null).add("NextToken", (Object)this.nextToken()).add("TotalMatchCount", (Object)this.totalMatchCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "totalMatchCount": {
                return Optional.ofNullable(clazz.cast(this.totalMatchCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("items", ITEMS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("totalMatchCount", TOTAL_MATCH_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchListingsResponse, T> g) {
        return obj -> g.apply((SearchListingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private List<SearchResultItem> items = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer totalMatchCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchListingsResponse model) {
            super(model);
            this.items(model.items);
            this.nextToken(model.nextToken);
            this.totalMatchCount(model.totalMatchCount);
        }

        public final List<SearchResultItem.Builder> getItems() {
            List<SearchResultItem.Builder> result = SearchResultItemsCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<SearchResultItem.BuilderImpl> items) {
            this.items = SearchResultItemsCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<SearchResultItem> items) {
            this.items = SearchResultItemsCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(SearchResultItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<SearchResultItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (SearchResultItem)((SearchResultItem.Builder)SearchResultItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getTotalMatchCount() {
            return this.totalMatchCount;
        }

        public final void setTotalMatchCount(Integer totalMatchCount) {
            this.totalMatchCount = totalMatchCount;
        }

        @Override
        public final Builder totalMatchCount(Integer totalMatchCount) {
            this.totalMatchCount = totalMatchCount;
            return this;
        }

        @Override
        public SearchListingsResponse build() {
            return new SearchListingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchListingsResponse> {
        public Builder items(Collection<SearchResultItem> var1);

        public Builder items(SearchResultItem ... var1);

        public Builder items(Consumer<SearchResultItem.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder totalMatchCount(Integer var1);
    }
}

