/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.AssetItem;
import software.amazon.awssdk.services.datazone.model.DataProductResultItem;
import software.amazon.awssdk.services.datazone.model.GlossaryItem;
import software.amazon.awssdk.services.datazone.model.GlossaryTermItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchInventoryResultItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchInventoryResultItem> {
    private static final SdkField<AssetItem> ASSET_ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("assetItem").getter(SearchInventoryResultItem.getter(SearchInventoryResultItem::assetItem)).setter(SearchInventoryResultItem.setter(Builder::assetItem)).constructor(AssetItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetItem").build()}).build();
    private static final SdkField<DataProductResultItem> DATA_PRODUCT_ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataProductItem").getter(SearchInventoryResultItem.getter(SearchInventoryResultItem::dataProductItem)).setter(SearchInventoryResultItem.setter(Builder::dataProductItem)).constructor(DataProductResultItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataProductItem").build()}).build();
    private static final SdkField<GlossaryItem> GLOSSARY_ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("glossaryItem").getter(SearchInventoryResultItem.getter(SearchInventoryResultItem::glossaryItem)).setter(SearchInventoryResultItem.setter(Builder::glossaryItem)).constructor(GlossaryItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryItem").build()}).build();
    private static final SdkField<GlossaryTermItem> GLOSSARY_TERM_ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("glossaryTermItem").getter(SearchInventoryResultItem.getter(SearchInventoryResultItem::glossaryTermItem)).setter(SearchInventoryResultItem.setter(Builder::glossaryTermItem)).constructor(GlossaryTermItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTermItem").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ITEM_FIELD, DATA_PRODUCT_ITEM_FIELD, GLOSSARY_ITEM_FIELD, GLOSSARY_TERM_ITEM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchInventoryResultItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AssetItem assetItem;
    private final DataProductResultItem dataProductItem;
    private final GlossaryItem glossaryItem;
    private final GlossaryTermItem glossaryTermItem;
    private final Type type;

    private SearchInventoryResultItem(BuilderImpl builder) {
        this.assetItem = builder.assetItem;
        this.dataProductItem = builder.dataProductItem;
        this.glossaryItem = builder.glossaryItem;
        this.glossaryTermItem = builder.glossaryTermItem;
        this.type = builder.type;
    }

    public final AssetItem assetItem() {
        return this.assetItem;
    }

    public final DataProductResultItem dataProductItem() {
        return this.dataProductItem;
    }

    public final GlossaryItem glossaryItem() {
        return this.glossaryItem;
    }

    public final GlossaryTermItem glossaryTermItem() {
        return this.glossaryTermItem;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assetItem());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProductItem());
        hashCode = 31 * hashCode + Objects.hashCode(this.glossaryItem());
        hashCode = 31 * hashCode + Objects.hashCode(this.glossaryTermItem());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchInventoryResultItem)) {
            return false;
        }
        SearchInventoryResultItem other = (SearchInventoryResultItem)obj;
        return Objects.equals(this.assetItem(), other.assetItem()) && Objects.equals(this.dataProductItem(), other.dataProductItem()) && Objects.equals(this.glossaryItem(), other.glossaryItem()) && Objects.equals(this.glossaryTermItem(), other.glossaryTermItem());
    }

    public final String toString() {
        return ToString.builder((String)"SearchInventoryResultItem").add("AssetItem", (Object)this.assetItem()).add("DataProductItem", (Object)this.dataProductItem()).add("GlossaryItem", (Object)this.glossaryItem()).add("GlossaryTermItem", (Object)this.glossaryTermItem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetItem": {
                return Optional.ofNullable(clazz.cast(this.assetItem()));
            }
            case "dataProductItem": {
                return Optional.ofNullable(clazz.cast(this.dataProductItem()));
            }
            case "glossaryItem": {
                return Optional.ofNullable(clazz.cast(this.glossaryItem()));
            }
            case "glossaryTermItem": {
                return Optional.ofNullable(clazz.cast(this.glossaryTermItem()));
            }
        }
        return Optional.empty();
    }

    public static SearchInventoryResultItem fromAssetItem(AssetItem assetItem) {
        return (SearchInventoryResultItem)SearchInventoryResultItem.builder().assetItem(assetItem).build();
    }

    public static SearchInventoryResultItem fromAssetItem(Consumer<AssetItem.Builder> assetItem) {
        AssetItem.Builder builder = AssetItem.builder();
        assetItem.accept(builder);
        return SearchInventoryResultItem.fromAssetItem((AssetItem)builder.build());
    }

    public static SearchInventoryResultItem fromDataProductItem(DataProductResultItem dataProductItem) {
        return (SearchInventoryResultItem)SearchInventoryResultItem.builder().dataProductItem(dataProductItem).build();
    }

    public static SearchInventoryResultItem fromDataProductItem(Consumer<DataProductResultItem.Builder> dataProductItem) {
        DataProductResultItem.Builder builder = DataProductResultItem.builder();
        dataProductItem.accept(builder);
        return SearchInventoryResultItem.fromDataProductItem((DataProductResultItem)builder.build());
    }

    public static SearchInventoryResultItem fromGlossaryItem(GlossaryItem glossaryItem) {
        return (SearchInventoryResultItem)SearchInventoryResultItem.builder().glossaryItem(glossaryItem).build();
    }

    public static SearchInventoryResultItem fromGlossaryItem(Consumer<GlossaryItem.Builder> glossaryItem) {
        GlossaryItem.Builder builder = GlossaryItem.builder();
        glossaryItem.accept(builder);
        return SearchInventoryResultItem.fromGlossaryItem((GlossaryItem)builder.build());
    }

    public static SearchInventoryResultItem fromGlossaryTermItem(GlossaryTermItem glossaryTermItem) {
        return (SearchInventoryResultItem)SearchInventoryResultItem.builder().glossaryTermItem(glossaryTermItem).build();
    }

    public static SearchInventoryResultItem fromGlossaryTermItem(Consumer<GlossaryTermItem.Builder> glossaryTermItem) {
        GlossaryTermItem.Builder builder = GlossaryTermItem.builder();
        glossaryTermItem.accept(builder);
        return SearchInventoryResultItem.fromGlossaryTermItem((GlossaryTermItem)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assetItem", ASSET_ITEM_FIELD);
        map.put("dataProductItem", DATA_PRODUCT_ITEM_FIELD);
        map.put("glossaryItem", GLOSSARY_ITEM_FIELD);
        map.put("glossaryTermItem", GLOSSARY_TERM_ITEM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchInventoryResultItem, T> g) {
        return obj -> g.apply((SearchInventoryResultItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ASSET_ITEM,
        DATA_PRODUCT_ITEM,
        GLOSSARY_ITEM,
        GLOSSARY_TERM_ITEM,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AssetItem assetItem;
        private DataProductResultItem dataProductItem;
        private GlossaryItem glossaryItem;
        private GlossaryTermItem glossaryTermItem;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SearchInventoryResultItem model) {
            this.assetItem(model.assetItem);
            this.dataProductItem(model.dataProductItem);
            this.glossaryItem(model.glossaryItem);
            this.glossaryTermItem(model.glossaryTermItem);
        }

        public final AssetItem.Builder getAssetItem() {
            return this.assetItem != null ? this.assetItem.toBuilder() : null;
        }

        public final void setAssetItem(AssetItem.BuilderImpl assetItem) {
            AssetItem oldValue = this.assetItem;
            this.assetItem = assetItem != null ? assetItem.build() : null;
            this.handleUnionValueChange(Type.ASSET_ITEM, oldValue, this.assetItem);
        }

        @Override
        public final Builder assetItem(AssetItem assetItem) {
            AssetItem oldValue = this.assetItem;
            this.assetItem = assetItem;
            this.handleUnionValueChange(Type.ASSET_ITEM, oldValue, this.assetItem);
            return this;
        }

        public final DataProductResultItem.Builder getDataProductItem() {
            return this.dataProductItem != null ? this.dataProductItem.toBuilder() : null;
        }

        public final void setDataProductItem(DataProductResultItem.BuilderImpl dataProductItem) {
            DataProductResultItem oldValue = this.dataProductItem;
            this.dataProductItem = dataProductItem != null ? dataProductItem.build() : null;
            this.handleUnionValueChange(Type.DATA_PRODUCT_ITEM, oldValue, this.dataProductItem);
        }

        @Override
        public final Builder dataProductItem(DataProductResultItem dataProductItem) {
            DataProductResultItem oldValue = this.dataProductItem;
            this.dataProductItem = dataProductItem;
            this.handleUnionValueChange(Type.DATA_PRODUCT_ITEM, oldValue, this.dataProductItem);
            return this;
        }

        public final GlossaryItem.Builder getGlossaryItem() {
            return this.glossaryItem != null ? this.glossaryItem.toBuilder() : null;
        }

        public final void setGlossaryItem(GlossaryItem.BuilderImpl glossaryItem) {
            GlossaryItem oldValue = this.glossaryItem;
            this.glossaryItem = glossaryItem != null ? glossaryItem.build() : null;
            this.handleUnionValueChange(Type.GLOSSARY_ITEM, oldValue, this.glossaryItem);
        }

        @Override
        public final Builder glossaryItem(GlossaryItem glossaryItem) {
            GlossaryItem oldValue = this.glossaryItem;
            this.glossaryItem = glossaryItem;
            this.handleUnionValueChange(Type.GLOSSARY_ITEM, oldValue, this.glossaryItem);
            return this;
        }

        public final GlossaryTermItem.Builder getGlossaryTermItem() {
            return this.glossaryTermItem != null ? this.glossaryTermItem.toBuilder() : null;
        }

        public final void setGlossaryTermItem(GlossaryTermItem.BuilderImpl glossaryTermItem) {
            GlossaryTermItem oldValue = this.glossaryTermItem;
            this.glossaryTermItem = glossaryTermItem != null ? glossaryTermItem.build() : null;
            this.handleUnionValueChange(Type.GLOSSARY_TERM_ITEM, oldValue, this.glossaryTermItem);
        }

        @Override
        public final Builder glossaryTermItem(GlossaryTermItem glossaryTermItem) {
            GlossaryTermItem oldValue = this.glossaryTermItem;
            this.glossaryTermItem = glossaryTermItem;
            this.handleUnionValueChange(Type.GLOSSARY_TERM_ITEM, oldValue, this.glossaryTermItem);
            return this;
        }

        public SearchInventoryResultItem build() {
            return new SearchInventoryResultItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchInventoryResultItem> {
        public Builder assetItem(AssetItem var1);

        default public Builder assetItem(Consumer<AssetItem.Builder> assetItem) {
            return this.assetItem((AssetItem)((AssetItem.Builder)AssetItem.builder().applyMutation(assetItem)).build());
        }

        public Builder dataProductItem(DataProductResultItem var1);

        default public Builder dataProductItem(Consumer<DataProductResultItem.Builder> dataProductItem) {
            return this.dataProductItem((DataProductResultItem)((DataProductResultItem.Builder)DataProductResultItem.builder().applyMutation(dataProductItem)).build());
        }

        public Builder glossaryItem(GlossaryItem var1);

        default public Builder glossaryItem(Consumer<GlossaryItem.Builder> glossaryItem) {
            return this.glossaryItem((GlossaryItem)((GlossaryItem.Builder)GlossaryItem.builder().applyMutation(glossaryItem)).build());
        }

        public Builder glossaryTermItem(GlossaryTermItem var1);

        default public Builder glossaryTermItem(Consumer<GlossaryTermItem.Builder> glossaryTermItem) {
            return this.glossaryTermItem((GlossaryTermItem)((GlossaryTermItem.Builder)GlossaryTermItem.builder().applyMutation(glossaryTermItem)).build());
        }
    }
}

