/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.DomainUnitPolicyGrantPrincipal;
import software.amazon.awssdk.services.datazone.model.GroupPolicyGrantPrincipal;
import software.amazon.awssdk.services.datazone.model.ProjectPolicyGrantPrincipal;
import software.amazon.awssdk.services.datazone.model.UserPolicyGrantPrincipal;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyGrantPrincipal
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyGrantPrincipal> {
    private static final SdkField<DomainUnitPolicyGrantPrincipal> DOMAIN_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("domainUnit").getter(PolicyGrantPrincipal.getter(PolicyGrantPrincipal::domainUnit)).setter(PolicyGrantPrincipal.setter(Builder::domainUnit)).constructor(DomainUnitPolicyGrantPrincipal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainUnit").build()}).build();
    private static final SdkField<GroupPolicyGrantPrincipal> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("group").getter(PolicyGrantPrincipal.getter(PolicyGrantPrincipal::group)).setter(PolicyGrantPrincipal.setter(Builder::group)).constructor(GroupPolicyGrantPrincipal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()}).build();
    private static final SdkField<ProjectPolicyGrantPrincipal> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("project").getter(PolicyGrantPrincipal.getter(PolicyGrantPrincipal::project)).setter(PolicyGrantPrincipal.setter(Builder::project)).constructor(ProjectPolicyGrantPrincipal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("project").build()}).build();
    private static final SdkField<UserPolicyGrantPrincipal> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("user").getter(PolicyGrantPrincipal.getter(PolicyGrantPrincipal::user)).setter(PolicyGrantPrincipal.setter(Builder::user)).constructor(UserPolicyGrantPrincipal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_UNIT_FIELD, GROUP_FIELD, PROJECT_FIELD, USER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PolicyGrantPrincipal.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DomainUnitPolicyGrantPrincipal domainUnit;
    private final GroupPolicyGrantPrincipal group;
    private final ProjectPolicyGrantPrincipal project;
    private final UserPolicyGrantPrincipal user;
    private final Type type;

    private PolicyGrantPrincipal(BuilderImpl builder) {
        this.domainUnit = builder.domainUnit;
        this.group = builder.group;
        this.project = builder.project;
        this.user = builder.user;
        this.type = builder.type;
    }

    public final DomainUnitPolicyGrantPrincipal domainUnit() {
        return this.domainUnit;
    }

    public final GroupPolicyGrantPrincipal group() {
        return this.group;
    }

    public final ProjectPolicyGrantPrincipal project() {
        return this.project;
    }

    public final UserPolicyGrantPrincipal user() {
        return this.user;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainUnit());
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyGrantPrincipal)) {
            return false;
        }
        PolicyGrantPrincipal other = (PolicyGrantPrincipal)obj;
        return Objects.equals(this.domainUnit(), other.domainUnit()) && Objects.equals(this.group(), other.group()) && Objects.equals(this.project(), other.project()) && Objects.equals(this.user(), other.user());
    }

    public final String toString() {
        return ToString.builder((String)"PolicyGrantPrincipal").add("DomainUnit", (Object)this.domainUnit()).add("Group", (Object)this.group()).add("Project", (Object)this.project()).add("User", (Object)this.user()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainUnit": {
                return Optional.ofNullable(clazz.cast(this.domainUnit()));
            }
            case "group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
            case "user": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
        }
        return Optional.empty();
    }

    public static PolicyGrantPrincipal fromDomainUnit(DomainUnitPolicyGrantPrincipal domainUnit) {
        return (PolicyGrantPrincipal)PolicyGrantPrincipal.builder().domainUnit(domainUnit).build();
    }

    public static PolicyGrantPrincipal fromDomainUnit(Consumer<DomainUnitPolicyGrantPrincipal.Builder> domainUnit) {
        DomainUnitPolicyGrantPrincipal.Builder builder = DomainUnitPolicyGrantPrincipal.builder();
        domainUnit.accept(builder);
        return PolicyGrantPrincipal.fromDomainUnit((DomainUnitPolicyGrantPrincipal)builder.build());
    }

    public static PolicyGrantPrincipal fromGroup(GroupPolicyGrantPrincipal group) {
        return (PolicyGrantPrincipal)PolicyGrantPrincipal.builder().group(group).build();
    }

    public static PolicyGrantPrincipal fromGroup(Consumer<GroupPolicyGrantPrincipal.Builder> group) {
        GroupPolicyGrantPrincipal.Builder builder = GroupPolicyGrantPrincipal.builder();
        group.accept(builder);
        return PolicyGrantPrincipal.fromGroup((GroupPolicyGrantPrincipal)builder.build());
    }

    public static PolicyGrantPrincipal fromProject(ProjectPolicyGrantPrincipal project) {
        return (PolicyGrantPrincipal)PolicyGrantPrincipal.builder().project(project).build();
    }

    public static PolicyGrantPrincipal fromProject(Consumer<ProjectPolicyGrantPrincipal.Builder> project) {
        ProjectPolicyGrantPrincipal.Builder builder = ProjectPolicyGrantPrincipal.builder();
        project.accept(builder);
        return PolicyGrantPrincipal.fromProject((ProjectPolicyGrantPrincipal)builder.build());
    }

    public static PolicyGrantPrincipal fromUser(UserPolicyGrantPrincipal user) {
        return (PolicyGrantPrincipal)PolicyGrantPrincipal.builder().user(user).build();
    }

    public static PolicyGrantPrincipal fromUser(Consumer<UserPolicyGrantPrincipal.Builder> user) {
        UserPolicyGrantPrincipal.Builder builder = UserPolicyGrantPrincipal.builder();
        user.accept(builder);
        return PolicyGrantPrincipal.fromUser((UserPolicyGrantPrincipal)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domainUnit", DOMAIN_UNIT_FIELD);
        map.put("group", GROUP_FIELD);
        map.put("project", PROJECT_FIELD);
        map.put("user", USER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PolicyGrantPrincipal, T> g) {
        return obj -> g.apply((PolicyGrantPrincipal)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        DOMAIN_UNIT,
        GROUP,
        PROJECT,
        USER,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private DomainUnitPolicyGrantPrincipal domainUnit;
        private GroupPolicyGrantPrincipal group;
        private ProjectPolicyGrantPrincipal project;
        private UserPolicyGrantPrincipal user;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyGrantPrincipal model) {
            this.domainUnit(model.domainUnit);
            this.group(model.group);
            this.project(model.project);
            this.user(model.user);
        }

        public final DomainUnitPolicyGrantPrincipal.Builder getDomainUnit() {
            return this.domainUnit != null ? this.domainUnit.toBuilder() : null;
        }

        public final void setDomainUnit(DomainUnitPolicyGrantPrincipal.BuilderImpl domainUnit) {
            DomainUnitPolicyGrantPrincipal oldValue = this.domainUnit;
            this.domainUnit = domainUnit != null ? domainUnit.build() : null;
            this.handleUnionValueChange(Type.DOMAIN_UNIT, oldValue, this.domainUnit);
        }

        @Override
        public final Builder domainUnit(DomainUnitPolicyGrantPrincipal domainUnit) {
            DomainUnitPolicyGrantPrincipal oldValue = this.domainUnit;
            this.domainUnit = domainUnit;
            this.handleUnionValueChange(Type.DOMAIN_UNIT, oldValue, this.domainUnit);
            return this;
        }

        public final GroupPolicyGrantPrincipal.Builder getGroup() {
            return this.group != null ? this.group.toBuilder() : null;
        }

        public final void setGroup(GroupPolicyGrantPrincipal.BuilderImpl group) {
            GroupPolicyGrantPrincipal oldValue = this.group;
            this.group = group != null ? group.build() : null;
            this.handleUnionValueChange(Type.GROUP, oldValue, this.group);
        }

        @Override
        public final Builder group(GroupPolicyGrantPrincipal group) {
            GroupPolicyGrantPrincipal oldValue = this.group;
            this.group = group;
            this.handleUnionValueChange(Type.GROUP, oldValue, this.group);
            return this;
        }

        public final ProjectPolicyGrantPrincipal.Builder getProject() {
            return this.project != null ? this.project.toBuilder() : null;
        }

        public final void setProject(ProjectPolicyGrantPrincipal.BuilderImpl project) {
            ProjectPolicyGrantPrincipal oldValue = this.project;
            this.project = project != null ? project.build() : null;
            this.handleUnionValueChange(Type.PROJECT, oldValue, this.project);
        }

        @Override
        public final Builder project(ProjectPolicyGrantPrincipal project) {
            ProjectPolicyGrantPrincipal oldValue = this.project;
            this.project = project;
            this.handleUnionValueChange(Type.PROJECT, oldValue, this.project);
            return this;
        }

        public final UserPolicyGrantPrincipal.Builder getUser() {
            return this.user != null ? this.user.toBuilder() : null;
        }

        public final void setUser(UserPolicyGrantPrincipal.BuilderImpl user) {
            UserPolicyGrantPrincipal oldValue = this.user;
            this.user = user != null ? user.build() : null;
            this.handleUnionValueChange(Type.USER, oldValue, this.user);
        }

        @Override
        public final Builder user(UserPolicyGrantPrincipal user) {
            UserPolicyGrantPrincipal oldValue = this.user;
            this.user = user;
            this.handleUnionValueChange(Type.USER, oldValue, this.user);
            return this;
        }

        public PolicyGrantPrincipal build() {
            return new PolicyGrantPrincipal(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyGrantPrincipal> {
        public Builder domainUnit(DomainUnitPolicyGrantPrincipal var1);

        default public Builder domainUnit(Consumer<DomainUnitPolicyGrantPrincipal.Builder> domainUnit) {
            return this.domainUnit((DomainUnitPolicyGrantPrincipal)((DomainUnitPolicyGrantPrincipal.Builder)DomainUnitPolicyGrantPrincipal.builder().applyMutation(domainUnit)).build());
        }

        public Builder group(GroupPolicyGrantPrincipal var1);

        default public Builder group(Consumer<GroupPolicyGrantPrincipal.Builder> group) {
            return this.group((GroupPolicyGrantPrincipal)((GroupPolicyGrantPrincipal.Builder)GroupPolicyGrantPrincipal.builder().applyMutation(group)).build());
        }

        public Builder project(ProjectPolicyGrantPrincipal var1);

        default public Builder project(Consumer<ProjectPolicyGrantPrincipal.Builder> project) {
            return this.project((ProjectPolicyGrantPrincipal)((ProjectPolicyGrantPrincipal.Builder)ProjectPolicyGrantPrincipal.builder().applyMutation(project)).build());
        }

        public Builder user(UserPolicyGrantPrincipal var1);

        default public Builder user(Consumer<UserPolicyGrantPrincipal.Builder> user) {
            return this.user((UserPolicyGrantPrincipal)((UserPolicyGrantPrincipal.Builder)UserPolicyGrantPrincipal.builder().applyMutation(user)).build());
        }
    }
}

