/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.AllUsersGrantFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserPolicyGrantPrincipal
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserPolicyGrantPrincipal> {
    private static final SdkField<AllUsersGrantFilter> ALL_USERS_GRANT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("allUsersGrantFilter").getter(UserPolicyGrantPrincipal.getter(UserPolicyGrantPrincipal::allUsersGrantFilter)).setter(UserPolicyGrantPrincipal.setter(Builder::allUsersGrantFilter)).constructor(AllUsersGrantFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allUsersGrantFilter").build()}).build();
    private static final SdkField<String> USER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userIdentifier").getter(UserPolicyGrantPrincipal.getter(UserPolicyGrantPrincipal::userIdentifier)).setter(UserPolicyGrantPrincipal.setter(Builder::userIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALL_USERS_GRANT_FILTER_FIELD, USER_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UserPolicyGrantPrincipal.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AllUsersGrantFilter allUsersGrantFilter;
    private final String userIdentifier;
    private final Type type;

    private UserPolicyGrantPrincipal(BuilderImpl builder) {
        this.allUsersGrantFilter = builder.allUsersGrantFilter;
        this.userIdentifier = builder.userIdentifier;
        this.type = builder.type;
    }

    public final AllUsersGrantFilter allUsersGrantFilter() {
        return this.allUsersGrantFilter;
    }

    public final String userIdentifier() {
        return this.userIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allUsersGrantFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.userIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPolicyGrantPrincipal)) {
            return false;
        }
        UserPolicyGrantPrincipal other = (UserPolicyGrantPrincipal)obj;
        return Objects.equals(this.allUsersGrantFilter(), other.allUsersGrantFilter()) && Objects.equals(this.userIdentifier(), other.userIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"UserPolicyGrantPrincipal").add("AllUsersGrantFilter", (Object)this.allUsersGrantFilter()).add("UserIdentifier", (Object)this.userIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allUsersGrantFilter": {
                return Optional.ofNullable(clazz.cast(this.allUsersGrantFilter()));
            }
            case "userIdentifier": {
                return Optional.ofNullable(clazz.cast(this.userIdentifier()));
            }
        }
        return Optional.empty();
    }

    public static UserPolicyGrantPrincipal fromAllUsersGrantFilter(AllUsersGrantFilter allUsersGrantFilter) {
        return (UserPolicyGrantPrincipal)UserPolicyGrantPrincipal.builder().allUsersGrantFilter(allUsersGrantFilter).build();
    }

    public static UserPolicyGrantPrincipal fromAllUsersGrantFilter(Consumer<AllUsersGrantFilter.Builder> allUsersGrantFilter) {
        AllUsersGrantFilter.Builder builder = AllUsersGrantFilter.builder();
        allUsersGrantFilter.accept(builder);
        return UserPolicyGrantPrincipal.fromAllUsersGrantFilter((AllUsersGrantFilter)builder.build());
    }

    public static UserPolicyGrantPrincipal fromUserIdentifier(String userIdentifier) {
        return (UserPolicyGrantPrincipal)UserPolicyGrantPrincipal.builder().userIdentifier(userIdentifier).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("allUsersGrantFilter", ALL_USERS_GRANT_FILTER_FIELD);
        map.put("userIdentifier", USER_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserPolicyGrantPrincipal, T> g) {
        return obj -> g.apply((UserPolicyGrantPrincipal)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ALL_USERS_GRANT_FILTER,
        USER_IDENTIFIER,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AllUsersGrantFilter allUsersGrantFilter;
        private String userIdentifier;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(UserPolicyGrantPrincipal model) {
            this.allUsersGrantFilter(model.allUsersGrantFilter);
            this.userIdentifier(model.userIdentifier);
        }

        public final AllUsersGrantFilter.Builder getAllUsersGrantFilter() {
            return this.allUsersGrantFilter != null ? this.allUsersGrantFilter.toBuilder() : null;
        }

        public final void setAllUsersGrantFilter(AllUsersGrantFilter.BuilderImpl allUsersGrantFilter) {
            AllUsersGrantFilter oldValue = this.allUsersGrantFilter;
            this.allUsersGrantFilter = allUsersGrantFilter != null ? allUsersGrantFilter.build() : null;
            this.handleUnionValueChange(Type.ALL_USERS_GRANT_FILTER, oldValue, this.allUsersGrantFilter);
        }

        @Override
        public final Builder allUsersGrantFilter(AllUsersGrantFilter allUsersGrantFilter) {
            AllUsersGrantFilter oldValue = this.allUsersGrantFilter;
            this.allUsersGrantFilter = allUsersGrantFilter;
            this.handleUnionValueChange(Type.ALL_USERS_GRANT_FILTER, oldValue, this.allUsersGrantFilter);
            return this;
        }

        public final String getUserIdentifier() {
            return this.userIdentifier;
        }

        public final void setUserIdentifier(String userIdentifier) {
            String oldValue = this.userIdentifier;
            this.userIdentifier = userIdentifier;
            this.handleUnionValueChange(Type.USER_IDENTIFIER, oldValue, this.userIdentifier);
        }

        @Override
        public final Builder userIdentifier(String userIdentifier) {
            String oldValue = this.userIdentifier;
            this.userIdentifier = userIdentifier;
            this.handleUnionValueChange(Type.USER_IDENTIFIER, oldValue, this.userIdentifier);
            return this;
        }

        public UserPolicyGrantPrincipal build() {
            return new UserPolicyGrantPrincipal(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserPolicyGrantPrincipal> {
        public Builder allUsersGrantFilter(AllUsersGrantFilter var1);

        default public Builder allUsersGrantFilter(Consumer<AllUsersGrantFilter.Builder> allUsersGrantFilter) {
            return this.allUsersGrantFilter((AllUsersGrantFilter)((AllUsersGrantFilter.Builder)AllUsersGrantFilter.builder().applyMutation(allUsersGrantFilter)).build());
        }

        public Builder userIdentifier(String var1);
    }
}

