/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.AuthType;
import software.amazon.awssdk.services.datazone.model.UserAssignment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SingleSignOn
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SingleSignOn> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(SingleSignOn.getter(SingleSignOn::typeAsString)).setter(SingleSignOn.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> USER_ASSIGNMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userAssignment").getter(SingleSignOn.getter(SingleSignOn::userAssignmentAsString)).setter(SingleSignOn.setter(Builder::userAssignment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAssignment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, USER_ASSIGNMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SingleSignOn.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String userAssignment;

    private SingleSignOn(BuilderImpl builder) {
        this.type = builder.type;
        this.userAssignment = builder.userAssignment;
    }

    public final AuthType type() {
        return AuthType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final UserAssignment userAssignment() {
        return UserAssignment.fromValue(this.userAssignment);
    }

    public final String userAssignmentAsString() {
        return this.userAssignment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAssignmentAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SingleSignOn)) {
            return false;
        }
        SingleSignOn other = (SingleSignOn)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.userAssignmentAsString(), other.userAssignmentAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SingleSignOn").add("Type", (Object)this.typeAsString()).add("UserAssignment", (Object)this.userAssignmentAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "userAssignment": {
                return Optional.ofNullable(clazz.cast(this.userAssignmentAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("type", TYPE_FIELD);
        map.put("userAssignment", USER_ASSIGNMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SingleSignOn, T> g) {
        return obj -> g.apply((SingleSignOn)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String userAssignment;

        private BuilderImpl() {
        }

        private BuilderImpl(SingleSignOn model) {
            this.type(model.type);
            this.userAssignment(model.userAssignment);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AuthType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getUserAssignment() {
            return this.userAssignment;
        }

        public final void setUserAssignment(String userAssignment) {
            this.userAssignment = userAssignment;
        }

        @Override
        public final Builder userAssignment(String userAssignment) {
            this.userAssignment = userAssignment;
            return this;
        }

        @Override
        public final Builder userAssignment(UserAssignment userAssignment) {
            this.userAssignment(userAssignment == null ? null : userAssignment.toString());
            return this;
        }

        public SingleSignOn build() {
            return new SingleSignOn(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SingleSignOn> {
        public Builder type(String var1);

        public Builder type(AuthType var1);

        public Builder userAssignment(String var1);

        public Builder userAssignment(UserAssignment var1);
    }
}

