/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RejectRuleBehavior {
    ALL("ALL"),
    NONE("NONE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RejectRuleBehavior> VALUE_MAP;
    private final String value;

    private RejectRuleBehavior(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RejectRuleBehavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RejectRuleBehavior> knownValues() {
        EnumSet<RejectRuleBehavior> knownValues = EnumSet.allOf(RejectRuleBehavior.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RejectRuleBehavior.class, RejectRuleBehavior::toString);
    }
}

